/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.ProducerAwareProperty;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.provider.Provider;
import org.gradle.util.DeferredUtil;

public class StaticValue
implements ValidatingValue {
    private final Object value;

    public StaticValue(@Nullable Object value) {
        this.value = value;
    }

    @Override
    public void attachProducer(Task producer) {
        if (this.value instanceof ProducerAwareProperty) {
            ((ProducerAwareProperty)this.value).attachProducer(producer);
        }
    }

    @Override
    public void maybeFinalizeValue() {
        if (this.value instanceof PropertyInternal) {
            ((PropertyInternal)this.value).finalizeValueOnReadAndWarnAboutChanges();
        }
    }

    @Override
    @Nullable
    public Object call() {
        if (this.value instanceof Provider && !((Provider)this.value).isPresent()) {
            return null;
        }
        return this.value;
    }

    @Override
    public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
        Object unpacked = DeferredUtil.unpack(this.call());
        if (unpacked == null) {
            if (!optional) {
                context.recordValidationMessage(String.format("No value has been specified for property '%s'.", propertyName));
            }
        } else {
            valueValidator.validate(propertyName, unpacked, context);
        }
    }
}

