/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.DeclaredTaskInputProperty;
import org.gradle.api.internal.tasks.TaskInputsDeprecationSupport;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationActions;
import org.gradle.api.tasks.TaskInputPropertyBuilder;

@NonNullApi
public class DefaultTaskInputPropertySpec
extends TaskInputsDeprecationSupport
implements DeclaredTaskInputProperty {
    private final String propertyName;
    private final ValidatingValue value;
    private boolean optional;

    public DefaultTaskInputPropertySpec(String propertyName, ValidatingValue value) {
        this.propertyName = propertyName;
        this.value = value;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public TaskInputPropertyBuilder optional(boolean optional) {
        this.optional = optional;
        return this;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.value.call();
    }

    @Override
    public void prepareValue() {
        this.value.maybeFinalizeValue();
    }

    @Override
    public void cleanupValue() {
    }

    @Override
    public void validate(TaskValidationContext context) {
        this.value.validate(this.getPropertyName(), this.optional, ValidationActions.NO_OP, context);
    }

    @Override
    public int compareTo(TaskPropertySpec o) {
        return this.getPropertyName().compareTo(o.getPropertyName());
    }

    public String toString() {
        return this.propertyName;
    }
}

