/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.project.CrossProjectConfigurator;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.DefaultTaskContainer;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskStatistics;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.BiAction;
import org.gradle.internal.Factory;
import org.gradle.internal.model.RuleBasedPluginListener;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.collection.internal.BridgedCollections;
import org.gradle.model.internal.core.ChildNodeInitializerStrategyAccessors;
import org.gradle.model.internal.core.DirectNodeNoInputsModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelMapModelProjection;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.NodeBackedModelMap;
import org.gradle.model.internal.core.NodePredicate;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;

public class DefaultTaskContainerFactory
implements Factory<TaskContainerInternal> {
    private static final ModelType<DefaultTaskContainer> DEFAULT_TASK_CONTAINER_MODEL_TYPE = ModelType.of(DefaultTaskContainer.class);
    private static final ModelType<TaskContainer> TASK_CONTAINER_MODEL_TYPE = ModelType.of(TaskContainer.class);
    private static final ModelType<Task> TASK_MODEL_TYPE = ModelType.of(Task.class);
    private static final ModelReference<Task> TASK_MODEL_REFERENCE = ModelReference.of(TASK_MODEL_TYPE);
    private static final SimpleModelRuleDescriptor COPY_TO_TASK_CONTAINER_DESCRIPTOR = new SimpleModelRuleDescriptor("copyToTaskContainer");
    private final ModelRegistry modelRegistry;
    private final Instantiator instantiator;
    private final ITaskFactory taskFactory;
    private final CollectionCallbackActionDecorator callbackDecorator;
    private Project project;
    private final ProjectAccessListener projectAccessListener;
    private final TaskStatistics statistics;
    private final BuildOperationExecutor buildOperationExecutor;
    private final CrossProjectConfigurator crossProjectConfigurator;

    public DefaultTaskContainerFactory(ModelRegistry modelRegistry, Instantiator instantiator, ITaskFactory taskFactory, Project project, ProjectAccessListener projectAccessListener, TaskStatistics statistics, BuildOperationExecutor buildOperationExecutor, CrossProjectConfigurator crossProjectConfigurator, CollectionCallbackActionDecorator callbackDecorator) {
        this.modelRegistry = modelRegistry;
        this.instantiator = instantiator;
        this.taskFactory = taskFactory;
        this.project = project;
        this.projectAccessListener = projectAccessListener;
        this.statistics = statistics;
        this.buildOperationExecutor = buildOperationExecutor;
        this.crossProjectConfigurator = crossProjectConfigurator;
        this.callbackDecorator = callbackDecorator;
    }

    @Override
    public TaskContainerInternal create() {
        DefaultTaskContainer tasks = this.instantiator.newInstance(DefaultTaskContainer.class, this.project, this.instantiator, this.taskFactory, this.projectAccessListener, this.statistics, this.buildOperationExecutor, this.crossProjectConfigurator, this.callbackDecorator);
        this.bridgeIntoSoftwareModelWhenNeeded(tasks);
        return tasks;
    }

    private void bridgeIntoSoftwareModelWhenNeeded(final DefaultTaskContainer tasks) {
        ((ProjectInternal)this.project).addRuleBasedPluginListener(new RuleBasedPluginListener(){

            @Override
            public void prepareForRuleBasedPlugins(Project project) {
                ModelReference containerReference = ModelReference.of(TaskContainerInternal.MODEL_PATH, DEFAULT_TASK_CONTAINER_MODEL_TYPE);
                ModelRegistrations.Builder registrationBuilder = BridgedCollections.registration(containerReference, new Transformer<DefaultTaskContainer, MutableModelNode>(){

                    @Override
                    public DefaultTaskContainer transform(MutableModelNode mutableModelNode) {
                        tasks.setModelNode(mutableModelNode);
                        return tasks;
                    }
                }, new Task.Namer(), "Project.<init>.tasks()", new Namer());
                DefaultTaskContainerFactory.this.modelRegistry.register(registrationBuilder.withProjection(ModelMapModelProjection.unmanaged(TASK_MODEL_TYPE, ChildNodeInitializerStrategyAccessors.of(NodeBackedModelMap.createUsingParentNode(new Transformer<NamedEntityInstantiator<Task>, MutableModelNode>(){

                    @Override
                    public NamedEntityInstantiator<Task> transform(MutableModelNode modelNode) {
                        return ((DefaultTaskContainer)modelNode.getPrivateData(DEFAULT_TASK_CONTAINER_MODEL_TYPE)).getEntityInstantiator();
                    }
                })))).withProjection(UnmanagedModelProjection.of(TASK_CONTAINER_MODEL_TYPE)).build());
                ModelNode modelNode = DefaultTaskContainerFactory.this.modelRegistry.atStateOrLater(TaskContainerInternal.MODEL_PATH, ModelNode.State.Created);
                MutableModelNode mutableModelNode = (MutableModelNode)modelNode;
                mutableModelNode.applyTo(NodePredicate.allLinks(), ModelActionRole.Initialize, DirectNodeNoInputsModelAction.of(TASK_MODEL_REFERENCE, (ModelRuleDescriptor)COPY_TO_TASK_CONTAINER_DESCRIPTOR, new BiAction<MutableModelNode, Task>(){

                    @Override
                    public void execute(MutableModelNode modelNode, Task task) {
                        TaskContainerInternal taskContainer = modelNode.getParent().getPrivateData(TaskContainerInternal.MODEL_TYPE);
                        taskContainer.addInternal(task);
                    }
                }));
            }
        });
    }

    private static class Namer
    implements Transformer<String, String> {
        private Namer() {
        }

        @Override
        public String transform(String s) {
            return "Project.<init>.tasks." + s + "()";
        }
    }
}

