/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.TransformBackedProvider;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.util.GUtil;

public abstract class AbstractMinimalProvider<T>
implements ProviderInternal<T> {
    @Override
    public <S> ProviderInternal<S> map(Transformer<? extends S, ? super T> transformer) {
        return new TransformBackedProvider<S, T>(transformer, this);
    }

    @Override
    public <S> Provider<S> flatMap(Transformer<? extends Provider<? extends S>, ? super T> transformer) {
        return new FlatMapProvider(this, transformer);
    }

    @Override
    public boolean isPresent() {
        return this.getOrNull() != null;
    }

    @Override
    public T getOrElse(T defaultValue) {
        Object value = this.getOrNull();
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        return false;
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        if (!this.maybeVisitBuildDependencies(context)) {
            Object value = this.get();
            if (value instanceof Collection) {
                Collection items = (Collection)value;
                for (Object item : items) {
                    context.maybeAdd(item);
                }
            } else {
                context.maybeAdd(value);
            }
        }
    }

    @Override
    public ProviderInternal<T> withFinalValue() {
        Object value = this.getOrNull();
        if (value == null) {
            return Providers.notDefined();
        }
        return Providers.of(value);
    }

    public String toString() {
        return String.format("provider(%s)", GUtil.elvis(this.getType(), "?"));
    }

    private static class FlatMapProvider<S, T>
    extends AbstractMinimalProvider<S> {
        private final Provider<? extends T> provider;
        private final Transformer<? extends Provider<? extends S>, ? super T> transformer;

        FlatMapProvider(ProviderInternal<? extends T> provider, Transformer<? extends Provider<? extends S>, ? super T> transformer) {
            this.provider = provider;
            this.transformer = transformer;
        }

        @Override
        @Nullable
        public Class<S> getType() {
            return null;
        }

        @Override
        public boolean isPresent() {
            T value = this.provider.getOrNull();
            if (value == null) {
                return false;
            }
            return this.map(value).isPresent();
        }

        @Override
        public S get() {
            T value = this.provider.get();
            return this.map(value).get();
        }

        @Override
        @Nullable
        public S getOrNull() {
            T value = this.provider.getOrNull();
            if (value == null) {
                return null;
            }
            return this.map(value).getOrNull();
        }

        private Provider<? extends S> map(T value) {
            Provider<? extends S> result = this.transformer.transform(value);
            if (result == null) {
                throw new IllegalStateException("Transformer for this provider returned a null value.");
            }
            return result;
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return Providers.internal(this.map(this.provider.get())).maybeVisitBuildDependencies(context);
        }

        @Override
        public String toString() {
            return "flatmap(" + this.provider + ")";
        }
    }
}

