/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.Pair;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;

public class DefaultProjectStateRegistry
implements ProjectStateRegistry {
    private final WorkerLeaseService workerLeaseService;
    private final Object lock = new Object();
    private final Map<Path, ProjectStateImpl> projectsByPath = Maps.newLinkedHashMap();
    private final Map<ProjectComponentIdentifier, ProjectStateImpl> projectsById = Maps.newLinkedHashMap();
    private final Map<Pair<BuildIdentifier, Path>, ProjectStateImpl> projectsByCompId = Maps.newLinkedHashMap();
    private static final ThreadLocal<Boolean> LENIENT_MUTATION_STATE = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public DefaultProjectStateRegistry(WorkerLeaseService workerLeaseService) {
        this.workerLeaseService = workerLeaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProjects(BuildState owner) {
        Set<DefaultProjectDescriptor> allProjects = owner.getLoadedSettings().getProjectRegistry().getAllProjects();
        Object object = this.lock;
        synchronized (object) {
            for (DefaultProjectDescriptor descriptor : allProjects) {
                Path identityPath = owner.getIdentityPathForProject(descriptor.path());
                ProjectComponentIdentifier projectIdentifier = owner.getIdentifierForProject(descriptor.path());
                ProjectStateImpl projectState = new ProjectStateImpl(owner, identityPath, descriptor.getName(), projectIdentifier);
                this.projectsByPath.put(identityPath, projectState);
                this.projectsById.put(projectIdentifier, projectState);
                this.projectsByCompId.put(Pair.of(owner.getBuildIdentifier(), descriptor.path()), projectState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(BuildState owner, ProjectInternal project) {
        Object object = this.lock;
        synchronized (object) {
            Path identityPath = project.getIdentityPath();
            ProjectComponentIdentifier projectIdentifier = owner.getIdentifierForProject(project.getProjectPath());
            ProjectStateImpl projectState = new ProjectStateImpl(owner, identityPath, project.getName(), projectIdentifier);
            this.projectsByPath.put(projectState.projectIdentityPath, projectState);
            this.projectsById.put(projectState.identifier, projectState);
            this.projectsByCompId.put(Pair.of(owner.getBuildIdentifier(), project.getProjectPath()), projectState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ProjectStateImpl> getAllProjects() {
        Object object = this.lock;
        synchronized (object) {
            return this.projectsByPath.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectState stateFor(Project project) {
        Object object = this.lock;
        synchronized (object) {
            ProjectStateImpl projectState = this.projectsByPath.get(((ProjectInternal)project).getIdentityPath());
            if (projectState == null) {
                throw new IllegalArgumentException("Could not find state for " + project);
            }
            return projectState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectState stateFor(ProjectComponentIdentifier identifier) {
        Object object = this.lock;
        synchronized (object) {
            ProjectStateImpl projectState = this.projectsById.get(identifier);
            if (projectState == null) {
                throw new IllegalArgumentException(identifier.getDisplayName() + " not found.");
            }
            return projectState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectState stateFor(BuildIdentifier buildIdentifier, Path projectPath) {
        Object object = this.lock;
        synchronized (object) {
            ProjectStateImpl projectState = this.projectsByCompId.get(Pair.of(buildIdentifier, projectPath));
            if (projectState == null) {
                throw new IllegalArgumentException(buildIdentifier + " project " + projectPath + " not found.");
            }
            return projectState;
        }
    }

    @Override
    public void withLenientState(Runnable runnable) {
        this.withLenientState(Factories.toFactory(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withLenientState(Factory<T> factory) {
        Boolean originalState = LENIENT_MUTATION_STATE.get();
        LENIENT_MUTATION_STATE.set(true);
        try {
            T t = factory.create();
            return t;
        }
        finally {
            LENIENT_MUTATION_STATE.set(originalState);
        }
    }

    @Override
    public ProjectStateRegistry.SafeExclusiveLock newExclusiveOperationLock() {
        return new SafeExclusiveLockImpl();
    }

    private class SafeExclusiveLockImpl
    implements ProjectStateRegistry.SafeExclusiveLock {
        private final ReentrantLock lock = new ReentrantLock();

        private SafeExclusiveLockImpl() {
        }

        @Override
        public void withLock(Runnable runnable) {
            try {
                if (this.lock.tryLock()) {
                    runnable.run();
                } else {
                    DefaultProjectStateRegistry.this.workerLeaseService.withoutProjectLock(new Runnable(){

                        @Override
                        public void run() {
                            SafeExclusiveLockImpl.this.lock.lock();
                        }
                    });
                    runnable.run();
                }
            }
            finally {
                if (this.lock.isHeldByCurrentThread()) {
                    this.lock.unlock();
                }
            }
        }
    }

    private class ProjectStateImpl
    implements ProjectState {
        private final String projectName;
        private final ProjectComponentIdentifier identifier;
        private final BuildState owner;
        private final Path projectIdentityPath;
        private final ResourceLock projectLock;

        ProjectStateImpl(BuildState owner, Path projectIdentityPath, String projectName, ProjectComponentIdentifier identifier) {
            this.owner = owner;
            this.projectIdentityPath = projectIdentityPath;
            this.projectName = projectName;
            this.identifier = identifier;
            this.projectLock = DefaultProjectStateRegistry.this.workerLeaseService.getProjectLock(owner.getIdentityPath(), projectIdentityPath);
        }

        public String toString() {
            return this.identifier.getDisplayName();
        }

        @Override
        public BuildState getOwner() {
            return this.owner;
        }

        @Override
        @Nullable
        public ProjectState getParent() {
            return this.projectIdentityPath.getParent() == null ? null : (ProjectStateImpl)DefaultProjectStateRegistry.this.projectsByPath.get(this.projectIdentityPath.getParent());
        }

        @Override
        public String getName() {
            return this.projectName;
        }

        @Override
        public ProjectComponentIdentifier getComponentIdentifier() {
            return this.identifier;
        }

        @Override
        public <T> void withMutableState(Runnable action) {
            this.withMutableState(Factories.toFactory(action));
        }

        @Override
        public <T> T withMutableState(final Factory<? extends T> factory) {
            if (((Boolean)LENIENT_MUTATION_STATE.get()).booleanValue()) {
                return factory.create();
            }
            ArrayList currentLocks = DefaultProjectStateRegistry.this.workerLeaseService.getCurrentProjectLocks();
            if (currentLocks.contains(this.projectLock)) {
                if (currentLocks.size() == 1) {
                    return factory.create();
                }
                currentLocks = Lists.newArrayList(currentLocks);
                currentLocks.remove(this.projectLock);
                return DefaultProjectStateRegistry.this.workerLeaseService.withoutLocks((Iterable<? extends ResourceLock>)currentLocks, factory);
            }
            if (!currentLocks.isEmpty()) {
                return DefaultProjectStateRegistry.this.workerLeaseService.withoutLocks((Iterable<? extends ResourceLock>)currentLocks, new Factory<T>(){

                    @Override
                    @Nullable
                    public T create() {
                        return ProjectStateImpl.this.withProjectLock(ProjectStateImpl.this.projectLock, factory);
                    }
                });
            }
            return this.withProjectLock(this.projectLock, factory);
        }

        private <T> T withProjectLock(ResourceLock projectLock, Factory<? extends T> factory) {
            return DefaultProjectStateRegistry.this.workerLeaseService.withLocks(Collections.singleton(projectLock), factory);
        }

        @Override
        public boolean hasMutableState() {
            return (Boolean)LENIENT_MUTATION_STATE.get() != false || DefaultProjectStateRegistry.this.workerLeaseService.getCurrentProjectLocks().contains(this.projectLock);
        }
    }
}

