/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.artifacts.dependencies.DefaultSelfResolvingDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.BuildDependenciesOnlyFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.SingletonFileSet;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarFactory;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarType;
import org.gradle.internal.component.local.model.OpaqueComponentIdentifier;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

public class DependencyClassPathNotationConverter
implements NotationConverter<DependencyFactory.ClassPathNotation, SelfResolvingDependency> {
    private final ClassPathRegistry classPathRegistry;
    private final Instantiator instantiator;
    private final FileResolver fileResolver;
    private final RuntimeShadedJarFactory runtimeShadedJarFactory;
    private final CurrentGradleInstallation currentGradleInstallation;
    private final ConcurrentMap<DependencyFactory.ClassPathNotation, SelfResolvingDependency> internCache = Maps.newConcurrentMap();

    public DependencyClassPathNotationConverter(Instantiator instantiator, ClassPathRegistry classPathRegistry, FileResolver fileResolver, RuntimeShadedJarFactory runtimeShadedJarFactory, CurrentGradleInstallation currentGradleInstallation) {
        this.instantiator = instantiator;
        this.classPathRegistry = classPathRegistry;
        this.fileResolver = fileResolver;
        this.runtimeShadedJarFactory = runtimeShadedJarFactory;
        this.currentGradleInstallation = currentGradleInstallation;
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("ClassPathNotation").example("gradleApi()");
    }

    @Override
    public void convert(DependencyFactory.ClassPathNotation notation, NotationConvertResult<? super SelfResolvingDependency> result) throws TypeConversionException {
        SelfResolvingDependency dependency = (SelfResolvingDependency)this.internCache.get((Object)notation);
        if (dependency == null) {
            dependency = this.create(notation);
        }
        result.converted(dependency);
    }

    private SelfResolvingDependency create(final DependencyFactory.ClassPathNotation notation) {
        boolean runningFromInstallation;
        boolean bl = runningFromInstallation = this.currentGradleInstallation.getInstallation() != null;
        FileCollectionInternal fileCollectionInternal = runningFromInstallation && notation.equals((Object)DependencyFactory.ClassPathNotation.GRADLE_API) ? new GeneratedFileCollection(notation.displayName){

            @Override
            FileCollection generateFileCollection() {
                return DependencyClassPathNotationConverter.this.gradleApiFileCollection(DependencyClassPathNotationConverter.this.getClassPath(notation));
            }
        } : (runningFromInstallation && notation.equals((Object)DependencyFactory.ClassPathNotation.GRADLE_TEST_KIT) ? new GeneratedFileCollection(notation.displayName){

            @Override
            FileCollection generateFileCollection() {
                return DependencyClassPathNotationConverter.this.gradleTestKitFileCollection(DependencyClassPathNotationConverter.this.getClassPath(notation));
            }
        } : this.fileResolver.resolveFiles(this.getClassPath(notation)));
        SelfResolvingDependency dependency = this.instantiator.newInstance(DefaultSelfResolvingDependency.class, new OpaqueComponentIdentifier(notation.displayName), fileCollectionInternal);
        SelfResolvingDependency alreadyPresent = this.internCache.putIfAbsent(notation, dependency);
        return alreadyPresent != null ? alreadyPresent : dependency;
    }

    private List<File> getClassPath(DependencyFactory.ClassPathNotation notation) {
        return Lists.newArrayList(this.classPathRegistry.getClassPath(notation.name()).getAsFiles());
    }

    private FileCollectionInternal gradleApiFileCollection(Collection<File> apiClasspath) {
        List<File> groovyImpl = this.classPathRegistry.getClassPath(DependencyFactory.ClassPathNotation.LOCAL_GROOVY.name()).getAsFiles();
        List<File> kotlinDsl = this.classPathRegistry.getClassPath(DependencyFactory.ClassPathNotation.GRADLE_KOTLIN_DSL.name()).getAsFiles();
        List<File> installationBeacon = this.classPathRegistry.getClassPath("GRADLE_INSTALLATION_BEACON").getAsFiles();
        apiClasspath.removeAll(groovyImpl);
        apiClasspath.removeAll(kotlinDsl);
        apiClasspath.removeAll(installationBeacon);
        return (FileCollectionInternal)this.relocatedDepsJar(apiClasspath, "gradleApi()", RuntimeShadedJarType.API).plus(this.fileResolver.resolveFiles(groovyImpl, installationBeacon));
    }

    private FileCollectionInternal gradleTestKitFileCollection(Collection<File> testKitClasspath) {
        List<File> gradleApi = this.getClassPath(DependencyFactory.ClassPathNotation.GRADLE_API);
        testKitClasspath.removeAll(gradleApi);
        return (FileCollectionInternal)this.relocatedDepsJar(testKitClasspath, "gradleTestKit()", RuntimeShadedJarType.TEST_KIT).plus(this.gradleApiFileCollection(gradleApi));
    }

    private FileCollectionInternal relocatedDepsJar(Collection<File> classpath, String displayName, RuntimeShadedJarType runtimeShadedJarType) {
        File gradleImplDepsJar = this.runtimeShadedJarFactory.get(runtimeShadedJarType, classpath);
        return new FileCollectionAdapter(new SingletonFileSet(gradleImplDepsJar, displayName));
    }

    abstract class GeneratedFileCollection
    extends CompositeFileCollection {
        private final String displayName;
        private FileCollection generatedCollection;

        public GeneratedFileCollection(String notation) {
            this.displayName = notation + " files";
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public void visitContents(FileCollectionResolveContext context) {
            if (context instanceof BuildDependenciesOnlyFileCollectionResolveContext) {
                return;
            }
            if (this.generatedCollection == null) {
                this.generatedCollection = this.generateFileCollection();
            }
            context.add(this.generatedCollection);
        }

        abstract FileCollection generateFileCollection();
    }
}

