/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.model;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.DefaultSourceDirectorySet;
import org.gradle.api.internal.file.FilePropertyFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.internal.provider.DefaultListProperty;
import org.gradle.api.internal.provider.DefaultMapProperty;
import org.gradle.api.internal.provider.DefaultPropertyState;
import org.gradle.api.internal.provider.DefaultSetProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.util.DeprecationLogger;

public class DefaultObjectFactory
implements ObjectFactory {
    private final Instantiator instantiator;
    private final NamedObjectInstantiator namedObjectInstantiator;
    private final FileResolver fileResolver;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final FilePropertyFactory filePropertyFactory;

    public DefaultObjectFactory(Instantiator instantiator, NamedObjectInstantiator namedObjectInstantiator, FileResolver fileResolver, DirectoryFileTreeFactory directoryFileTreeFactory, FilePropertyFactory filePropertyFactory) {
        this.instantiator = instantiator;
        this.namedObjectInstantiator = namedObjectInstantiator;
        this.fileResolver = fileResolver;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.filePropertyFactory = filePropertyFactory;
    }

    @Override
    public <T extends Named> T named(Class<T> type, String name) {
        return this.namedObjectInstantiator.named(type, name);
    }

    @Override
    public <T> T newInstance(Class<? extends T> type, Object ... parameters) throws ObjectInstantiationException {
        return this.instantiator.newInstance(type, parameters);
    }

    @Override
    public SourceDirectorySet sourceDirectorySet(final String name, final String displayName) {
        return DeprecationLogger.whileDisabled(new Factory<SourceDirectorySet>(){

            @Override
            @Nullable
            public SourceDirectorySet create() {
                return new DefaultSourceDirectorySet(name, displayName, DefaultObjectFactory.this.fileResolver, DefaultObjectFactory.this.directoryFileTreeFactory, DefaultObjectFactory.this);
            }
        });
    }

    @Override
    public DirectoryProperty directoryProperty() {
        return this.filePropertyFactory.newDirectoryProperty();
    }

    @Override
    public RegularFileProperty fileProperty() {
        return this.filePropertyFactory.newFileProperty();
    }

    @Override
    public <T> Property<T> property(Class<T> valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (valueType.isPrimitive()) {
            return (Property)Cast.uncheckedCast(this.property(JavaReflectionUtil.getWrapperTypeForPrimitiveType(valueType)));
        }
        if (List.class.isAssignableFrom(valueType)) {
            DeprecationLogger.nagUserOfReplacedMethodInvocation("ObjectFactory.property() to create a property of type List<T>", "ObjectFactory.listProperty()");
        } else if (Set.class.isAssignableFrom(valueType)) {
            DeprecationLogger.nagUserOfReplacedMethodInvocation("ObjectFactory.property() method to create a property of type Set<T>", "ObjectFactory.setProperty()");
        } else if (Map.class.isAssignableFrom(valueType)) {
            DeprecationLogger.nagUserOfReplacedMethodInvocation("ObjectFactory.property() method to create a property of type Map<K, V>", "ObjectFactory.mapProperty()");
        } else if (Directory.class.isAssignableFrom(valueType)) {
            DeprecationLogger.nagUserOfReplacedMethodInvocation("ObjectFactory.property() method to create a property of type Directory", "ObjectFactory.directoryProperty()");
        } else if (RegularFile.class.isAssignableFrom(valueType)) {
            DeprecationLogger.nagUserOfReplacedMethodInvocation("ObjectFactory.property() method to create a property of type RegularFile", "ObjectFactory.fileProperty()");
        }
        return new DefaultPropertyState<T>(valueType);
    }

    @Override
    public <T> ListProperty<T> listProperty(Class<T> elementType) {
        if (elementType.isPrimitive()) {
            return (ListProperty)Cast.uncheckedCast(this.listProperty(JavaReflectionUtil.getWrapperTypeForPrimitiveType(elementType)));
        }
        return new DefaultListProperty<T>(elementType);
    }

    @Override
    public <T> SetProperty<T> setProperty(Class<T> elementType) {
        if (elementType.isPrimitive()) {
            return (SetProperty)Cast.uncheckedCast(this.setProperty(JavaReflectionUtil.getWrapperTypeForPrimitiveType(elementType)));
        }
        return new DefaultSetProperty<T>(elementType);
    }

    @Override
    public <K, V> MapProperty<K, V> mapProperty(Class<K> keyType, Class<V> valueType) {
        if (keyType.isPrimitive()) {
            return (MapProperty)Cast.uncheckedCast(this.mapProperty(JavaReflectionUtil.getWrapperTypeForPrimitiveType(keyType), valueType));
        }
        if (valueType.isPrimitive()) {
            return (MapProperty)Cast.uncheckedCast(this.mapProperty(keyType, JavaReflectionUtil.getWrapperTypeForPrimitiveType(valueType)));
        }
        return new DefaultMapProperty<K, V>(keyType, valueType);
    }
}

