/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.java.usagecontext;

import java.util.Set;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.java.usagecontext.AbstractUsageContext;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class ConfigurationUsageContext
extends AbstractUsageContext {
    private final String name;
    private final String configurationName;
    private final ConfigurationContainer configurations;
    private DomainObjectSet<ModuleDependency> dependencies;
    private DomainObjectSet<DependencyConstraint> dependencyConstraints;
    private Set<? extends Capability> capabilities;
    private Set<ExcludeRule> excludeRules;

    public ConfigurationUsageContext(String usageName, String name, String configurationName, Set<PublishArtifact> artifacts, ConfigurationContainer configurations, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory) {
        super(usageName, artifacts, objectFactory, attributesFactory);
        this.name = name;
        this.configurationName = configurationName;
        this.configurations = configurations;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Set<ModuleDependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = this.getConfiguration().getIncoming().getDependencies().withType(ModuleDependency.class);
        }
        return this.dependencies;
    }

    @Override
    public Set<? extends DependencyConstraint> getDependencyConstraints() {
        if (this.dependencyConstraints == null) {
            this.dependencyConstraints = this.getConfiguration().getIncoming().getDependencyConstraints();
        }
        return this.dependencyConstraints;
    }

    @Override
    public Set<? extends Capability> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = ImmutableSet.copyOf(Configurations.collectCapabilities(this.getConfiguration(), Sets.newHashSet(), Sets.newHashSet()));
        }
        return this.capabilities;
    }

    @Override
    public Set<ExcludeRule> getGlobalExcludes() {
        if (this.excludeRules == null) {
            this.excludeRules = ImmutableSet.copyOf(((ConfigurationInternal)this.getConfiguration()).getAllExcludeRules());
        }
        return this.excludeRules;
    }

    private Configuration getConfiguration() {
        return this.configurations.getByName(this.configurationName);
    }
}

