/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.java;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.java.usagecontext.ConfigurationUsageContext;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class JavaLibrary
implements SoftwareComponentInternal {
    private final Set<PublishArtifact> artifacts = new LinkedHashSet<PublishArtifact>();
    private final UsageContext runtimeUsage;
    private final UsageContext compileUsage;
    private final ConfigurationContainer configurations;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;

    @Inject
    public JavaLibrary(ObjectFactory objectFactory, ConfigurationContainer configurations, ImmutableAttributesFactory attributesFactory, PublishArtifact artifact) {
        this.configurations = configurations;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.runtimeUsage = this.createRuntimeUsageContext();
        this.compileUsage = this.createCompileUsageContext();
        if (artifact != null) {
            this.artifacts.add(artifact);
        }
    }

    @VisibleForTesting
    Set<PublishArtifact> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public String getName() {
        return "java";
    }

    public Set<UsageContext> getUsages() {
        return ImmutableSet.of((Object)this.runtimeUsage, (Object)this.compileUsage);
    }

    private UsageContext createRuntimeUsageContext() {
        return new ConfigurationUsageContext("java-runtime", "runtime", "runtimeElements", this.artifacts, this.configurations, this.objectFactory, this.attributesFactory);
    }

    private UsageContext createCompileUsageContext() {
        return new ConfigurationUsageContext("java-api", "api", "apiElements", this.artifacts, this.configurations, this.objectFactory, this.attributesFactory);
    }
}

