/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.LinkedList;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

class ClassLoaderScopeIdentifier {
    private final ClassLoaderScopeIdentifier parent;
    private final String name;

    public ClassLoaderScopeIdentifier(ClassLoaderScopeIdentifier parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public ClassLoaderScopeIdentifier child(String name) {
        return new ClassLoaderScopeIdentifier(this, name);
    }

    ClassLoaderId localId() {
        return new Id(this, false);
    }

    ClassLoaderId exportId() {
        return new Id(this, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassLoaderScopeIdentifier that = (ClassLoaderScopeIdentifier)o;
        return this.name.equals(that.name) && !(this.parent == null ? that.parent != null : !this.parent.equals(that.parent));
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    String getPath() {
        LinkedList names = Lists.newLinkedList();
        names.add(this.name);
        ClassLoaderScopeIdentifier nextParent = this.parent;
        while (nextParent != null) {
            names.add(0, nextParent.name);
            nextParent = nextParent.parent;
        }
        return Joiner.on((String)":").join((Iterable)names);
    }

    public String toString() {
        return "ClassLoaderScopeIdentifier{" + this.getPath() + "}";
    }

    private static class Id
    implements ClassLoaderId {
        private final ClassLoaderScopeIdentifier identifier;
        private final boolean export;

        public Id(ClassLoaderScopeIdentifier identifier, boolean export) {
            this.identifier = identifier;
            this.export = export;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id = (Id)o;
            return this.export == id.export && this.identifier.equals(id.identifier);
        }

        @Override
        public int hashCode() {
            int result = this.identifier.hashCode();
            result = 31 * result + (this.export ? 1 : 0);
            return result;
        }

        @Override
        public String getDisplayName() {
            return this.identifier.getPath() + "(" + (this.export ? "export" : "local") + ")";
        }

        public String toString() {
            return "ClassLoaderScopeIdentifier.Id{" + this.getDisplayName() + "}";
        }
    }
}

