/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class UnionFileTree
extends CompositeFileTree {
    private final Set<FileTreeInternal> sourceTrees;
    private final String displayName;

    public UnionFileTree(FileTreeInternal ... sourceTrees) {
        this("file tree", Arrays.asList(sourceTrees));
    }

    public UnionFileTree(String displayName, FileTreeInternal ... sourceTrees) {
        this(displayName, Arrays.asList(sourceTrees));
    }

    public UnionFileTree(String displayName, Collection<? extends FileTreeInternal> sourceTrees) {
        this.displayName = displayName;
        this.sourceTrees = Sets.newLinkedHashSet(sourceTrees);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        context.add(this.sourceTrees);
    }

    public void addToUnion(FileCollection source) {
        if (!(source instanceof FileTree)) {
            throw new UnsupportedOperationException(String.format("Can only add FileTree instances to %s.", this.getDisplayName()));
        }
        this.sourceTrees.add(Cast.cast(FileTreeInternal.class, source));
    }
}

