/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.FilePropertyFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.provider.AbstractCombiningProvider;
import org.gradle.api.internal.provider.AbstractMappingProvider;
import org.gradle.api.internal.provider.DefaultPropertyState;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.internal.file.PathToFileResolver;

public class DefaultFilePropertyFactory
implements FilePropertyFactory {
    private final FileResolver fileResolver;

    public DefaultFilePropertyFactory(FileResolver resolver) {
        this.fileResolver = resolver;
    }

    @Override
    public DirectoryProperty newDirectoryProperty() {
        return new DefaultDirectoryVar(this.fileResolver);
    }

    @Override
    public RegularFileProperty newFileProperty() {
        return new DefaultRegularFileVar(this.fileResolver);
    }

    static class ToFileProvider
    extends AbstractMappingProvider<File, FileSystemLocation> {
        ToFileProvider(ProviderInternal<? extends FileSystemLocation> provider) {
            super(File.class, provider);
        }

        @Override
        protected File map(FileSystemLocation provider) {
            return provider.getAsFile();
        }
    }

    static class DefaultDirectoryVar
    extends AbstractFileVar<Directory>
    implements DirectoryProperty {
        private final FileResolver resolver;

        DefaultDirectoryVar(FileResolver resolver) {
            super(Directory.class);
            this.resolver = resolver;
        }

        DefaultDirectoryVar(FileResolver resolver, Object value) {
            super(Directory.class);
            this.resolver = resolver;
            this.resolveAndSet(value);
        }

        @Override
        public FileTree getAsFileTree() {
            return this.resolver.resolveFilesAsTree(this);
        }

        @Override
        public Provider<File> getAsFile() {
            return new ToFileProvider(this);
        }

        void resolveAndSet(Object value) {
            File resolved = this.resolver.resolve(value);
            this.set(new FixedDirectory(resolved, this.resolver.newResolver(resolved)));
        }

        @Override
        public void set(File dir) {
            File resolved = this.resolver.resolve(dir);
            this.set(new FixedDirectory(resolved, this.resolver.newResolver(resolved)));
        }

        @Override
        public DirectoryProperty value(Directory value) {
            super.value(value);
            return this;
        }

        @Override
        public DirectoryProperty convention(Directory value) {
            super.convention(value);
            return this;
        }

        @Override
        public DirectoryProperty convention(Provider<? extends Directory> valueProvider) {
            super.convention(valueProvider);
            return this;
        }

        @Override
        public Provider<Directory> dir(final String path) {
            return new AbstractMappingProvider<Directory, Directory>(Directory.class, (ProviderInternal)this){

                @Override
                protected Directory map(Directory dir) {
                    return dir.dir(path);
                }
            };
        }

        @Override
        public Provider<Directory> dir(Provider<? extends CharSequence> path) {
            return new AbstractCombiningProvider<Directory, Directory, CharSequence>(Directory.class, (Provider)this, path){

                @Override
                protected Directory map(Directory b, CharSequence v) {
                    return b.dir(v.toString());
                }
            };
        }

        @Override
        public Provider<RegularFile> file(final String path) {
            return new AbstractMappingProvider<RegularFile, Directory>(RegularFile.class, (ProviderInternal)this){

                @Override
                protected RegularFile map(Directory dir) {
                    return dir.file(path);
                }
            };
        }

        @Override
        public Provider<RegularFile> file(Provider<? extends CharSequence> path) {
            return new AbstractCombiningProvider<RegularFile, Directory, CharSequence>(RegularFile.class, (Provider)this, path){

                @Override
                protected RegularFile map(Directory b, CharSequence v) {
                    return b.file(v.toString());
                }
            };
        }
    }

    static class ResolvingDirectory
    extends AbstractResolvingProvider<Directory> {
        private final FileResolver resolver;

        ResolvingDirectory(FileResolver resolver, ProviderInternal<? extends CharSequence> valueProvider) {
            super(Directory.class, valueProvider);
            this.resolver = resolver;
        }

        @Override
        protected Directory map(CharSequence path) {
            File dir = this.resolver.resolve(path);
            return new FixedDirectory(dir, this.resolver.newResolver(dir));
        }
    }

    static class DefaultRegularFileVar
    extends AbstractFileVar<RegularFile>
    implements RegularFileProperty {
        private final PathToFileResolver fileResolver;

        DefaultRegularFileVar(PathToFileResolver fileResolver) {
            super(RegularFile.class);
            this.fileResolver = fileResolver;
        }

        @Override
        public Provider<File> getAsFile() {
            return new ToFileProvider(this);
        }

        @Override
        public void set(File file) {
            this.set(new FixedFile(this.fileResolver.resolve(file)));
        }

        @Override
        public RegularFileProperty value(RegularFile value) {
            super.value(value);
            return this;
        }

        @Override
        public RegularFileProperty convention(RegularFile value) {
            super.convention(value);
            return this;
        }

        @Override
        public RegularFileProperty convention(Provider<? extends RegularFile> valueProvider) {
            super.convention(valueProvider);
            return this;
        }
    }

    static abstract class AbstractFileVar<T>
    extends DefaultPropertyState<T> {
        public AbstractFileVar(Class<T> type) {
            super(type);
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            if (!super.maybeVisitBuildDependencies(context)) {
                this.getProvider().maybeVisitBuildDependencies(context);
            }
            return true;
        }

        @Override
        public void setFromAnyValue(Object object) {
            if (object instanceof File) {
                this.set((File)object);
            } else {
                super.setFromAnyValue(object);
            }
        }

        @Override
        public abstract void set(File var1);
    }

    static class ResolvingRegularFileProvider
    extends AbstractResolvingProvider<RegularFile> {
        private final PathToFileResolver resolver;

        ResolvingRegularFileProvider(PathToFileResolver resolver, ProviderInternal<? extends CharSequence> path) {
            super(RegularFile.class, path);
            this.resolver = resolver;
        }

        @Override
        protected RegularFile map(CharSequence path) {
            return new FixedFile(this.resolver.resolve(path));
        }
    }

    static abstract class AbstractResolvingProvider<T>
    extends AbstractMappingProvider<T, CharSequence> {
        public AbstractResolvingProvider(Class<T> type, ProviderInternal<? extends CharSequence> provider) {
            super(type, provider);
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return true;
        }
    }

    static class FixedFile
    implements RegularFile {
        private final File file;

        FixedFile(File file) {
            this.file = file;
        }

        public String toString() {
            return this.file.toString();
        }

        @Override
        public File getAsFile() {
            return this.file;
        }
    }

    static class FixedDirectory
    implements Directory {
        private final File value;
        final FileResolver fileResolver;

        FixedDirectory(File value, FileResolver fileResolver) {
            this.value = value;
            this.fileResolver = fileResolver;
        }

        public String toString() {
            return this.value.toString();
        }

        @Override
        public File getAsFile() {
            return this.value;
        }

        @Override
        public Directory dir(String path) {
            File newDir = this.fileResolver.resolve(path);
            return new FixedDirectory(newDir, this.fileResolver.newResolver(newDir));
        }

        @Override
        public FileTree getAsFileTree() {
            return this.fileResolver.resolveFilesAsTree(this);
        }

        @Override
        public Provider<Directory> dir(Provider<? extends CharSequence> path) {
            return new ResolvingDirectory(this.fileResolver, Providers.internal(path));
        }

        @Override
        public RegularFile file(String path) {
            return new FixedFile(this.fileResolver.resolve(path));
        }

        @Override
        public Provider<RegularFile> file(Provider<? extends CharSequence> path) {
            return new ResolvingRegularFileProvider(this.fileResolver, Providers.internal(path));
        }
    }
}

