/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.Closeable;
import java.io.File;
import javax.annotation.Nullable;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;

public class CrossBuildFileHashCache
implements Closeable {
    public static final String FILE_HASHES_CACHE_KEY = "fileHashes";
    private final PersistentCache cache;
    private final InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory;

    public CrossBuildFileHashCache(@Nullable File cacheDir, CacheRepository repository, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        this.inMemoryCacheDecoratorFactory = inMemoryCacheDecoratorFactory;
        CacheBuilder cacheBuilder = cacheDir != null ? repository.cache(cacheDir) : repository.cache(FILE_HASHES_CACHE_KEY);
        this.cache = cacheBuilder.withDisplayName("file hash cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).open();
    }

    public <K, V> PersistentIndexedCache<K, V> createCache(PersistentIndexedCacheParameters<K, V> parameters, int maxEntriesToKeepInMemory, boolean cacheInMemoryForShortLivedProcesses) {
        return this.cache.createCache(parameters.withCacheDecorator(this.inMemoryCacheDecoratorFactory.decorator(maxEntriesToKeepInMemory, cacheInMemoryForShortLivedProcesses)));
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

