/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependenciesInternal;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.artifacts.transform.TransformerInvoker;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Try;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationStep
implements Transformation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformationStep.class);
    private final Transformer transformer;
    private final TransformerInvoker transformerInvoker;

    public TransformationStep(Transformer transformer, TransformerInvoker transformerInvoker) {
        this.transformer = transformer;
        this.transformerInvoker = transformerInvoker;
    }

    @Override
    public boolean endsWith(Transformation otherTransform) {
        return this == otherTransform;
    }

    @Override
    public int stepsCount() {
        return 1;
    }

    @Override
    public Try<TransformationSubject> transform(TransformationSubject subjectToTransform, ExecutionGraphDependenciesResolver dependenciesResolver) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Transforming {} with {}", (Object)subjectToTransform.getDisplayName(), (Object)this.transformer.getDisplayName());
        }
        ImmutableList<File> primaryInputs = subjectToTransform.getFiles();
        return dependenciesResolver.forTransformer(this.transformer).flatMap(dependencies -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (File primaryInput : primaryInputs) {
                Try<ImmutableList<File>> result = this.transformerInvoker.invoke(this.transformer, primaryInput, (ArtifactTransformDependenciesInternal)dependencies, subjectToTransform);
                if (result.getFailure().isPresent()) {
                    return Try.failure(result.getFailure().get());
                }
                builder.addAll((Iterable)result.get());
            }
            return Try.successful(subjectToTransform.createSubjectFromResult((ImmutableList<File>)builder.build()));
        });
    }

    @Override
    public boolean requiresDependencies() {
        return this.transformer.requiresDependencies();
    }

    @Override
    public String getDisplayName() {
        return this.transformer.getDisplayName();
    }

    @Override
    public void visitTransformationSteps(Action<? super TransformationStep> action) {
        action.execute(this);
    }

    public ImmutableAttributes getFromAttributes() {
        return this.transformer.getFromAttributes();
    }

    public String toString() {
        return String.format("%s@%s", this.transformer.getDisplayName(), this.transformer.getSecondaryInputHash());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformationStep that = (TransformationStep)o;
        return this.transformer.equals(that.transformer);
    }

    public int hashCode() {
        return this.transformer.hashCode();
    }
}

