/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.internal.Try;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.RunnableBuildOperation;

class TransformationOperation
implements RunnableBuildOperation {
    private final Transformation transformation;
    private final TransformationSubject subject;
    private final ExecutionGraphDependenciesResolver dependenciesResolver;
    private Try<TransformationSubject> result;

    TransformationOperation(Transformation transformation, TransformationSubject subject, ExecutionGraphDependenciesResolver dependenciesResolver) {
        this.transformation = transformation;
        this.subject = subject;
        this.dependenciesResolver = dependenciesResolver;
    }

    @Override
    public void run(@Nullable BuildOperationContext context) {
        this.result = this.transformation.transform(this.subject, this.dependenciesResolver);
    }

    @Override
    public BuildOperationDescriptor.Builder description() {
        String displayName = "Transform " + this.subject.getDisplayName() + " with " + this.transformation.getDisplayName();
        return BuildOperationDescriptor.displayName(displayName).progressDisplayName(displayName).operationType(BuildOperationCategory.UNCATEGORIZED);
    }

    public Try<TransformationSubject> getResult() {
        return this.result;
    }
}

