/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.artifacts.transform.DefaultTransformationWorkspace;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceIdentity;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceProvider;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Try;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

@NotThreadSafe
public class MutableTransformationWorkspaceProvider
implements TransformationWorkspaceProvider {
    private final Provider<Directory> baseDirectory;
    private final ExecutionHistoryStore executionHistoryStore;

    public MutableTransformationWorkspaceProvider(ProjectLayout layout, ExecutionHistoryStore executionHistoryStore) {
        this.baseDirectory = layout.getBuildDirectory().dir("transforms");
        this.executionHistoryStore = executionHistoryStore;
    }

    @Override
    public ExecutionHistoryStore getExecutionHistoryStore() {
        return this.executionHistoryStore;
    }

    @Override
    public Try<ImmutableList<File>> withWorkspace(TransformationWorkspaceIdentity identity, TransformationWorkspaceProvider.TransformationWorkspaceAction workspaceAction) {
        String workspacePath = identity.getIdentity();
        DefaultTransformationWorkspace workspace = new DefaultTransformationWorkspace(new File(this.baseDirectory.get().getAsFile(), workspacePath));
        return workspaceAction.useWorkspace(workspacePath, workspace);
    }
}

