/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.Closeable;
import java.io.File;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.api.internal.artifacts.transform.DefaultTransformationWorkspace;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceIdentity;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceProvider;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CompositeCleanupAction;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Try;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.resource.local.FileAccessTimeJournal;
import org.gradle.internal.resource.local.SingleDepthFileAccessTracker;

@NotThreadSafe
public class ImmutableTransformationWorkspaceProvider
implements TransformationWorkspaceProvider,
Closeable {
    private static final int FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 1;
    private final SingleDepthFileAccessTracker fileAccessTracker;
    private final File filesOutputDirectory;
    private final ExecutionHistoryStore executionHistoryStore;
    private final PersistentCache cache;

    public ImmutableTransformationWorkspaceProvider(File transformsStoreDirectory, CacheRepository cacheRepository, FileAccessTimeJournal fileAccessTimeJournal, ExecutionHistoryStore executionHistoryStore) {
        this.filesOutputDirectory = new File(transformsStoreDirectory, CacheLayout.TRANSFORMS_STORE.getKey());
        this.executionHistoryStore = executionHistoryStore;
        this.cache = cacheRepository.cache(transformsStoreDirectory).withCleanup(this.createCleanupAction(this.filesOutputDirectory, fileAccessTimeJournal)).withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).withDisplayName("Artifact transforms cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).open();
        this.fileAccessTracker = new SingleDepthFileAccessTracker(fileAccessTimeJournal, this.filesOutputDirectory, 1);
    }

    private CleanupAction createCleanupAction(File filesOutputDirectory, FileAccessTimeJournal fileAccessTimeJournal) {
        return CompositeCleanupAction.builder().add(filesOutputDirectory, new LeastRecentlyUsedCacheCleanup(new SingleDepthFilesFinder(1), fileAccessTimeJournal, 7L)).build();
    }

    @Override
    public ExecutionHistoryStore getExecutionHistoryStore() {
        return this.executionHistoryStore;
    }

    @Override
    public Try<ImmutableList<File>> withWorkspace(TransformationWorkspaceIdentity identity, TransformationWorkspaceProvider.TransformationWorkspaceAction workspaceAction) {
        return this.cache.withFileLock(() -> {
            String workspacePath = identity.getIdentity();
            DefaultTransformationWorkspace workspace = new DefaultTransformationWorkspace(new File(this.filesOutputDirectory, workspacePath));
            this.fileAccessTracker.markAccessed(workspace.getResultsFile());
            this.fileAccessTracker.markAccessed(workspace.getOutputDirectory());
            return workspaceAction.useWorkspace(workspacePath, workspace);
        });
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

