/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.NonExtensible;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.ArtifactTransformSpec;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.VariantTransform;
import org.gradle.api.artifacts.transform.VariantTransformConfigurationException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.DefaultActionConfiguration;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.transform.DefaultTransformationRegistration;
import org.gradle.api.internal.artifacts.transform.TransformerInvoker;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolation.IsolatableFactory;

public class DefaultVariantTransformRegistry
implements VariantTransformRegistry {
    private static final Object[] NO_PARAMETERS = new Object[0];
    private final List<VariantTransformRegistry.Registration> transforms = Lists.newArrayList();
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final IsolatableFactory isolatableFactory;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final InstantiatorFactory instantiatorFactory;
    private final TransformerInvoker transformerInvoker;

    public DefaultVariantTransformRegistry(InstantiatorFactory instantiatorFactory, ImmutableAttributesFactory immutableAttributesFactory, IsolatableFactory isolatableFactory, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, TransformerInvoker transformerInvoker) {
        this.instantiatorFactory = instantiatorFactory;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.isolatableFactory = isolatableFactory;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.transformerInvoker = transformerInvoker;
    }

    @Override
    public void registerTransform(Action<? super VariantTransform> registrationAction) {
        UntypedRegistration registration = this.instantiatorFactory.decorateLenient().newInstance(UntypedRegistration.class, this.immutableAttributesFactory, this.instantiatorFactory);
        this.register(registration, registrationAction);
    }

    @Override
    public <T> void registerTransform(Class<T> configurationType, Action<? super ArtifactTransformSpec<T>> registrationAction) {
        T configuration = this.instantiatorFactory.inject().newInstance(configurationType, new Object[0]);
        TypedRegistration registration = this.instantiatorFactory.decorateLenient().newInstance(TypedRegistration.class, configuration, this.immutableAttributesFactory);
        this.register(registration, registrationAction);
    }

    private <T extends RecordingRegistration> void register(T registration, Action<? super T> registrationAction) {
        registrationAction.execute(registration);
        if (registration.actionType == null) {
            throw new VariantTransformConfigurationException("Could not register transform: an ArtifactTransform must be provided.");
        }
        if (registration.to.isEmpty()) {
            throw new VariantTransformConfigurationException("Could not register transform: at least one 'to' attribute must be provided.");
        }
        if (registration.from.isEmpty()) {
            throw new VariantTransformConfigurationException("Could not register transform: at least one 'from' attribute must be provided.");
        }
        if (!registration.from.keySet().containsAll(registration.to.keySet())) {
            throw new VariantTransformConfigurationException("Could not register transform: each 'to' attribute must be included as a 'from' attribute.");
        }
        Object[] parameters = registration.getTransformParameters();
        Object config = registration.getConfig();
        VariantTransformRegistry.Registration finalizedRegistration = DefaultTransformationRegistration.create(registration.from.asImmutable(), registration.to.asImmutable(), registration.actionType, config, parameters, this.isolatableFactory, this.classLoaderHierarchyHasher, this.instantiatorFactory, this.transformerInvoker);
        this.transforms.add(finalizedRegistration);
    }

    @Override
    public Iterable<VariantTransformRegistry.Registration> getTransforms() {
        return this.transforms;
    }

    @NonExtensible
    public static class TypedRegistration<T>
    extends RecordingRegistration
    implements ArtifactTransformSpec<T> {
        private final T config;
        private final List<Object> params = Lists.newArrayList();

        public TypedRegistration(T config, ImmutableAttributesFactory immutableAttributesFactory) {
            super(immutableAttributesFactory);
            this.config = config;
            TransformAction transformAction = config.getClass().getAnnotation(TransformAction.class);
            if (transformAction != null) {
                this.actionType = transformAction.value();
            }
        }

        @Override
        public Class<? extends ArtifactTransform> getActionClass() {
            return this.actionType;
        }

        @Override
        public void setActionClass(Class<? extends ArtifactTransform> implementationClass) {
            this.actionType = implementationClass;
        }

        @Override
        public T getConfiguration() {
            return this.config;
        }

        @Override
        public void configuration(Action<? super T> action) {
            action.execute(this.config);
        }

        @Override
        public Object[] getParams() {
            return this.params.toArray();
        }

        @Override
        public void setParams(Object[] params) {
            this.params.clear();
            Collections.addAll(this.params, params);
        }

        @Override
        public void params(Object ... params) {
            Collections.addAll(this.params, params);
        }

        @Override
        @Nullable
        Object getConfig() {
            return this.config;
        }

        @Override
        Object[] getTransformParameters() {
            return this.params.toArray();
        }
    }

    @NonExtensible
    public static class UntypedRegistration
    extends RecordingRegistration
    implements VariantTransform {
        private final InstantiatorFactory instantiatorFactory;

        public UntypedRegistration(ImmutableAttributesFactory immutableAttributesFactory, InstantiatorFactory instantiatorFactory) {
            super(immutableAttributesFactory);
            this.instantiatorFactory = instantiatorFactory;
        }

        @Override
        public void artifactTransform(Class<? extends ArtifactTransform> type) {
            this.artifactTransform(type, null);
        }

        @Override
        public void artifactTransform(Class<? extends ArtifactTransform> type, @Nullable Action<? super ActionConfiguration> config) {
            if (this.actionType != null) {
                throw new VariantTransformConfigurationException("Could not register transform: only one ArtifactTransform may be provided for registration.");
            }
            this.actionType = type;
            this.configAction = config;
        }

        @Override
        Object[] getTransformParameters() {
            if (this.configAction == null) {
                return NO_PARAMETERS;
            }
            ActionConfiguration config = this.instantiatorFactory.decorateLenient().newInstance(DefaultActionConfiguration.class, new Object[0]);
            this.configAction.execute(config);
            return config.getParams();
        }

        @Override
        Object getConfig() {
            return null;
        }
    }

    public static abstract class RecordingRegistration {
        final AttributeContainerInternal from;
        final AttributeContainerInternal to;
        Class<? extends ArtifactTransform> actionType;
        Action<? super ActionConfiguration> configAction;

        public RecordingRegistration(ImmutableAttributesFactory immutableAttributesFactory) {
            this.from = immutableAttributesFactory.mutable();
            this.to = immutableAttributesFactory.mutable();
        }

        public AttributeContainer getFrom() {
            return this.from;
        }

        public AttributeContainer getTo() {
            return this.to;
        }

        abstract Object[] getTransformParameters();

        @Nullable
        abstract Object getConfig();
    }
}

