/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationNode;
import org.gradle.api.internal.artifacts.transform.TransformationNodeFactory;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class DefaultTransformationNodeFactory
implements TransformationNodeFactory {
    private final Map<ArtifactTransformKey, TransformationNode> transformations = Maps.newConcurrentMap();

    @Override
    public Collection<TransformationNode> getOrCreate(ResolvedArtifactSet artifactSet, Transformation transformation, ExecutionGraphDependenciesResolver dependenciesResolver) {
        List<TransformationStep> transformationChain = DefaultTransformationNodeFactory.unpackTransformation(transformation);
        ImmutableList.Builder builder = ImmutableList.builder();
        Function<ResolvableArtifact, TransformationNode> nodeCreator = artifact -> this.getOrCreateInternal((ResolvableArtifact)artifact, transformationChain, dependenciesResolver);
        this.collectTransformNodes(artifactSet, (ImmutableList.Builder<TransformationNode>)builder, nodeCreator);
        return builder.build();
    }

    private void collectTransformNodes(ResolvedArtifactSet artifactSet, final ImmutableList.Builder<TransformationNode> builder, final Function<ResolvableArtifact, TransformationNode> nodeCreator) {
        artifactSet.visitLocalArtifacts(new ResolvedArtifactSet.LocalArtifactVisitor(){

            @Override
            public void visitArtifact(ResolvableArtifact artifact) {
                TransformationNode transformationNode = (TransformationNode)nodeCreator.apply(artifact);
                builder.add((Object)transformationNode);
            }
        });
    }

    private TransformationNode getOrCreateInternal(ResolvableArtifact artifact, List<TransformationStep> transformationChain, ExecutionGraphDependenciesResolver dependenciesResolver) {
        ArtifactTransformKey key = new ArtifactTransformKey(artifact.getId(), transformationChain);
        TransformationNode transformationNode = this.transformations.get(key);
        if (transformationNode == null) {
            if (transformationChain.size() == 1) {
                transformationNode = TransformationNode.initial(transformationChain.get(0), artifact, dependenciesResolver);
            } else {
                TransformationNode previous = this.getOrCreateInternal(artifact, transformationChain.subList(0, transformationChain.size() - 1), dependenciesResolver);
                transformationNode = TransformationNode.chained(transformationChain.get(transformationChain.size() - 1), previous, dependenciesResolver);
            }
            this.transformations.put(key, transformationNode);
        }
        return transformationNode;
    }

    private static List<TransformationStep> unpackTransformation(Transformation transformation) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        transformation.visitTransformationSteps((Action<? super TransformationStep>)new Action<TransformationStep>(){

            @Override
            public void execute(TransformationStep transformation) {
                builder.add((Object)transformation);
            }
        });
        return builder.build();
    }

    private static class ArtifactTransformKey {
        private final ComponentArtifactIdentifier artifactIdentifier;
        private final List<TransformationStep> transformations;

        private ArtifactTransformKey(ComponentArtifactIdentifier artifactIdentifier, List<TransformationStep> transformations) {
            this.artifactIdentifier = artifactIdentifier;
            this.transformations = transformations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactTransformKey that = (ArtifactTransformKey)o;
            if (!this.artifactIdentifier.equals(that.artifactIdentifier)) {
                return false;
            }
            return this.transformations.equals(that.transformations);
        }

        public int hashCode() {
            int result = this.artifactIdentifier.hashCode();
            result = 31 * result + this.transformations.hashCode();
            return result;
        }
    }
}

