/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedFilesCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependenciesInternal;
import org.gradle.api.internal.artifacts.transform.DefaultArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Factory;
import org.gradle.internal.Try;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class DefaultExecutionGraphDependenciesResolver
implements ExecutionGraphDependenciesResolver {
    private static final ArtifactTransformDependenciesInternal EMPTY_DEPENDENCIES = new ArtifactTransformDependenciesInternal(){

        @Override
        public Iterable<File> getFiles() {
            return ImmutableSet.of();
        }

        @Override
        public CurrentFileCollectionFingerprint fingerprint(FileCollectionFingerprinter fingerprinter) {
            return fingerprinter.empty();
        }
    };
    private final ComponentIdentifier componentIdentifier;
    private final Factory<ResolverResults> graphResults;
    private final Factory<ResolverResults> artifactResults;
    private final WorkNodeAction graphResolveAction;
    private Set<ComponentIdentifier> buildDependencies;
    private Set<ComponentIdentifier> dependencies;

    public DefaultExecutionGraphDependenciesResolver(ComponentIdentifier componentIdentifier, Factory<ResolverResults> graphResults, Factory<ResolverResults> artifactResults, WorkNodeAction graphResolveAction) {
        this.componentIdentifier = componentIdentifier;
        this.graphResults = graphResults;
        this.artifactResults = artifactResults;
        this.graphResolveAction = graphResolveAction;
    }

    @Override
    public Try<ArtifactTransformDependenciesInternal> forTransformer(Transformer transformer) {
        if (!transformer.requiresDependencies()) {
            return Try.successful(EMPTY_DEPENDENCIES);
        }
        ResolverResults results = this.artifactResults.create();
        if (this.dependencies == null) {
            this.dependencies = DefaultExecutionGraphDependenciesResolver.computeProjectDependencies(this.componentIdentifier, ComponentIdentifier.class, results.getResolutionResult().getAllComponents());
        }
        VisitedArtifactSet visitedArtifacts = results.getVisitedArtifacts();
        SelectedArtifactSet artifacts = visitedArtifacts.select(Specs.satisfyAll(), transformer.getFromAttributes(), element -> this.dependencies.contains(element), false);
        ResolvedFilesCollectingVisitor visitor = new ResolvedFilesCollectingVisitor();
        artifacts.visitArtifacts(visitor, false);
        if (!visitor.getFailures().isEmpty()) {
            if (visitor.getFailures().size() == 1) {
                return Try.failure(visitor.getFailures().iterator().next());
            }
            return Try.failure(new DefaultLenientConfiguration.ArtifactResolveException("transform dependencies", transformer.getDisplayName(), "artifact transform dependencies", visitor.getFailures()));
        }
        return Try.successful(new DefaultArtifactTransformDependencies(ImmutableFileCollection.of(visitor.getFiles())));
    }

    @Override
    public TaskDependencyContainer computeDependencyNodes(final TransformationStep transformationStep) {
        if (!transformationStep.requiresDependencies()) {
            return TaskDependencyContainer.EMPTY;
        }
        return new TaskDependencyContainer(){

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                ResolverResults results = (ResolverResults)DefaultExecutionGraphDependenciesResolver.this.graphResults.create();
                if (DefaultExecutionGraphDependenciesResolver.this.buildDependencies == null) {
                    DefaultExecutionGraphDependenciesResolver.this.buildDependencies = DefaultExecutionGraphDependenciesResolver.computeProjectDependencies(DefaultExecutionGraphDependenciesResolver.this.componentIdentifier, ProjectComponentIdentifier.class, results.getResolutionResult().getAllComponents());
                }
                VisitedArtifactSet visitedArtifacts = results.getVisitedArtifacts();
                if (!DefaultExecutionGraphDependenciesResolver.this.buildDependencies.isEmpty()) {
                    SelectedArtifactSet projectArtifacts = visitedArtifacts.select(Specs.satisfyAll(), transformationStep.getFromAttributes(), element -> DefaultExecutionGraphDependenciesResolver.this.buildDependencies.contains(element), true);
                    context.add(projectArtifacts);
                }
                context.add(DefaultExecutionGraphDependenciesResolver.this.graphResolveAction);
            }
        };
    }

    private static Set<ComponentIdentifier> computeProjectDependencies(ComponentIdentifier componentIdentifier, Class<? extends ComponentIdentifier> type, Set<ResolvedComponentResult> componentResults) {
        ResolvedComponentResult targetComponent = null;
        for (ResolvedComponentResult component : componentResults) {
            if (!component.getId().equals(componentIdentifier)) continue;
            targetComponent = component;
            break;
        }
        if (targetComponent == null) {
            throw new AssertionError((Object)("Could not find component " + componentIdentifier + " in provided results."));
        }
        HashSet<ComponentIdentifier> buildDependencies = new HashSet<ComponentIdentifier>();
        DefaultExecutionGraphDependenciesResolver.collectDependenciesIdentifiers(buildDependencies, type, new HashSet<ComponentIdentifier>(), targetComponent.getDependencies());
        return buildDependencies;
    }

    private static void collectDependenciesIdentifiers(Set<ComponentIdentifier> dependenciesIdentifiers, Class<? extends ComponentIdentifier> type, Set<ComponentIdentifier> visited, Set<? extends DependencyResult> dependencies) {
        for (DependencyResult dependencyResult : dependencies) {
            if (!(dependencyResult instanceof ResolvedDependencyResult)) continue;
            ResolvedDependencyResult resolvedDependency = (ResolvedDependencyResult)dependencyResult;
            ResolvedComponentResult selected = resolvedDependency.getSelected();
            if (type.isInstance(selected.getId())) {
                dependenciesIdentifiers.add(selected.getId());
            }
            if (!visited.add(selected.getId())) continue;
            DefaultExecutionGraphDependenciesResolver.collectDependenciesIdentifiers(dependenciesIdentifiers, type, visited, selected.getDependencies());
        }
    }
}

