/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.internal.artifacts.transform.CachingTransformationWorkspaceProvider;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceIdentity;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceProvider;
import org.gradle.internal.Try;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.impldep.com.google.common.cache.Cache;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

@ThreadSafe
public abstract class AbstractCachingTransformationWorkspaceProvider
implements CachingTransformationWorkspaceProvider {
    private final TransformationWorkspaceProvider delegate;
    private final Cache<TransformationWorkspaceIdentity, Try<ImmutableList<File>>> inMemoryResultCache = CacheBuilder.newBuilder().build();

    public AbstractCachingTransformationWorkspaceProvider(TransformationWorkspaceProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public ExecutionHistoryStore getExecutionHistoryStore() {
        return this.delegate.getExecutionHistoryStore();
    }

    @Override
    public boolean hasCachedResult(TransformationWorkspaceIdentity identity) {
        return this.inMemoryResultCache.getIfPresent((Object)identity) != null;
    }

    @Override
    public Try<ImmutableList<File>> withWorkspace(TransformationWorkspaceIdentity identity, TransformationWorkspaceProvider.TransformationWorkspaceAction workspaceAction) {
        try {
            return (Try)this.inMemoryResultCache.get((Object)identity, () -> this.delegate.withWorkspace(identity, workspaceAction));
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public void clearInMemoryCache() {
        this.inMemoryResultCache.invalidateAll();
    }
}

