/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.Describable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.AttributeDesugaring;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ResolvableSelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.RejectedByAttributesVersion;
import org.gradle.internal.resolve.RejectedByRuleVersion;
import org.gradle.internal.resolve.RejectedBySelectorVersion;
import org.gradle.internal.resolve.RejectedVersion;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.ComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentIdResolveResult;

class SelectorState
implements DependencyGraphSelector,
ResolvableSelectorState {
    private static final Transformer<ComponentSelectionDescriptorInternal, ComponentSelectionDescriptorInternal> IDENTITY = new Transformer<ComponentSelectionDescriptorInternal, ComponentSelectionDescriptorInternal>(){

        @Override
        public ComponentSelectionDescriptorInternal transform(ComponentSelectionDescriptorInternal componentSelectionDescriptorInternal) {
            return componentSelectionDescriptorInternal;
        }
    };
    private final Long id;
    private final DependencyState dependencyState;
    private final DependencyMetadata firstSeenDependency;
    private final DependencyToComponentIdResolver resolver;
    private final DefaultResolvedVersionConstraint versionConstraint;
    private final VersionSelectorScheme versionSelectorScheme;
    private final ImmutableAttributesFactory attributesFactory;
    private final Set<ComponentSelectionDescriptorInternal> dependencyReasons = Sets.newLinkedHashSet();
    private ComponentIdResolveResult preferResult;
    private ComponentIdResolveResult requireResult;
    private ModuleVersionResolveException failure;
    private ModuleResolveState targetModule;
    private boolean resolved;
    private boolean forced;
    private boolean softForced;
    private boolean fromLock;
    private int outgoingEdgeCount;

    SelectorState(Long id, DependencyState dependencyState, DependencyToComponentIdResolver resolver, VersionSelectorScheme versionSelectorScheme, ResolveState resolveState, ModuleIdentifier targetModuleId) {
        this.id = id;
        this.resolver = resolver;
        this.versionSelectorScheme = versionSelectorScheme;
        this.targetModule = resolveState.getModule(targetModuleId);
        this.attributesFactory = resolveState.getAttributesFactory();
        this.update(dependencyState);
        this.dependencyState = dependencyState;
        this.firstSeenDependency = dependencyState.getDependency();
        this.versionConstraint = this.resolveVersionConstraint(this.firstSeenDependency.getSelector());
    }

    public void use() {
        ++this.outgoingEdgeCount;
        if (this.outgoingEdgeCount == 1) {
            this.targetModule.addSelector(this);
        }
    }

    public void release() {
        --this.outgoingEdgeCount;
        assert (this.outgoingEdgeCount >= 0) : "Inconsistent selector state detected: outgoing edge count cannot be negative";
        if (this.outgoingEdgeCount == 0) {
            this.removeAndMarkSelectorForReuse();
        }
    }

    private void removeAndMarkSelectorForReuse() {
        this.targetModule.removeSelector(this);
        this.resolved = false;
    }

    private DefaultResolvedVersionConstraint resolveVersionConstraint(ComponentSelector selector) {
        if (selector instanceof ModuleComponentSelector) {
            return new DefaultResolvedVersionConstraint(((ModuleComponentSelector)selector).getVersionConstraint(), this.versionSelectorScheme);
        }
        return null;
    }

    @Override
    public Long getResultId() {
        return this.id;
    }

    public String toString() {
        return this.firstSeenDependency.toString();
    }

    @Override
    public ComponentSelector getRequested() {
        return this.selectorWithDesugaredAttributes(this.dependencyState.getRequested());
    }

    public ModuleResolveState getTargetModule() {
        return this.targetModule;
    }

    ModuleVersionResolveException getFailure() {
        return this.failure;
    }

    @Override
    public ComponentIdResolveResult resolve(VersionSelector allRejects) {
        VersionSelector requiredSelector = this.versionConstraint == null ? null : this.versionConstraint.getRequiredSelector();
        this.requireResult = this.resolve(requiredSelector, allRejects, this.requireResult);
        return this.requireResult;
    }

    @Override
    public ComponentIdResolveResult resolvePrefer(VersionSelector allRejects) {
        if (this.versionConstraint == null || this.versionConstraint.getPreferredSelector() == null) {
            return null;
        }
        this.preferResult = this.resolve(this.versionConstraint.getPreferredSelector(), allRejects, this.preferResult);
        return this.preferResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentIdResolveResult resolve(VersionSelector selector, VersionSelector rejector, ComponentIdResolveResult previousResult) {
        try {
            if (!this.requiresResolve(previousResult, rejector)) {
                ComponentIdResolveResult componentIdResolveResult = previousResult;
                return componentIdResolveResult;
            }
            DefaultBuildableComponentIdResolveResult idResolveResult = new DefaultBuildableComponentIdResolveResult();
            if (this.dependencyState.failure != null) {
                idResolveResult.failed(this.dependencyState.failure);
            } else {
                this.resolver.resolve(this.firstSeenDependency, selector, rejector, idResolveResult);
            }
            if (idResolveResult.getFailure() != null) {
                this.failure = idResolveResult.getFailure();
            }
            DefaultBuildableComponentIdResolveResult defaultBuildableComponentIdResolveResult = idResolveResult;
            return defaultBuildableComponentIdResolveResult;
        }
        finally {
            this.resolved = true;
        }
    }

    @Override
    public void failed(ModuleVersionResolveException failure) {
        this.failure = failure;
        DefaultBuildableComponentIdResolveResult idResolveResult = new DefaultBuildableComponentIdResolveResult();
        idResolveResult.failed(failure);
        this.requireResult = idResolveResult;
        this.preferResult = idResolveResult;
    }

    private boolean requiresResolve(ComponentIdResolveResult previousResult, VersionSelector allRejects) {
        if (previousResult == null) {
            return true;
        }
        if (previousResult.getFailure() != null) {
            return false;
        }
        if (previousResult.isRejected()) {
            return false;
        }
        return allRejects != null && allRejects.accept(previousResult.getModuleVersionId().getVersion());
    }

    @Override
    public void markResolved() {
        this.resolved = true;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void overrideSelection(ComponentState selected) {
        this.resolved = true;
        this.targetModule = selected.getModule();
    }

    public ComponentSelectionReasonInternal getSelectionReason() {
        return ComponentSelectionReasons.of(this.dependencyReasons);
    }

    public void addReasonsForSelector(ComponentSelectionReasonInternal selectionReason) {
        ComponentIdResolveResult result = this.preferResult == null ? this.requireResult : this.preferResult;
        ArrayList rejectedBySelector = null;
        if (result != null) {
            for (RejectedVersion rejectedVersion : result.getRejectedVersions()) {
                String version = rejectedVersion.getId().getVersion();
                if (rejectedVersion instanceof RejectedBySelectorVersion) {
                    if (rejectedBySelector == null) {
                        rejectedBySelector = Lists.newArrayList();
                    }
                    rejectedBySelector.add(version);
                    continue;
                }
                if (rejectedVersion instanceof RejectedByRuleVersion) {
                    String reason = ((RejectedByRuleVersion)rejectedVersion).getReason();
                    selectionReason.addCause(ComponentSelectionReasons.REJECTION.withDescription(new RejectedByRuleReason(version, reason)));
                    continue;
                }
                if (!(rejectedVersion instanceof RejectedByAttributesVersion)) continue;
                selectionReason.addCause(ComponentSelectionReasons.REJECTION.withDescription(new RejectedByAttributesReason((RejectedByAttributesVersion)rejectedVersion)));
            }
        }
        for (ComponentSelectionDescriptorInternal descriptor : this.dependencyReasons) {
            if (descriptor.getCause() == ComponentSelectionCause.REQUESTED || descriptor.getCause() == ComponentSelectionCause.CONSTRAINT) {
                if (rejectedBySelector != null) {
                    descriptor = descriptor.withDescription(new RejectedBySelectorReason(rejectedBySelector, descriptor));
                } else if (result != null && !result.getUnmatchedVersions().isEmpty()) {
                    descriptor = descriptor.withDescription(new UnmatchedVersionsReason(result.getUnmatchedVersions(), descriptor));
                }
            }
            selectionReason.addCause(descriptor);
        }
    }

    public DependencyMetadata getDependencyMetadata() {
        return this.firstSeenDependency;
    }

    @Override
    public ResolvedVersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    @Override
    public ComponentSelector getSelector() {
        return this.dependencyState.getDependency().getSelector();
    }

    @Override
    public boolean isForce() {
        return this.forced;
    }

    @Override
    public boolean isSoftForce() {
        return this.softForced;
    }

    @Override
    public boolean isFromLock() {
        return this.fromLock;
    }

    private ComponentSelector selectorWithDesugaredAttributes(ComponentSelector selector) {
        return AttributeDesugaring.desugarSelector(selector, this.attributesFactory);
    }

    public void update(DependencyState dependencyState) {
        if (dependencyState != this.dependencyState) {
            if (!this.forced && dependencyState.isForced()) {
                this.forced = true;
                if (dependencyState.getDependency() instanceof LenientPlatformDependencyMetadata) {
                    this.softForced = true;
                    this.targetModule.resolveOptimizations.declareForcedPlatformInUse();
                }
                this.resolved = false;
            }
            if (!this.fromLock && dependencyState.isFromLock()) {
                this.fromLock = true;
                this.resolved = false;
            }
            dependencyState.addSelectionReasons(this.dependencyReasons);
        }
    }

    private static class RejectedBySelectorReason
    implements Describable {
        private final Collection<String> rejectedVersions;
        private final ComponentSelectionDescriptorInternal descriptor;

        private RejectedBySelectorReason(Collection<String> rejectedVersions, ComponentSelectionDescriptorInternal descriptor) {
            this.rejectedVersions = rejectedVersions;
            this.descriptor = descriptor;
        }

        @Override
        public String getDisplayName() {
            boolean hasCustomDescription = this.descriptor.hasCustomDescription();
            StringBuilder sb = new StringBuilder(this.estimateSize(hasCustomDescription));
            sb.append(this.rejectedVersions.size() > 1 ? "rejected versions " : "rejected version ");
            Joiner.on((String)", ").appendTo(sb, this.rejectedVersions);
            if (hasCustomDescription) {
                sb.append(" because ").append(this.descriptor.getDescription());
            }
            return sb.toString();
        }

        private int estimateSize(boolean hasCustomDescription) {
            return 20 + this.rejectedVersions.size() * 8 + (hasCustomDescription ? 24 : 0);
        }
    }

    private static class RejectedByAttributesReason
    implements Describable {
        private final RejectedByAttributesVersion version;

        private RejectedByAttributesReason(RejectedByAttributesVersion version) {
            this.version = version;
        }

        @Override
        public String getDisplayName() {
            TreeFormatter formatter = new TreeFormatter();
            this.version.describeTo(formatter);
            return "version " + formatter;
        }
    }

    private static class RejectedByRuleReason
    implements Describable {
        private final String version;
        private final String reason;

        private RejectedByRuleReason(String version, String reason) {
            this.version = version;
            this.reason = reason;
        }

        @Override
        public String getDisplayName() {
            return this.version + " by rule" + (this.reason != null ? " because " + this.reason : "");
        }
    }

    private class UnmatchedVersionsReason
    implements Describable {
        private final Collection<String> rejectedVersions;
        private final ComponentSelectionDescriptorInternal descriptor;

        private UnmatchedVersionsReason(Collection<String> rejectedVersions, ComponentSelectionDescriptorInternal descriptor) {
            this.rejectedVersions = rejectedVersions;
            this.descriptor = descriptor;
        }

        @Override
        public String getDisplayName() {
            boolean hasCustomDescription = this.descriptor.hasCustomDescription();
            StringBuilder sb = new StringBuilder(this.estimateSize(hasCustomDescription));
            sb.append(this.rejectedVersions.size() > 1 ? "didn't match versions " : "didn't match version ");
            Joiner.on((String)", ").appendTo(sb, this.rejectedVersions);
            if (hasCustomDescription) {
                sb.append(" because ").append(this.descriptor.getDescription());
            }
            return sb.toString();
        }

        private int estimateSize(boolean hasCustomDescription) {
            return 24 + this.rejectedVersions.size() * 8 + (hasCustomDescription ? 24 : 0);
        }
    }
}

