/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.internal.component.model.ComponentResolveMetadata;

class PotentialEdge {
    final EdgeState edge;
    final ModuleVersionIdentifier toModuleVersionId;
    final ComponentResolveMetadata metadata;
    final ComponentState component;

    private PotentialEdge(EdgeState edge, ModuleVersionIdentifier toModuleVersionId, ComponentResolveMetadata metadata, ComponentState component) {
        this.edge = edge;
        this.toModuleVersionId = toModuleVersionId;
        this.metadata = metadata;
        this.component = component;
    }

    static PotentialEdge of(ResolveState resolveState, NodeState from, ModuleComponentIdentifier toComponent, ModuleComponentSelector toSelector, ComponentIdentifier owner) {
        return PotentialEdge.of(resolveState, from, toComponent, toSelector, owner, false, true);
    }

    static PotentialEdge of(ResolveState resolveState, NodeState from, ModuleComponentIdentifier toComponent, ModuleComponentSelector toSelector, ComponentIdentifier owner, boolean force, boolean transitive) {
        DependencyState dependencyState = new DependencyState(new LenientPlatformDependencyMetadata(resolveState, from, toSelector, toComponent, owner, force || PotentialEdge.isForce(from), transitive), resolveState.getComponentSelectorConverter());
        dependencyState = NodeState.maybeSubstitute(dependencyState, resolveState.getDependencySubstitutionApplicator());
        EdgeState edge = new EdgeState(from, dependencyState, from.previousTraversalExclusions, resolveState);
        ModuleVersionIdentifier toModuleVersionId = DefaultModuleVersionIdentifier.newId(toSelector.getModuleIdentifier(), toSelector.getVersion());
        ComponentState version = resolveState.getModule(toSelector.getModuleIdentifier()).getVersion(toModuleVersionId, toComponent);
        SelectorState selector = edge.getSelector();
        version.selectedBy(selector);
        ComponentResolveMetadata metadata = version.getMetadata();
        return new PotentialEdge(edge, toModuleVersionId, metadata, version);
    }

    private static boolean isForce(NodeState node) {
        for (EdgeState edgeState : node.getIncomingEdges()) {
            if (!edgeState.getSelector().isForce()) continue;
            return true;
        }
        return false;
    }
}

