/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.AttributeDesugaring;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.local.model.DslOriginDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.util.CollectionUtils;

class EdgeState
implements DependencyGraphEdge {
    private final DependencyState dependencyState;
    private final DependencyMetadata dependencyMetadata;
    private final NodeState from;
    private final SelectorState selector;
    private final ResolveState resolveState;
    private final ModuleExclusion transitiveExclusions;
    private final List<NodeState> targetNodes = Lists.newLinkedList();
    private final boolean isTransitive;
    private final boolean isConstraint;
    private ModuleVersionResolveException targetNodeSelectionFailure;

    EdgeState(NodeState from, DependencyState dependencyState, ModuleExclusion transitiveExclusions, ResolveState resolveState) {
        this.from = from;
        this.dependencyState = dependencyState;
        this.dependencyMetadata = dependencyState.getDependency();
        this.transitiveExclusions = transitiveExclusions;
        this.resolveState = resolveState;
        this.selector = resolveState.getSelector(dependencyState);
        this.isTransitive = from.isTransitive() && this.dependencyMetadata.isTransitive();
        this.isConstraint = this.dependencyMetadata.isConstraint();
    }

    public String toString() {
        return String.format("%s -> %s", this.from.toString(), this.dependencyMetadata);
    }

    @Override
    public NodeState getFrom() {
        return this.from;
    }

    DependencyMetadata getDependencyMetadata() {
        return this.dependencyMetadata;
    }

    ModuleIdentifier getTargetIdentifier() {
        return this.dependencyState.getModuleIdentifier();
    }

    @Nullable
    ComponentState getTargetComponent() {
        if (!this.selector.isResolved() || this.selector.getFailure() != null) {
            return null;
        }
        return this.getSelectedComponent();
    }

    @Override
    public SelectorState getSelector() {
        return this.selector;
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    public void attachToTargetConfigurations() {
        ModuleResolveState module;
        ComponentState targetComponent = this.getTargetComponent();
        if (targetComponent == null) {
            return;
        }
        if (this.isConstraint && (module = targetComponent.getModule()).isPending()) {
            this.selector.getTargetModule().removeUnattachedDependency(this);
            this.from.getOutgoingEdges().remove(this);
            module.addPendingNode(this.from);
            return;
        }
        this.calculateTargetConfigurations(targetComponent);
        for (NodeState targetConfiguration : this.targetNodes) {
            targetConfiguration.addIncomingEdge(this);
        }
        if (!this.targetNodes.isEmpty()) {
            this.selector.getTargetModule().removeUnattachedDependency(this);
        }
    }

    public void removeFromTargetConfigurations() {
        if (!this.targetNodes.isEmpty()) {
            for (NodeState targetConfiguration : this.targetNodes) {
                targetConfiguration.removeIncomingEdge(this);
            }
            this.targetNodes.clear();
        }
        this.targetNodeSelectionFailure = null;
    }

    public void failWith(Throwable err) {
        this.targetNodeSelectionFailure = new ModuleVersionResolveException(this.dependencyState.getRequested(), err);
    }

    public void restart() {
        if (this.from.isSelected()) {
            this.removeFromTargetConfigurations();
            this.attachToTargetConfigurations();
        }
    }

    @Override
    public ImmutableAttributes getAttributes() {
        ModuleResolveState module = this.selector.getTargetModule();
        return module.mergedConstraintsAttributes(this.dependencyState.getRequested().getAttributes());
    }

    private void calculateTargetConfigurations(ComponentState targetComponent) {
        List<ConfigurationMetadata> targetConfigurations;
        this.targetNodes.clear();
        this.targetNodeSelectionFailure = null;
        ComponentResolveMetadata targetModuleVersion = targetComponent.getMetadata();
        if (targetModuleVersion == null) {
            targetComponent.getModule().getPlatformState().addOrphanEdge(this);
            return;
        }
        try {
            ImmutableAttributes attributes = this.resolveState.getRoot().getMetadata().getAttributes();
            attributes = this.resolveState.getAttributesFactory().concat(attributes, this.getAttributes());
            if (this.isConstraint) {
                attributes = this.selector.getTargetModule().mergeConstraintAttributesWithHardDependencyAttributes(attributes);
            }
            targetConfigurations = this.dependencyMetadata.selectConfigurations(attributes, targetModuleVersion, this.resolveState.getAttributesSchema());
        }
        catch (Exception t) {
            this.targetNodeSelectionFailure = new ModuleVersionResolveException(this.dependencyState.getRequested(), (Throwable)t);
            return;
        }
        for (ConfigurationMetadata targetConfiguration : targetConfigurations) {
            NodeState targetNodeState = this.resolveState.getNode(targetComponent, targetConfiguration);
            this.targetNodes.add(targetNodeState);
        }
    }

    @Override
    public ModuleExclusion getExclusions() {
        List<ExcludeMetadata> excludes = this.dependencyMetadata.getExcludes();
        if (excludes.isEmpty()) {
            return this.transitiveExclusions;
        }
        ModuleExclusion edgeExclusions = this.resolveState.getModuleExclusions().excludeAny((ImmutableList<ExcludeMetadata>)ImmutableList.copyOf(excludes));
        return this.resolveState.getModuleExclusions().intersect(edgeExclusions, this.transitiveExclusions);
    }

    public ModuleExclusion getEdgeExclusions() {
        List<ExcludeMetadata> excludes = this.dependencyMetadata.getExcludes();
        if (excludes.isEmpty()) {
            return null;
        }
        return this.resolveState.getModuleExclusions().excludeAny((ImmutableList<ExcludeMetadata>)ImmutableList.copyOf(excludes));
    }

    @Override
    public boolean contributesArtifacts() {
        return !this.isConstraint;
    }

    @Override
    public ComponentSelector getRequested() {
        return AttributeDesugaring.desugarSelector(this.dependencyState.getRequested(), this.from.getAttributesFactory());
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        if (this.targetNodeSelectionFailure != null) {
            return this.targetNodeSelectionFailure;
        }
        ModuleVersionResolveException selectorFailure = this.selector.getFailure();
        if (selectorFailure != null) {
            return selectorFailure;
        }
        return this.getSelectedComponent().getMetadataResolveFailure();
    }

    @Override
    public Long getSelected() {
        return this.getSelectedComponent().getResultId();
    }

    @Override
    public boolean isTargetVirtualPlatform() {
        ComponentState selectedComponent = this.getSelectedComponent();
        return selectedComponent != null && selectedComponent.getModule().isVirtualPlatform();
    }

    @Override
    public ComponentSelectionReason getReason() {
        return this.selector.getSelectionReason();
    }

    @Override
    public boolean isConstraint() {
        return this.isConstraint;
    }

    private ComponentState getSelectedComponent() {
        return this.selector.getTargetModule().getSelected();
    }

    @Override
    public Dependency getOriginalDependency() {
        if (this.dependencyMetadata instanceof DslOriginDependencyMetadata) {
            return ((DslOriginDependencyMetadata)this.dependencyMetadata).getSource();
        }
        return null;
    }

    @Override
    public List<ComponentArtifactMetadata> getArtifacts(final ConfigurationMetadata targetConfiguration) {
        return CollectionUtils.collect(this.dependencyMetadata.getArtifacts(), new Transformer<ComponentArtifactMetadata, IvyArtifactName>(){

            @Override
            public ComponentArtifactMetadata transform(IvyArtifactName ivyArtifactName) {
                return targetConfiguration.artifact(ivyArtifactName);
            }
        });
    }

    void maybeDecreaseHardEdgeCount() {
        if (!this.isConstraint) {
            this.selector.getTargetModule().decreaseHardEdgeCount();
        }
    }
}

