/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.ivy.IvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ComponentSelectionInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.MetadataProvider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.rules.SpecRuleAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentSelectionRulesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentSelectionRulesProcessor.class);
    private final Spec<SpecRuleAction<? super ComponentSelection>> withNoInputs = new Spec<SpecRuleAction<? super ComponentSelection>>(){

        @Override
        public boolean isSatisfiedBy(SpecRuleAction<? super ComponentSelection> element) {
            return element.getAction().getInputTypes().isEmpty();
        }
    };
    private final Spec<SpecRuleAction<? super ComponentSelection>> withInputs = Specs.negate(this.withNoInputs);

    void apply(ComponentSelectionInternal selection, Collection<SpecRuleAction<? super ComponentSelection>> specRuleActions, MetadataProvider metadataProvider) {
        if (this.processRules(specRuleActions, this.withNoInputs, selection, metadataProvider)) {
            this.processRules(specRuleActions, this.withInputs, selection, metadataProvider);
        }
    }

    private boolean processRules(Collection<SpecRuleAction<? super ComponentSelection>> specRuleActions, Spec<SpecRuleAction<? super ComponentSelection>> filter, ComponentSelectionInternal selection, MetadataProvider metadataProvider) {
        for (SpecRuleAction<? super ComponentSelection> rule : specRuleActions) {
            if (!filter.isSatisfiedBy(rule)) continue;
            this.processRule(rule, selection, metadataProvider);
            if (!selection.isRejected()) continue;
            LOGGER.info("Selection of {} rejected by component selection rule: {}", (Object)selection.getCandidate().getDisplayName(), (Object)selection.getRejectionReason());
            return false;
        }
        return true;
    }

    private void processRule(SpecRuleAction<? super ComponentSelection> rule, ComponentSelection selection, MetadataProvider metadataProvider) {
        if (!rule.getSpec().isSatisfiedBy(selection)) {
            return;
        }
        List<Object> inputValues = this.getInputValues(rule.getAction().getInputTypes(), metadataProvider);
        if (inputValues == null) {
            return;
        }
        if (inputValues.contains(null)) {
            return;
        }
        try {
            rule.getAction().execute(selection, inputValues);
        }
        catch (Exception e) {
            throw new InvalidUserCodeException(String.format("There was an error while evaluating a component selection rule for %s.", selection.getCandidate().getDisplayName()), e);
        }
    }

    private List<Object> getInputValues(List<Class<?>> inputTypes, MetadataProvider metadataProvider) {
        if (inputTypes.size() == 0) {
            return Collections.emptyList();
        }
        if (!metadataProvider.isUsable()) {
            return null;
        }
        ArrayList<Object> inputs = new ArrayList<Object>(inputTypes.size());
        for (Class<?> inputType : inputTypes) {
            if (inputType == ComponentMetadata.class) {
                inputs.add(metadataProvider.getComponentMetadata());
                continue;
            }
            if (inputType == IvyModuleDescriptor.class) {
                inputs.add(metadataProvider.getIvyModuleDescriptor());
                continue;
            }
            throw new IllegalStateException();
        }
        return inputs;
    }
}

