/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.UnversionedModuleComponentSelector;
import org.gradle.api.internal.notations.ModuleNotationValidation;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.TypedNotationConverter;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.GUtil;

class ModuleSelectorStringNotationConverter
extends TypedNotationConverter<String, ComponentSelector> {
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public ModuleSelectorStringNotationConverter(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        super(String.class);
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    @Override
    protected ComponentSelector parseType(String notation) {
        assert (notation != null);
        String[] split = notation.split(":");
        if (split.length < 2 || split.length > 3) {
            throw new UnsupportedNotationException((Object)notation);
        }
        String group = ModuleNotationValidation.validate(split[0].trim(), notation);
        String name = ModuleNotationValidation.validate(split[1].trim(), notation);
        if (split.length == 2) {
            return new UnversionedModuleComponentSelector(this.moduleIdentifierFactory.module(group, name));
        }
        String version = split[2].trim();
        if (!GUtil.isTrue(version)) {
            throw new UnsupportedNotationException((Object)notation);
        }
        return DefaultModuleComponentSelector.newSelector(this.moduleIdentifierFactory.module(group, name), DefaultImmutableVersionConstraint.of(version));
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("String describing the module in 'group:name' format").example("'org.gradle:gradle-core'.");
        visitor.candidate("String describing the selector in 'group:name:version' format").example("'org.gradle:gradle-core:1.+'.");
    }
}

