/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.Closeable;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.CompositeCleanupAction;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.UnusedVersionsCacheCleanup;
import org.gradle.cache.internal.UsedGradleVersions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.resource.local.FileAccessTimeJournal;
import org.gradle.internal.serialize.Serializer;

public class DefaultArtifactCacheLockingManager
implements ArtifactCacheLockingManager,
Closeable {
    private final PersistentCache cache;

    public DefaultArtifactCacheLockingManager(CacheRepository cacheRepository, ArtifactCacheMetadata cacheMetaData, FileAccessTimeJournal fileAccessTimeJournal, UsedGradleVersions usedGradleVersions) {
        this.cache = cacheRepository.cache(cacheMetaData.getCacheDir()).withCrossVersionCache(CacheBuilder.LockTarget.CacheDirectory).withDisplayName("artifact cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).withCleanup(this.createCleanupAction(cacheMetaData, fileAccessTimeJournal, usedGradleVersions)).open();
    }

    private CleanupAction createCleanupAction(ArtifactCacheMetadata cacheMetaData, FileAccessTimeJournal fileAccessTimeJournal, UsedGradleVersions usedGradleVersions) {
        long maxAgeInDays = 30L;
        return CompositeCleanupAction.builder().add(UnusedVersionsCacheCleanup.create(CacheLayout.ROOT.getName(), CacheLayout.ROOT.getVersionMapping(), usedGradleVersions)).add(cacheMetaData.getExternalResourcesStoreDirectory(), UnusedVersionsCacheCleanup.create(CacheLayout.RESOURCES.getName(), CacheLayout.RESOURCES.getVersionMapping(), usedGradleVersions), new LeastRecentlyUsedCacheCleanup(new SingleDepthFilesFinder(2), fileAccessTimeJournal, maxAgeInDays)).add(cacheMetaData.getFileStoreDirectory(), UnusedVersionsCacheCleanup.create(CacheLayout.FILE_STORE.getName(), CacheLayout.FILE_STORE.getVersionMapping(), usedGradleVersions), new LeastRecentlyUsedCacheCleanup(new SingleDepthFilesFinder(4), fileAccessTimeJournal, maxAgeInDays)).add(cacheMetaData.getMetaDataStoreDirectory().getParentFile(), UnusedVersionsCacheCleanup.create(CacheLayout.META_DATA.getName(), CacheLayout.META_DATA.getVersionMapping(), usedGradleVersions)).build();
    }

    @Override
    public void close() {
        this.cache.close();
    }

    @Override
    public <T> T withFileLock(Factory<? extends T> action) {
        return this.cache.withFileLock(action);
    }

    @Override
    public void withFileLock(Runnable action) {
        this.cache.withFileLock(action);
    }

    @Override
    public <T> T useCache(Factory<? extends T> action) {
        return this.cache.useCache(action);
    }

    @Override
    public void useCache(Runnable action) {
        this.cache.useCache(action);
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        String cacheFileInMetaDataStore = CacheLayout.META_DATA.getKey() + "/" + cacheName;
        PersistentIndexedCache<K, V> persistentCache = this.cache.createCache(PersistentIndexedCacheParameters.of(cacheFileInMetaDataStore, keySerializer, valueSerializer));
        return new CacheLockingPersistentCache<K, V>(persistentCache);
    }

    private class CacheLockingPersistentCache<K, V>
    implements PersistentIndexedCache<K, V> {
        private final PersistentIndexedCache<K, V> persistentCache;

        public CacheLockingPersistentCache(PersistentIndexedCache<K, V> persistentCache) {
            this.persistentCache = persistentCache;
        }

        @Override
        @Nullable
        public V get(final K key) {
            return (V)DefaultArtifactCacheLockingManager.this.cache.useCache(new Factory<V>(){

                @Override
                public V create() {
                    return CacheLockingPersistentCache.this.persistentCache.get(key);
                }
            });
        }

        @Override
        public V get(final K key, final Transformer<? extends V, ? super K> producer) {
            return (V)DefaultArtifactCacheLockingManager.this.cache.useCache(new Factory<V>(){

                @Override
                public V create() {
                    return CacheLockingPersistentCache.this.persistentCache.get(key, producer);
                }
            });
        }

        @Override
        public void put(final K key, final V value) {
            DefaultArtifactCacheLockingManager.this.cache.useCache(new Runnable(){

                @Override
                public void run() {
                    CacheLockingPersistentCache.this.persistentCache.put(key, value);
                }
            });
        }

        @Override
        public void remove(final K key) {
            DefaultArtifactCacheLockingManager.this.cache.useCache(new Runnable(){

                @Override
                public void run() {
                    CacheLockingPersistentCache.this.persistentCache.remove(key);
                }
            });
        }
    }
}

