/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.internal.ReusableAction;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public abstract class PlatformSupport {
    public static final Attribute<String> COMPONENT_CATEGORY = Attribute.of("org.gradle.component.category", String.class);
    public static final String LIBRARY = "library";
    public static final String REGULAR_PLATFORM = "platform";
    public static final String ENFORCED_PLATFORM = "enforced-platform";

    public static boolean isTargettingPlatform(HasConfigurableAttributes<?> target) {
        String category = target.getAttributes().getAttribute(COMPONENT_CATEGORY);
        return REGULAR_PLATFORM.equals(category) || ENFORCED_PLATFORM.equals(category);
    }

    public static void configureSchema(AttributesSchema attributesSchema) {
        AttributeMatchingStrategy<String> componentTypeMatchingStrategy = attributesSchema.attribute(COMPONENT_CATEGORY);
        componentTypeMatchingStrategy.getDisambiguationRules().add(ComponentCategoryDisambiguationRule.class);
    }

    static <T> void addPlatformAttribute(HasConfigurableAttributes<T> dependency, final String type) {
        dependency.attributes(new Action<AttributeContainer>(){

            @Override
            public void execute(AttributeContainer attributeContainer) {
                attributeContainer.attribute(COMPONENT_CATEGORY, type);
            }
        });
    }

    public static boolean hasForcedDependencies(ComponentVariant variant) {
        return Objects.equal((Object)variant.getAttributes().getAttribute(COMPONENT_CATEGORY), (Object)ENFORCED_PLATFORM);
    }

    public static class PreferRegularPlatform
    implements AttributeDisambiguationRule<String> {
        private static final Set<String> PLATFORM_TYPES = ImmutableSet.of((Object)"platform", (Object)"enforced-platform");

        @Override
        public void execute(MultipleCandidatesDetails<String> details) {
            if (details.getCandidateValues().equals(PLATFORM_TYPES)) {
                details.closestMatch(PlatformSupport.REGULAR_PLATFORM);
            }
        }
    }

    public static class ComponentCategoryDisambiguationRule
    implements AttributeDisambiguationRule<String>,
    ReusableAction {
        @Override
        public void execute(MultipleCandidatesDetails<String> details) {
            String consumerValue = details.getConsumerValue();
            Set<String> candidateValues = details.getCandidateValues();
            if (consumerValue == null && candidateValues.contains(PlatformSupport.LIBRARY)) {
                details.closestMatch(PlatformSupport.LIBRARY);
                return;
            }
        }
    }
}

