/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.capabilities.Capability;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypedNotationConverter;

public class CapabilityNotationParserFactory
implements Factory<NotationParser<Object, Capability>> {
    private static final NotationParser<Object, Capability> SINGLETON_CONVERTER = CapabilityNotationParserFactory.createSingletonConverter();

    private static NotationParser<Object, Capability> createSingletonConverter() {
        return NotationParserBuilder.toType(Capability.class).converter(new StringNotationParser()).converter(new CapabilityMapNotationParser()).toComposite();
    }

    @Override
    @Nullable
    public NotationParser<Object, Capability> create() {
        return SINGLETON_CONVERTER;
    }

    private static class CapabilityMapNotationParser
    extends MapNotationConverter<Capability> {
        private CapabilityMapNotationParser() {
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Maps").example("[group: 'org.group', name: 'capability', version: '1.0']");
        }

        protected Capability parseMap(@MapKey(value="group") String group, @MapKey(value="name") String name, @MapKey(value="version") String version) {
            return new ImmutableCapability(group, name, version);
        }
    }

    private static class StringNotationParser
    extends TypedNotationConverter<String, Capability> {
        StringNotationParser() {
            super(String.class);
        }

        @Override
        protected Capability parseType(String notation) {
            String[] parts = notation.split(":");
            if (parts.length != 3) {
                StringNotationParser.reportInvalidNotation(notation);
            }
            for (String part : parts) {
                if (!StringUtils.isEmpty((String)part)) continue;
                StringNotationParser.reportInvalidNotation(notation);
            }
            return new ImmutableCapability(parts[0], parts[1], parts[2]);
        }

        private static void reportInvalidNotation(String notation) {
            throw new InvalidUserDataException("Invalid format for capability: '" + notation + "'. The correct notation is a 3-part group:name:version notation, e.g: 'org.group:capability:1.0'");
        }
    }
}

