/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.artifacts.ConfigurationVariantInternal;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.artifacts.configurations.LeafOutgoingVariant;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributeContainerWithErrorMessage;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultVariant
implements ConfigurationVariantInternal {
    private final Describable parentDisplayName;
    private final String name;
    private AttributeContainerInternal attributes;
    private final NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser;
    private final PublishArtifactSet artifacts;

    public DefaultVariant(Describable parentDisplayName, String name, AttributeContainerInternal parentAttributes, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, FileCollectionFactory fileCollectionFactory, ImmutableAttributesFactory cache, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
        this.parentDisplayName = parentDisplayName;
        this.name = name;
        this.attributes = cache.mutable(parentAttributes);
        this.artifactNotationParser = artifactNotationParser;
        this.artifacts = new DefaultPublishArtifactSet(this.getAsDescribable(), new DefaultDomainObjectSet<PublishArtifact>(PublishArtifact.class, collectionCallbackActionDecorator), fileCollectionFactory);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public OutgoingVariant convertToOutgoingVariant() {
        return new LeafOutgoingVariant(this.getAsDescribable(), this.attributes, this.artifacts);
    }

    private DisplayName getAsDescribable() {
        return Describables.of(this.parentDisplayName, "variant", this.name);
    }

    @Override
    public AttributeContainerInternal getAttributes() {
        return this.attributes;
    }

    @Override
    public ConfigurationVariant attributes(Action<? super AttributeContainer> action) {
        action.execute(this.attributes);
        return this;
    }

    @Override
    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    @Override
    public void artifact(Object notation) {
        this.artifacts.add((PublishArtifact)this.artifactNotationParser.parseNotation(notation));
    }

    @Override
    public void artifact(Object notation, Action<? super ConfigurablePublishArtifact> configureAction) {
        ConfigurablePublishArtifact publishArtifact = this.artifactNotationParser.parseNotation(notation);
        this.artifacts.add(publishArtifact);
        configureAction.execute(publishArtifact);
    }

    public String toString() {
        return this.getAsDescribable().getDisplayName();
    }

    @Override
    public void preventFurtherMutation() {
        this.attributes = new ImmutableAttributeContainerWithErrorMessage(this.attributes.asImmutable(), this.parentDisplayName);
    }
}

