/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.header.impl;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiMethodUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.impl.StandardHeaderParser;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;

public class ClassReferenceParser
extends StandardHeaderParser {
    public static final String MAIN_CLASS = "Main-Class";
    public static final String PREMAIN_CLASS = "Premain-Class";
    public static final String AGENT_CLASS = "Agent-Class";
    public static final String LAUNCHER_AGENT_CLASS = "Launcher-Agent-Class";
    public static final HeaderParser INSTANCE = new ClassReferenceParser();

    @Override
    @NotNull
    public PsiReference[] getReferences(@NotNull HeaderValuePart headerValuePart) {
        Module module;
        if (headerValuePart == null) {
            ClassReferenceParser.$$$reportNull$$$0(0);
        }
        JavaClassReferenceProvider provider = (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)headerValuePart)) != null ? new JavaClassReferenceProvider(){

            @Override
            public GlobalSearchScope getScope(Project project) {
                return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            }
        } : new JavaClassReferenceProvider();
        PsiReference[] psiReferenceArray = provider.getReferencesByElement(headerValuePart);
        if (psiReferenceArray == null) {
            ClassReferenceParser.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    @Override
    public boolean annotate(@NotNull Header header, @NotNull AnnotationHolder holder) {
        HeaderValue value2;
        if (header == null) {
            ClassReferenceParser.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            ClassReferenceParser.$$$reportNull$$$0(3);
        }
        if (!((value2 = header.getHeaderValue()) instanceof HeaderValuePart)) {
            return false;
        }
        HeaderValuePart valuePart = (HeaderValuePart)value2;
        String className2 = valuePart.getUnwrappedText();
        if (StringUtil.isEmptyOrSpaces((String)className2)) {
            holder.createErrorAnnotation(valuePart.getHighlightingRange(), ManifestBundle.message("header.reference.invalid", new Object[0]));
            return true;
        }
        Project project = header.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)header);
        GlobalSearchScope scope = module != null ? module.getModuleWithDependenciesAndLibrariesScope(false) : ProjectScope.getAllScope((Project)project);
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(className2, scope);
        if (aClass == null) {
            String message2 = JavaErrorMessages.message("error.cannot.resolve.class", className2);
            Annotation anno = holder.createErrorAnnotation(valuePart.getHighlightingRange(), message2);
            anno.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            return true;
        }
        return this.checkClass(valuePart, aClass, holder);
    }

    protected boolean checkClass(@NotNull HeaderValuePart valuePart, @NotNull PsiClass aClass, @NotNull AnnotationHolder holder) {
        String header;
        if (valuePart == null) {
            ClassReferenceParser.$$$reportNull$$$0(4);
        }
        if (aClass == null) {
            ClassReferenceParser.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            ClassReferenceParser.$$$reportNull$$$0(6);
        }
        if (MAIN_CLASS.equals(header = ((Header)valuePart.getParent()).getName()) && !PsiMethodUtil.hasMainMethod((PsiClass)aClass)) {
            holder.createErrorAnnotation(valuePart.getHighlightingRange(), ManifestBundle.message("header.main.class.invalid", new Object[0]));
            return true;
        }
        if (PREMAIN_CLASS.equals(header) && !ClassReferenceParser.hasInstrumenterMethod(aClass, "premain")) {
            holder.createErrorAnnotation(valuePart.getHighlightingRange(), ManifestBundle.message("header.pre-main.class.invalid", new Object[0]));
            return true;
        }
        if ((AGENT_CLASS.equals(header) || LAUNCHER_AGENT_CLASS.equals(header)) && !ClassReferenceParser.hasInstrumenterMethod(aClass, "agentmain")) {
            holder.createErrorAnnotation(valuePart.getHighlightingRange(), ManifestBundle.message("header.agent.class.invalid", new Object[0]));
            return true;
        }
        return false;
    }

    private static boolean hasInstrumenterMethod(PsiClass aClass, String methodName) {
        for (PsiMethod method : aClass.findMethodsByName(methodName, false)) {
            if (!PsiType.VOID.equals((Object)method.getReturnType()) || !method.hasModifierProperty("public") || !method.hasModifierProperty("static")) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerValuePart";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuePart";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

