/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProviderBase;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerEditorsProvider
extends XDebuggerEditorsProviderBase {
    @NotNull
    public FileType getFileType() {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        if (javaFileType == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(0);
        }
        return javaFileType;
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull String text2, @Nullable PsiElement context, boolean isPhysical) {
        if (project == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(1);
        }
        if (text2 == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(2);
        }
        return JavaCodeFragmentFactory.getInstance((Project)project).createExpressionCodeFragment(text2, context, null, isPhysical);
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@Nullable PsiElement context) {
        List list = ContainerUtil.map(DebuggerUtilsEx.getCodeFragmentFactories(context), factory -> factory.getFileType().getLanguage());
        if (list == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@NotNull Project project, @Nullable XSourcePosition sourcePosition) {
        if (project == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(4);
        }
        if (sourcePosition != null) {
            Collection<Language> collection = this.getSupportedLanguages(this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project));
            if (collection == null) {
                JavaDebuggerEditorsProvider.$$$reportNull$$$0(5);
            }
            return collection;
        }
        List<Language> list = Collections.emptyList();
        if (list == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public XExpression createExpression(@NotNull Project project, @NotNull Document document, @Nullable Language language, @NotNull EvaluationMode mode) {
        PsiFile psiFile;
        if (project == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(7);
        }
        if (document == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(8);
        }
        if (mode == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(9);
        }
        if ((psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) instanceof JavaCodeFragment) {
            XExpressionImpl xExpressionImpl = new XExpressionImpl(document.getText(), language, StringUtil.nullize((String)((JavaCodeFragment)psiFile).importsToString()), mode);
            if (xExpressionImpl == null) {
                JavaDebuggerEditorsProvider.$$$reportNull$$$0(10);
            }
            return xExpressionImpl;
        }
        XExpression xExpression = super.createExpression(project, document, language, mode);
        if (xExpression == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(11);
        }
        return xExpression;
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull XExpression expression2, @Nullable PsiElement context, boolean isPhysical) {
        TextWithImports text2;
        if (project == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(12);
        }
        if (expression2 == null) {
            JavaDebuggerEditorsProvider.$$$reportNull$$$0(13);
        }
        if ((text2 = TextWithImportsImpl.fromXExpression(expression2)) != null) {
            CodeFragmentFactory factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text2, context);
            JavaCodeFragment codeFragment = factory.createPresentationCodeFragment(text2, context, project);
            if (context != null) {
                PsiClass contextClass;
                PsiType contextType = (PsiType)context.getUserData(DebuggerUtilsImpl.PSI_TYPE_KEY);
                if (contextType == null && (contextClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiClass.class})) != null) {
                    contextType = JavaPsiFacade.getElementFactory((Project)codeFragment.getProject()).createType(contextClass);
                }
                codeFragment.setThisType(contextType);
            }
            return codeFragment;
        }
        return super.createExpressionCodeFragment(project, expression2, context, isPhysical);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/java/debugger/JavaDebuggerEditorsProvider";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLanguages";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionCodeFragment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedLanguages";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

