/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.unicode;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementEditorPredicate;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnicodeUnescapeIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            UnicodeUnescapeIntention.$$$reportNull$$$0(0);
        }
    }

    @Override
    protected void processIntention(Editor editor, @NotNull PsiElement element) {
        SelectionModel selectionModel;
        if (element == null) {
            UnicodeUnescapeIntention.$$$reportNull$$$0(1);
        }
        if ((selectionModel = editor.getSelectionModel()).hasSelection()) {
            int index;
            Document document = editor.getDocument();
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            String text2 = document.getText(new TextRange(start, end));
            int textLength = end - start;
            StringBuilder replacement = new StringBuilder(textLength);
            int anchor = 0;
            while ((index = UnicodeUnescapeIntention.indexOfUnicodeEscape(text2, anchor + 1)) >= 0) {
                replacement.append(text2, anchor, index);
                int hexStart = index + 1;
                while (text2.charAt(hexStart) == 'u') {
                    ++hexStart;
                }
                anchor = hexStart + 4;
                int c = Integer.parseInt(text2.substring(hexStart, anchor), 16);
                replacement.appendCodePoint(c);
            }
            replacement.append(text2, anchor, textLength);
            document.replaceString(start, end, (CharSequence)replacement);
        } else {
            CaretModel caretModel = editor.getCaretModel();
            Document document = editor.getDocument();
            int lineNumber = document.getLineNumber(caretModel.getOffset());
            int lineStartOffset = document.getLineStartOffset(lineNumber);
            String line = document.getText(new TextRange(lineStartOffset, document.getLineEndOffset(lineNumber)));
            int column = caretModel.getLogicalPosition().column;
            int index1 = UnicodeUnescapeIntention.indexOfUnicodeEscape(line, column);
            int index2 = UnicodeUnescapeIntention.indexOfUnicodeEscape(line, column + 1);
            int escapeStart = index2 == column ? index2 : index1;
            int hexStart = escapeStart + 1;
            while (line.charAt(hexStart) == 'u') {
                ++hexStart;
            }
            char c = (char)Integer.parseInt(line.substring(hexStart, hexStart + 4), 16);
            if (Character.isHighSurrogate(c)) {
                hexStart += 4;
                if (line.charAt(hexStart++) == '\\' && line.charAt(hexStart++) == 'u') {
                    while (line.charAt(hexStart) == 'u') {
                        ++hexStart;
                    }
                    char d = (char)Integer.parseInt(line.substring(hexStart, hexStart + 4), 16);
                    document.replaceString(lineStartOffset + escapeStart, lineStartOffset + hexStart + 4, (CharSequence)String.valueOf(new char[]{c, d}));
                    return;
                }
            } else if (Character.isLowSurrogate(c) && escapeStart >= 6 && StringUtil.isHexDigit((char)line.charAt(escapeStart - 1)) && StringUtil.isHexDigit((char)line.charAt(escapeStart - 2)) && StringUtil.isHexDigit((char)line.charAt(escapeStart - 3)) && StringUtil.isHexDigit((char)line.charAt(escapeStart - 4))) {
                int i;
                for (i = escapeStart - 5; i > 0 && line.charAt(i) == 'u'; --i) {
                }
                if (line.charAt(i) == '\\' && (i == 0 || line.charAt(i - 1) != '\\')) {
                    char b = (char)Integer.parseInt(line.substring(escapeStart - 4, escapeStart), 16);
                    document.replaceString(lineStartOffset + i, lineStartOffset + hexStart + 4, (CharSequence)String.valueOf(new char[]{b, c}));
                    return;
                }
            }
            document.replaceString(lineStartOffset + escapeStart, lineStartOffset + hexStart + 4, (CharSequence)String.valueOf(c));
        }
    }

    static int indexOfUnicodeEscape(@NotNull String text2, int offset) {
        if (text2 == null) {
            UnicodeUnescapeIntention.$$$reportNull$$$0(2);
        }
        int length = text2.length();
        for (int i = 0; i < length; ++i) {
            int escapeEnd;
            char c = text2.charAt(i);
            if (c != '\\') continue;
            boolean isEscape = true;
            for (int previousChar = i - 1; previousChar >= 0 && text2.charAt(previousChar) == '\\'; --previousChar) {
                isEscape = !isEscape;
            }
            if (!isEscape) continue;
            int nextChar = i;
            while (++nextChar < length && text2.charAt(nextChar) == 'u') {
            }
            if (nextChar == i + 1 || nextChar + 3 >= length) break;
            if (!StringUtil.isHexDigit((char)text2.charAt(nextChar)) || !StringUtil.isHexDigit((char)text2.charAt(nextChar + 1)) || !StringUtil.isHexDigit((char)text2.charAt(nextChar + 2)) || !StringUtil.isHexDigit((char)text2.charAt(nextChar + 3)) || offset > (escapeEnd = nextChar + 4)) continue;
            char d = (char)Integer.parseInt(text2.substring(nextChar, nextChar + 4), 16);
            if (d == '\r') {
                return -1;
            }
            return i;
        }
        return -1;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        UnicodeEscapePredicate unicodeEscapePredicate = new UnicodeEscapePredicate();
        if (unicodeEscapePredicate == null) {
            UnicodeUnescapeIntention.$$$reportNull$$$0(3);
        }
        return unicodeEscapePredicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/unicode/UnicodeUnescapeIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/unicode/UnicodeUnescapeIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "indexOfUnicodeEscape";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnicodeEscapePredicate
    extends PsiElementEditorPredicate {
        private UnicodeEscapePredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element, @Nullable Editor editor) {
            int column;
            if (editor == null) {
                return false;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            Document document = editor.getDocument();
            if (selectionModel.hasSelection()) {
                int start = selectionModel.getSelectionStart();
                int end = selectionModel.getSelectionEnd();
                if (start < 0 || end < 0 || start > end) {
                    return false;
                }
                String text2 = document.getCharsSequence().subSequence(start, end).toString();
                return UnicodeUnescapeIntention.indexOfUnicodeEscape(text2, 1) >= 0;
            }
            CaretModel caretModel = editor.getCaretModel();
            int lineNumber = document.getLineNumber(caretModel.getOffset());
            String line = document.getText(new TextRange(document.getLineStartOffset(lineNumber), document.getLineEndOffset(lineNumber)));
            int index = UnicodeUnescapeIntention.indexOfUnicodeEscape(line, column = caretModel.getLogicalPosition().column);
            return index >= 0 && column >= index;
        }
    }
}

