/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.PsiElementPredicate;

class ReplaceOperatorAssignmentWithPostfixExpressionPredicate
implements PsiElementPredicate {
    ReplaceOperatorAssignmentWithPostfixExpressionPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        IElementType tokenType = assignmentExpression.getOperationTokenType();
        if (!JavaTokenType.PLUSEQ.equals(tokenType) && !JavaTokenType.MINUSEQ.equals(tokenType)) {
            return false;
        }
        PsiExpression lhs = assignmentExpression.getLExpression();
        if (!TypeConversionUtil.isNumericType((PsiType)lhs.getType())) {
            return false;
        }
        PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getRExpression());
        return ExpressionUtils.isLiteral((PsiElement)rhs, 1);
    }
}

