/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.modifiers;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.JavaThrownExceptionInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.modifiers.AccessModifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeModifierIntention
extends BaseElementAtCaretIntentionAction {
    private static final List<AccessModifier> ALL_MODIFIERS = ContainerUtil.immutableList((Object[])AccessModifier.values());
    private static final List<AccessModifier> PUBLIC_PRIVATE = ContainerUtil.immutableList((Object[])new AccessModifier[]{AccessModifier.PUBLIC, AccessModifier.PRIVATE});
    private static final List<AccessModifier> PUBLIC_PACKAGE = ContainerUtil.immutableList((Object[])new AccessModifier[]{AccessModifier.PUBLIC, AccessModifier.PACKAGE_LOCAL});
    private final boolean myErrorFix;
    private AccessModifier myTarget;

    public ChangeModifierIntention() {
        this(false);
    }

    public ChangeModifierIntention(boolean errorFix) {
        this.myErrorFix = errorFix;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ChangeModifierIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ChangeModifierIntention.$$$reportNull$$$0(1);
        }
        if (!JavaLanguage.INSTANCE.equals(element.getLanguage())) {
            return false;
        }
        PsiMember member = ChangeModifierIntention.findMember(element);
        if (!(member instanceof PsiNameIdentifierOwner)) {
            return false;
        }
        PsiElement identifier = ((PsiNameIdentifierOwner)member).getNameIdentifier();
        if (identifier == null || identifier.getTextRange().getEndOffset() <= element.getTextRange().getStartOffset()) {
            return false;
        }
        ArrayList<AccessModifier> modifiers = new ArrayList<AccessModifier>(ChangeModifierIntention.getAvailableModifiers(member));
        if (modifiers.isEmpty()) {
            return false;
        }
        if (!this.myErrorFix && modifiers.stream().noneMatch(mod -> mod.hasModifier((PsiModifierListOwner)member))) {
            return false;
        }
        modifiers.removeIf(mod -> mod.hasModifier((PsiModifierListOwner)member));
        AccessModifier target = null;
        if (modifiers.isEmpty()) {
            return false;
        }
        if (modifiers.size() == 1) {
            target = (AccessModifier)((Object)modifiers.get(0));
            this.setText("Make '" + identifier.getText() + "' " + (Object)((Object)target));
        } else {
            this.setText(this.getFamilyName());
        }
        this.myTarget = target;
        return true;
    }

    private static PsiMember findMember(@NotNull PsiElement element) {
        if (element == null) {
            ChangeModifierIntention.$$$reportNull$$$0(2);
        }
        PsiMember member;
        while ((member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiStatement.class, PsiExpression.class})) instanceof PsiTypeParameter) {
            element = member.getParent();
        }
        return member;
    }

    @NotNull
    private static List<AccessModifier> getAvailableModifiers(PsiMember member) {
        if (member == null) {
            List<AccessModifier> list = Collections.emptyList();
            if (list == null) {
                ChangeModifierIntention.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiClass containingClass = member.getContainingClass();
        if (member instanceof PsiField) {
            if (member instanceof PsiEnumConstant || containingClass == null || containingClass.isInterface()) {
                List<AccessModifier> list = Collections.emptyList();
                if (list == null) {
                    ChangeModifierIntention.$$$reportNull$$$0(4);
                }
                return list;
            }
            List<AccessModifier> list = ALL_MODIFIERS;
            if (list == null) {
                ChangeModifierIntention.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (member instanceof PsiMethod) {
            if (containingClass == null || containingClass.isEnum() && ((PsiMethod)member).isConstructor()) {
                List<AccessModifier> list = Collections.emptyList();
                if (list == null) {
                    ChangeModifierIntention.$$$reportNull$$$0(6);
                }
                return list;
            }
            if (containingClass.isInterface() && PsiUtil.isLanguageLevel9OrHigher((PsiElement)member)) {
                List<AccessModifier> list = PUBLIC_PRIVATE;
                if (list == null) {
                    ChangeModifierIntention.$$$reportNull$$$0(7);
                }
                return list;
            }
            AccessModifier minAccess = ChangeModifierIntention.getMinAccess((PsiMethod)member);
            if (minAccess != AccessModifier.PRIVATE) {
                List list = ContainerUtil.filter(ALL_MODIFIERS, mod -> mod.compareTo(minAccess) <= 0);
                if (list == null) {
                    ChangeModifierIntention.$$$reportNull$$$0(8);
                }
                return list;
            }
            List<AccessModifier> list = ALL_MODIFIERS;
            if (list == null) {
                ChangeModifierIntention.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (member instanceof PsiClass) {
            if (PsiUtil.isLocalOrAnonymousClass((PsiClass)((PsiClass)member))) {
                List<AccessModifier> list = Collections.emptyList();
                if (list == null) {
                    ChangeModifierIntention.$$$reportNull$$$0(10);
                }
                return list;
            }
            if (containingClass == null) {
                List<AccessModifier> list = PUBLIC_PACKAGE;
                if (list == null) {
                    ChangeModifierIntention.$$$reportNull$$$0(11);
                }
                return list;
            }
            List<AccessModifier> list = ALL_MODIFIERS;
            if (list == null) {
                ChangeModifierIntention.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<AccessModifier> list = Collections.emptyList();
        if (list == null) {
            ChangeModifierIntention.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private static AccessModifier getMinAccess(PsiMethod method) {
        HierarchicalMethodSignature superSignature;
        PsiMethod superMethod;
        AccessModifier current;
        if (method.isConstructor() || method.hasModifierProperty("static")) {
            AccessModifier accessModifier = AccessModifier.PRIVATE;
            if (accessModifier == null) {
                ChangeModifierIntention.$$$reportNull$$$0(14);
            }
            return accessModifier;
        }
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        AccessModifier lowest = AccessModifier.PRIVATE;
        Iterator iterator = signature.getSuperSignatures().iterator();
        while (iterator.hasNext() && (!(current = AccessModifier.fromModifierList((superMethod = (superSignature = (HierarchicalMethodSignature)iterator.next()).getMethod()).getModifierList())).isWeaker(lowest) || method.hasModifierProperty("abstract") && !MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method) || !PsiUtil.isAccessible((Project)method.getProject(), (PsiMember)superMethod, (PsiElement)method, null) || (lowest = current) != AccessModifier.PUBLIC)) {
        }
        AccessModifier accessModifier = lowest;
        if (accessModifier == null) {
            ChangeModifierIntention.$$$reportNull$$$0(15);
        }
        return accessModifier;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            ChangeModifierIntention.$$$reportNull$$$0(16);
        }
        return currentFile;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(final @NotNull Project project, final Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        StartMarkAction markAction;
        PsiMember member;
        if (project == null) {
            ChangeModifierIntention.$$$reportNull$$$0(17);
        }
        if (element == null) {
            ChangeModifierIntention.$$$reportNull$$$0(18);
        }
        if ((member = ChangeModifierIntention.findMember(element)) == null) {
            return;
        }
        PsiFile file = member.getContainingFile();
        if (file == null) {
            return;
        }
        List<AccessModifier> modifiers = ChangeModifierIntention.getAvailableModifiers(member);
        if (modifiers.isEmpty()) {
            return;
        }
        AccessModifier target = this.myTarget;
        if (modifiers.contains((Object)target)) {
            ChangeModifierIntention.setModifier(member, target);
            return;
        }
        TextRange range = ChangeModifierIntention.getRange(member);
        Document document = editor.getDocument();
        CharSequence sequence = document.getCharsSequence();
        if (range.getLength() == 0) {
            int pos;
            for (pos = range.getStartOffset(); pos < sequence.length() && StringUtil.isWhiteSpace((char)sequence.charAt(pos)); ++pos) {
            }
            range = TextRange.from((int)pos, (int)0);
        }
        final CaretModel model = editor.getCaretModel();
        final RangeMarker cursorMarker = document.createRangeMarker(model.getOffset(), model.getOffset());
        model.moveToOffset(range.getStartOffset());
        try {
            markAction = StartMarkAction.start((Editor)editor, (Project)project, (String)this.getFamilyName());
        }
        catch (StartMarkAction.AlreadyStartedException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)StringUtil.toTitleCase((String)this.getFamilyName()));
            return;
        }
        TextAttributes lvAttr = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.LIVE_TEMPLATE_ATTRIBUTES);
        final RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 6001, lvAttr, HighlighterTargetArea.EXACT_RANGE);
        highlighter.setGreedyToRight(true);
        highlighter.setGreedyToLeft(true);
        final ModifierUpdater updater = new ModifierUpdater(file, document, range, this.getFamilyName());
        AccessModifier current = (AccessModifier)((Object)ContainerUtil.find(modifiers, m -> m.hasModifier((PsiModifierListOwner)member)));
        SmartPsiElementPointer memberPointer = SmartPointerManager.createPointer((PsiElement)member);
        JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder(modifiers).setSelectionMode(0).setSelectedValue((Object)current, true).setAccessibleName("Change Modifier").setMovable(false).setResizable(false).setRequestFocus(true).setFont(editor.getColorsScheme().getFont(EditorFontType.PLAIN)).setItemSelectedCallback(updater::setModifier).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                highlighter.dispose();
                model.moveToOffset(cursorMarker.getStartOffset());
                if (!event.isOk()) {
                    FinishMarkAction.finish((Project)project, (Editor)editor, (StartMarkAction)markAction);
                    updater.undoChange(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/siyeh/ipp/modifiers/ChangeModifierIntention$1", "onClosed"));
            }
        }).setNamerForFiltering(AccessModifier::toString).setItemChosenCallback(t -> {
            updater.undoChange(false);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            updater.setModifier((AccessModifier)((Object)t));
            PsiMember m = (PsiMember)memberPointer.getElement();
            if (m == null) {
                return;
            }
            PsiModifierList modifierList = m.getModifierList();
            if (modifierList == null) {
                return;
            }
            MultiMap<PsiElement, String> conflicts = ChangeModifierIntention.checkForConflicts(m, t);
            if (conflicts == null) {
                FinishMarkAction.finish((Project)project, (Editor)editor, (StartMarkAction)markAction);
                updater.undoChange(true);
                return;
            }
            if (!conflicts.isEmpty()) {
                FinishMarkAction.finish((Project)project, (Editor)editor, (StartMarkAction)markAction);
                updater.undoChange(true);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                ChangeModifierIntention.processWithConflicts(modifierList, t, conflicts);
            } else {
                updater.undoChange(false);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                ChangeModifierIntention.changeModifier(modifierList, t, false);
                FinishMarkAction.finish((Project)project, (Editor)editor, (StartMarkAction)markAction);
            }
        }).createPopup();
        popup.showInBestPositionFor(editor);
    }

    private static TextRange getRange(PsiMember member) {
        PsiModifierList modifierList = member.getModifierList();
        if (modifierList == null) {
            return TextRange.from((int)member.getTextRange().getStartOffset(), (int)0);
        }
        PsiKeyword anchor = ChangeModifierIntention.getAnchorKeyword(modifierList);
        if (anchor != null) {
            return anchor.getTextRange();
        }
        anchor = PsiTreeUtil.getChildOfType((PsiElement)modifierList, PsiKeyword.class);
        if (anchor != null) {
            return TextRange.from((int)anchor.getTextRange().getStartOffset(), (int)0);
        }
        return TextRange.from((int)modifierList.getTextRange().getEndOffset(), (int)0);
    }

    @Nullable
    private static PsiKeyword getAnchorKeyword(PsiModifierList modifierList) {
        for (PsiElement child : modifierList.getChildren()) {
            if (!ALL_MODIFIERS.contains((Object)AccessModifier.fromKeyword((PsiKeyword)ObjectUtils.tryCast((Object)child, PsiKeyword.class)))) continue;
            return (PsiKeyword)child;
        }
        return null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = IntentionPowerPackBundle.message("change.modifier.intention.name", new Object[0]);
        if (string == null) {
            ChangeModifierIntention.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static void setModifier(PsiMember member, AccessModifier modifier) {
        PsiModifierList modifierList = member.getModifierList();
        if (modifierList == null) {
            return;
        }
        MultiMap<PsiElement, String> conflicts = ChangeModifierIntention.checkForConflicts(member, modifier);
        if (conflicts == null) {
            return;
        }
        ChangeModifierIntention.processWithConflicts(modifierList, modifier, conflicts);
    }

    private static void processWithConflicts(@NotNull PsiModifierList modifierList, @NotNull AccessModifier modifier, @NotNull MultiMap<PsiElement, String> conflicts) {
        boolean shouldProcess;
        if (modifierList == null) {
            ChangeModifierIntention.$$$reportNull$$$0(20);
        }
        if (modifier == null) {
            ChangeModifierIntention.$$$reportNull$$$0(21);
        }
        if (conflicts == null) {
            ChangeModifierIntention.$$$reportNull$$$0(22);
        }
        if (conflicts.isEmpty()) {
            shouldProcess = true;
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (!BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            shouldProcess = true;
        } else {
            ConflictsDialog dialog = new ConflictsDialog(modifierList.getProject(), conflicts, () -> ChangeModifierIntention.changeModifier(modifierList, modifier, true));
            shouldProcess = dialog.showAndGet();
        }
        if (shouldProcess) {
            ChangeModifierIntention.changeModifier(modifierList, modifier, !conflicts.isEmpty());
        }
    }

    private static void changeModifier(PsiModifierList modifierList, AccessModifier modifier, boolean hasConflicts) {
        PsiElement parent = modifierList.getParent();
        if (parent instanceof PsiMethod && hasConflicts) {
            PsiMethod method = (PsiMethod)parent;
            new ChangeSignatureProcessor(parent.getProject(), method, false, modifier.toPsiModifier(), method.getName(), method.getReturnType(), ParameterInfoImpl.fromMethod(method), JavaThrownExceptionInfo.extractExceptions(method)).run();
            return;
        }
        PsiFile file = modifierList.getContainingFile();
        WriteCommandAction.writeCommandAction((Project)file.getProject(), (PsiFile[])new PsiFile[]{file}).withName(IntentionPowerPackBundle.message("change.modifier.intention.name", new Object[0])).run(() -> {
            modifierList.setModifierProperty(modifier.toPsiModifier(), true);
            if (modifier != AccessModifier.PACKAGE_LOCAL) {
                Project project = modifierList.getProject();
                PsiElement whitespace = PsiParserFacade.SERVICE.getInstance((Project)project).createWhiteSpaceFromText(" ");
                PsiElement sibling = modifierList.getNextSibling();
                if (sibling instanceof PsiWhiteSpace) {
                    sibling.replace(whitespace);
                    CodeStyleManager.getInstance((Project)project).reformatRange(parent, modifierList.getTextOffset(), modifierList.getNextSibling().getTextOffset());
                }
            }
        });
    }

    @Nullable
    private static MultiMap<PsiElement, String> checkForConflicts(@NotNull PsiMember member, AccessModifier modifier) {
        if (member == null) {
            ChangeModifierIntention.$$$reportNull$$$0(23);
        }
        if (member instanceof PsiClass && modifier == AccessModifier.PUBLIC) {
            String className2;
            PsiClass aClass = (PsiClass)member;
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiJavaFile)) {
                return MultiMap.emptyInstance();
            }
            PsiJavaFile javaFile = (PsiJavaFile)parent;
            String name2 = FileUtilRt.getNameWithoutExtension((String)javaFile.getName());
            if (name2.equals(className2 = aClass.getName())) {
                return MultiMap.emptyInstance();
            }
            MultiMap conflicts = new MultiMap();
            conflicts.putValue((Object)aClass, (Object)IntentionPowerPackBundle.message("0.is.declared.in.1.but.when.public.should.be.declared.in.a.file.named.2", RefactoringUIUtil.getDescription((PsiElement)aClass, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)javaFile, (boolean)false), CommonRefactoringUtil.htmlEmphasize((String)(className2 + ".java"))));
            return conflicts;
        }
        PsiModifierList modifierList = member.getModifierList();
        if (modifierList == null || modifierList.hasModifierProperty("private")) {
            return MultiMap.emptyInstance();
        }
        PsiModifierList copy = (PsiModifierList)modifierList.copy();
        copy.setModifierProperty(modifier.toPsiModifier(), true);
        SearchScope useScope = member.getUseScope();
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> {
            if (member instanceof PsiMethod) {
                JavaChangeSignatureUsageProcessor.ConflictSearcher.searchForHierarchyConflicts((PsiMethod)member, (MultiMap<PsiElement, String>)conflicts, modifier.toPsiModifier());
            }
            Query search = ReferencesSearch.search((PsiElement)member, (SearchScope)useScope);
            search.forEach(reference -> {
                PsiElement element = reference.getElement();
                if (JavaResolveUtil.isAccessible(member, member.getContainingClass(), copy, element, null, null)) {
                    return true;
                }
                PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClass.class, PsiFile.class});
                if (context == null) {
                    return true;
                }
                conflicts.putValue((Object)element, (Object)RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false), PsiBundle.visibilityPresentation((String)modifier.toPsiModifier()), RefactoringUIUtil.getDescription((PsiElement)context, (boolean)true)}));
                return true;
            });
        }), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, member.getProject())) {
            return null;
        }
        return conflicts;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/modifiers/ChangeModifierIntention";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/modifiers/ChangeModifierIntention";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableModifiers";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinAccess";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findMember";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processWithConflicts";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkForConflicts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModifierUpdater {
        private final Document myDocument;
        private final boolean myExtendLeft;
        private final boolean myExtendRight;
        private final String myOriginalText;
        private final RangeMarker myMarker;
        private final String myActionName;
        private final PsiFile myFile;

        ModifierUpdater(@NotNull PsiFile file, @NotNull Document document, @NotNull TextRange range, @NotNull String actionName) {
            if (file == null) {
                ModifierUpdater.$$$reportNull$$$0(0);
            }
            if (document == null) {
                ModifierUpdater.$$$reportNull$$$0(1);
            }
            if (range == null) {
                ModifierUpdater.$$$reportNull$$$0(2);
            }
            if (actionName == null) {
                ModifierUpdater.$$$reportNull$$$0(3);
            }
            this.myDocument = document;
            this.myFile = file;
            this.myActionName = actionName;
            CharSequence sequence = document.getCharsSequence();
            this.myExtendLeft = range.getStartOffset() > 0 && !StringUtil.isWhiteSpace((char)sequence.charAt(range.getStartOffset() - 1));
            this.myExtendRight = range.getEndOffset() < sequence.length() && !StringUtil.isWhiteSpace((char)sequence.charAt(range.getEndOffset()));
            this.myOriginalText = sequence.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
            this.myMarker = document.createRangeMarker(range);
            this.myMarker.setGreedyToRight(true);
            this.myMarker.setGreedyToLeft(true);
        }

        void undoChange(boolean viaUndoManager) {
            Project project = this.myFile.getProject();
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            FileEditor fileEditor = fileEditorManager.getSelectedEditor(this.myFile.getVirtualFile());
            UndoManager manager = UndoManager.getInstance((Project)project);
            if (viaUndoManager && manager.isUndoAvailable(fileEditor)) {
                manager.undo(fileEditor);
            } else {
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{this.myFile}).withName(this.myActionName).run(() -> this.myDocument.replaceString(this.myMarker.getStartOffset(), this.myMarker.getEndOffset(), (CharSequence)this.myOriginalText));
            }
        }

        void setModifier(@Nullable AccessModifier target) {
            if (target == null) {
                return;
            }
            String updatedText = target == AccessModifier.PACKAGE_LOCAL ? " " : (this.myExtendLeft ? (this.myExtendRight ? " " + (Object)((Object)target) + " " : " " + (Object)((Object)target)) : (this.myExtendRight ? (Object)((Object)target) + " " : target.toString()));
            WriteCommandAction.writeCommandAction((Project)this.myFile.getProject(), (PsiFile[])new PsiFile[]{this.myFile}).withName(this.myActionName).run(() -> this.myDocument.replaceString(this.myMarker.getStartOffset(), this.myMarker.getEndOffset(), (CharSequence)updatedText));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionName";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ipp/modifiers/ChangeModifierIntention$ModifierUpdater";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

