/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.modifiers;

import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

enum AccessModifier {
    PUBLIC("public"),
    PROTECTED("protected"),
    PACKAGE_LOCAL("packageLocal"),
    PRIVATE("private");

    @NotNull
    @PsiModifier.ModifierConstant
    private final String myModifier;

    private AccessModifier(String modifier) {
        if (modifier == null) {
            AccessModifier.$$$reportNull$$$0(0);
        }
        this.myModifier = modifier;
    }

    @NotNull
    @PsiModifier.ModifierConstant
    public String toPsiModifier() {
        String string = this.myModifier;
        if (string == null) {
            AccessModifier.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean hasModifier(@NotNull PsiModifierListOwner owner2) {
        if (owner2 == null) {
            AccessModifier.$$$reportNull$$$0(2);
        }
        return owner2.hasModifierProperty(this.toPsiModifier());
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static AccessModifier fromKeyword(@Nullable PsiKeyword keyword) {
        return keyword == null ? null : AccessModifier.fromPsiModifier(keyword.getText());
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static AccessModifier fromPsiModifier(@Nullable String modifier) {
        if (modifier == null) {
            return null;
        }
        switch (modifier) {
            case "public": {
                return PUBLIC;
            }
            case "protected": {
                return PROTECTED;
            }
            case "packageLocal": {
                return PACKAGE_LOCAL;
            }
            case "private": {
                return PRIVATE;
            }
        }
        return null;
    }

    public static AccessModifier fromModifierList(@NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            AccessModifier.$$$reportNull$$$0(3);
        }
        if (modifierList.hasModifierProperty("private")) {
            return PRIVATE;
        }
        if (modifierList.hasModifierProperty("packageLocal")) {
            return PACKAGE_LOCAL;
        }
        if (modifierList.hasModifierProperty("protected")) {
            return PROTECTED;
        }
        return PUBLIC;
    }

    public boolean isWeaker(@NotNull AccessModifier other) {
        if (other == null) {
            AccessModifier.$$$reportNull$$$0(4);
        }
        return this.ordinal() < other.ordinal();
    }

    public String toString() {
        return this == PACKAGE_LOCAL ? "package-private" : this.toPsiModifier();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/modifiers/AccessModifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/modifiers/AccessModifier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiModifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasModifier";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromModifierList";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isWeaker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

