/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.expression.eliminate;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiPrecedenceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.hash.HashMap;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ipp.expression.eliminate.EliminableExpression;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EliminateUtils {
    private static final IElementType[] PREFIXES = new IElementType[]{JavaTokenType.PLUS, JavaTokenType.MINUS};
    private static final Map<IElementType, String> OPS = new HashMap();
    private static final Map<IElementType, IElementType> INVERTED_OPS = new HashMap();

    EliminateUtils() {
    }

    static <T extends EliminableExpression> T createExpression(@NotNull PsiParenthesizedExpression parenthesized, @NotNull BiFunction<? super PsiPolyadicExpression, ? super PsiExpression, T> ctor, @NotNull Map<IElementType, IElementType[]> outerOperators) {
        PsiPolyadicExpression innerExpr;
        if (parenthesized == null) {
            EliminateUtils.$$$reportNull$$$0(0);
        }
        if (ctor == null) {
            EliminateUtils.$$$reportNull$$$0(1);
        }
        if (outerOperators == null) {
            EliminateUtils.$$$reportNull$$$0(2);
        }
        if ((innerExpr = EliminateUtils.getInnerExpression(parenthesized, outerOperators.keySet())) == null) {
            return null;
        }
        PsiExpression operand2 = EliminateUtils.skipPrefixedExprUp((PsiExpression)parenthesized);
        if (operand2 == null) {
            return null;
        }
        PsiPolyadicExpression outerExpr = EliminateUtils.getOuterExpression(innerExpr, operand2, outerOperators);
        if (outerExpr == null && !(operand2 instanceof PsiPrefixExpression)) {
            return null;
        }
        if (SideEffectChecker.mayHaveSideEffects((PsiExpression)(outerExpr == null ? operand2 : outerExpr))) {
            return null;
        }
        return (T)((EliminableExpression)ctor.apply((PsiPolyadicExpression)outerExpr, (PsiExpression)operand2));
    }

    @Nullable
    private static PsiPolyadicExpression getInnerExpression(@NotNull PsiParenthesizedExpression parenthesized, @NotNull Set<IElementType> innerOperators) {
        PsiPolyadicExpression expression2;
        if (parenthesized == null) {
            EliminateUtils.$$$reportNull$$$0(3);
        }
        if (innerOperators == null) {
            EliminateUtils.$$$reportNull$$$0(4);
        }
        if ((expression2 = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)parenthesized), PsiPolyadicExpression.class)) == null) {
            return null;
        }
        if (!innerOperators.contains(expression2.getOperationTokenType()) || expression2.getOperands().length < 2) {
            return null;
        }
        return expression2;
    }

    @Nullable
    private static PsiPolyadicExpression getOuterExpression(@NotNull PsiPolyadicExpression innerExpression, @NotNull PsiExpression operand2, @NotNull Map<IElementType, IElementType[]> outerOperators) {
        PsiPolyadicExpression expression2;
        if (innerExpression == null) {
            EliminateUtils.$$$reportNull$$$0(5);
        }
        if (operand2 == null) {
            EliminateUtils.$$$reportNull$$$0(6);
        }
        if (outerOperators == null) {
            EliminateUtils.$$$reportNull$$$0(7);
        }
        if ((expression2 = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)operand2.getParent(), PsiPolyadicExpression.class)) == null) {
            return null;
        }
        IElementType innerOperator = innerExpression.getOperationTokenType();
        Object[] operators = outerOperators.get(innerOperator);
        if (operators == null) {
            return null;
        }
        IElementType outerOperator = expression2.getOperationTokenType();
        if (!ArrayUtil.contains((Object)outerOperator, (Object[])operators) || expression2.getOperands().length < 2) {
            return null;
        }
        if (EliminateUtils.isSamePrecedence(innerOperator, outerOperator) && expression2.getTokenBeforeOperand(operand2) == null) {
            return null;
        }
        return expression2;
    }

    private static boolean isSamePrecedence(@NotNull IElementType innerOperator, @NotNull IElementType outerOperator) {
        if (innerOperator == null) {
            EliminateUtils.$$$reportNull$$$0(8);
        }
        if (outerOperator == null) {
            EliminateUtils.$$$reportNull$$$0(9);
        }
        return PsiPrecedenceUtil.getPrecedenceForOperator((IElementType)outerOperator) == PsiPrecedenceUtil.getPrecedenceForOperator((IElementType)innerOperator);
    }

    @Nullable
    private static PsiExpression skipPrefixedExprUp(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            EliminateUtils.$$$reportNull$$$0(10);
        }
        while (expression2.getParent() instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2.getParent();
            if (!ArrayUtil.contains((Object)prefixExpression.getOperationTokenType(), (Object[])PREFIXES)) {
                return null;
            }
            expression2 = prefixExpression;
        }
        return expression2;
    }

    static <T> T processPrefixed(@NotNull PsiExpression expression2, boolean isNegated, @NotNull BiFunction<? super PsiExpression, ? super Boolean, T> handler) {
        PsiPrefixExpression prefixExpr;
        IElementType tokenType;
        if (expression2 == null) {
            EliminateUtils.$$$reportNull$$$0(11);
        }
        if (handler == null) {
            EliminateUtils.$$$reportNull$$$0(12);
        }
        while (expression2 instanceof PsiPrefixExpression && ArrayUtil.contains((Object)(tokenType = (prefixExpr = (PsiPrefixExpression)expression2).getOperationTokenType()), (Object[])PREFIXES)) {
            isNegated ^= JavaTokenType.MINUS.equals(tokenType);
            expression2 = prefixExpr.getOperand();
        }
        return handler.apply((PsiExpression)expression2, isNegated);
    }

    @Nullable
    private static IElementType invert(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            EliminateUtils.$$$reportNull$$$0(13);
        }
        return INVERTED_OPS.get(tokenType);
    }

    @Contract(value="null -> null")
    static String getOperator(@Nullable IElementType type2) {
        return type2 == null ? null : OPS.get(type2);
    }

    static boolean isAdditive(@Nullable IElementType type2) {
        return JavaTokenType.PLUS.equals(type2) || JavaTokenType.MINUS.equals(type2);
    }

    static boolean isMultiplicative(IElementType type2) {
        return JavaTokenType.ASTERISK.equals(type2) || JavaTokenType.DIV.equals(type2) || JavaTokenType.PERC.equals(type2) || JavaTokenType.ANDAND.equals(type2) || JavaTokenType.AND.equals(type2);
    }

    private static boolean isInversion(IElementType type2) {
        return JavaTokenType.MINUS.equals(type2) || JavaTokenType.DIV.equals(type2);
    }

    private static boolean isPolyadicNegated(@NotNull PsiPolyadicExpression expression2, boolean isNegated, PsiExpression ... toEliminate) {
        if (expression2 == null) {
            EliminateUtils.$$$reportNull$$$0(14);
        }
        if (!EliminateUtils.isMultiplicative(expression2.getOperationTokenType())) {
            return false;
        }
        return (Boolean)StreamEx.of((Object[])expression2.getOperands()).foldLeft((Object)isNegated, (result, op) -> EliminateUtils.isNegated(op, result, toEliminate));
    }

    static boolean isNegated(@NotNull PsiExpression operand2, boolean isNegated, PsiExpression ... toEliminate) {
        if (operand2 == null) {
            EliminateUtils.$$$reportNull$$$0(15);
        }
        if (operand2 instanceof PsiPolyadicExpression) {
            return EliminateUtils.isPolyadicNegated((PsiPolyadicExpression)operand2, isNegated, toEliminate);
        }
        return EliminateUtils.processPrefixed(operand2, isNegated, (op, isOpNegated) -> {
            if (!ArrayUtil.contains((Object)operand2, (Object[])toEliminate)) {
                return isOpNegated;
            }
            PsiPolyadicExpression innerExpr = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)op), PsiPolyadicExpression.class);
            if (innerExpr == null) {
                return isOpNegated;
            }
            return EliminateUtils.isPolyadicNegated(innerExpr, isOpNegated, toEliminate);
        });
    }

    @Nullable
    static IElementType getOperandTokenType(@NotNull PsiPolyadicExpression expression2, @NotNull PsiExpression operand2, @Nullable IElementType outerTokenType) {
        PsiJavaToken operandToken;
        if (expression2 == null) {
            EliminateUtils.$$$reportNull$$$0(16);
        }
        if (operand2 == null) {
            EliminateUtils.$$$reportNull$$$0(17);
        }
        if ((operandToken = expression2.getTokenBeforeOperand(operand2)) == null) {
            return outerTokenType;
        }
        IElementType innerTokenType = operandToken.getTokenType();
        if (outerTokenType == null) {
            return innerTokenType;
        }
        if (!EliminateUtils.isSamePrecedence(innerTokenType, outerTokenType)) {
            return innerTokenType;
        }
        if (EliminateUtils.isInversion(outerTokenType)) {
            return EliminateUtils.invert(innerTokenType);
        }
        return innerTokenType;
    }

    static boolean addPrefix(@Nullable IElementType tokenType, boolean isNegated, @NotNull StringBuilder sb) {
        if (sb == null) {
            EliminateUtils.$$$reportNull$$$0(18);
        }
        if (tokenType == null) {
            if (isNegated) {
                sb.append("-");
            }
        } else if (isNegated && EliminateUtils.isAdditive(tokenType)) {
            IElementType inverted = EliminateUtils.invert(tokenType);
            if (inverted == null) {
                return false;
            }
            sb.append(EliminateUtils.getOperator(inverted));
        } else {
            String operator2 = EliminateUtils.getOperator(tokenType);
            if (operator2 == null) {
                return false;
            }
            sb.append(isNegated ? operator2 + "-" : operator2);
        }
        return true;
    }

    static {
        OPS.put(JavaTokenType.MINUS, "-");
        OPS.put(JavaTokenType.PLUS, "+");
        OPS.put(JavaTokenType.ASTERISK, "*");
        OPS.put(JavaTokenType.DIV, "/");
        OPS.put(JavaTokenType.OR, "|");
        OPS.put(JavaTokenType.AND, "&");
        OPS.put(JavaTokenType.OROR, "||");
        OPS.put(JavaTokenType.ANDAND, "&&");
        INVERTED_OPS.put(JavaTokenType.MINUS, JavaTokenType.PLUS);
        INVERTED_OPS.put(JavaTokenType.PLUS, JavaTokenType.MINUS);
        INVERTED_OPS.put(JavaTokenType.ASTERISK, JavaTokenType.DIV);
        INVERTED_OPS.put(JavaTokenType.DIV, JavaTokenType.ASTERISK);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parenthesized";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerOperators";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerOperators";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerExpression";
                break;
            }
            case 6: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerOperator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerOperator";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ipp/expression/eliminate/EliminateUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createExpression";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getInnerExpression";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getOuterExpression";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isSamePrecedence";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "skipPrefixedExprUp";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "processPrefixed";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "invert";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isPolyadicNegated";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isNegated";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getOperandTokenType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "addPrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

