/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.expression.eliminate;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.expression.eliminate.AssociativeExpression;
import com.siyeh.ipp.expression.eliminate.DistributiveExpression;
import com.siyeh.ipp.expression.eliminate.EliminableExpression;
import com.siyeh.ipp.expression.eliminate.EliminateUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EliminateParenthesesIntention
extends BaseElementAtCaretIntentionAction {
    private boolean myStartInWriteAction = false;
    private static final Pass<PsiParenthesizedExpression> ELIMINATE_CALLBACK = new Pass<PsiParenthesizedExpression>(){

        public void pass(@NotNull PsiParenthesizedExpression expression2) {
            if (expression2 == null) {
                1.$$$reportNull$$$0(0);
            }
            WriteCommandAction.writeCommandAction((Project)expression2.getProject(), (PsiFile[])new PsiFile[]{expression2.getContainingFile()}).withName(EliminateParenthesesIntention.getName()).run(() -> EliminateParenthesesIntention.replaceExpression(expression2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ipp/expression/eliminate/EliminateParenthesesIntention$1", "pass"));
        }
    };

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = EliminateParenthesesIntention.getName();
        if (string == null) {
            EliminateParenthesesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = EliminateParenthesesIntention.getName();
        if (string == null) {
            EliminateParenthesesIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static String getName() {
        return IntentionPowerPackBundle.defaultableMessage("eliminate.parentheses.intention.name", new Object[0]);
    }

    public boolean startInWriteAction() {
        return this.myStartInWriteAction;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        List<PsiParenthesizedExpression> possibleInnerExpressions;
        if (project == null) {
            EliminateParenthesesIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            EliminateParenthesesIntention.$$$reportNull$$$0(3);
        }
        if ((possibleInnerExpressions = EliminateParenthesesIntention.getPossibleInnerExpressions(element)) == null || possibleInnerExpressions.isEmpty()) {
            return false;
        }
        this.myStartInWriteAction = possibleInnerExpressions.size() == 1;
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        List<PsiParenthesizedExpression> possibleInnerExpressions;
        if (project == null) {
            EliminateParenthesesIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            EliminateParenthesesIntention.$$$reportNull$$$0(5);
        }
        if ((possibleInnerExpressions = EliminateParenthesesIntention.getPossibleInnerExpressions(element)) == null) {
            return;
        }
        EliminateParenthesesIntention.processInnerExpression(editor, possibleInnerExpressions);
    }

    private static void processInnerExpression(@Nullable Editor editor, @NotNull List<PsiParenthesizedExpression> expressions2) {
        if (expressions2 == null) {
            EliminateParenthesesIntention.$$$reportNull$$$0(6);
        }
        if (expressions2.size() == 1) {
            EliminateParenthesesIntention.replaceExpression(expressions2.get(0));
            return;
        }
        if (expressions2.isEmpty() || editor == null) {
            return;
        }
        IntroduceTargetChooser.showChooser((Editor)editor, expressions2, ELIMINATE_CALLBACK, (Function)new PsiExpressionTrimRenderer.RenderFunction());
    }

    private static void replaceExpression(@NotNull PsiParenthesizedExpression parenthesized) {
        EliminableExpression expression2;
        if (parenthesized == null) {
            EliminateParenthesesIntention.$$$reportNull$$$0(7);
        }
        if ((expression2 = EliminateParenthesesIntention.createEliminableExpression(parenthesized)) == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        CommentTracker commentTracker = new CommentTracker();
        PsiExpression toReplace = expression2.getExpressionToReplace();
        PsiPolyadicExpression outerExpression = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)toReplace.getParent(), PsiPolyadicExpression.class);
        if (outerExpression == null || EliminateUtils.getOperator(outerExpression.getOperationTokenType()) == null) {
            if (!expression2.eliminate(null, sb)) {
                return;
            }
            PsiReplacementUtil.replaceExpression(toReplace, sb.toString(), commentTracker);
            return;
        }
        for (PsiExpression operand2 : outerExpression.getOperands()) {
            PsiJavaToken tokenBefore = outerExpression.getTokenBeforeOperand(operand2);
            if (operand2 == toReplace) {
                if (expression2.eliminate(tokenBefore, sb)) continue;
                return;
            }
            if (tokenBefore != null) {
                sb.append(tokenBefore.getText());
            }
            sb.append(operand2.getText());
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)outerExpression, sb.toString(), commentTracker);
    }

    @Nullable
    private static EliminableExpression createEliminableExpression(@NotNull PsiParenthesizedExpression parenthesized) {
        if (parenthesized == null) {
            EliminateParenthesesIntention.$$$reportNull$$$0(8);
        }
        DistributiveExpression distributive = DistributiveExpression.create(parenthesized);
        AssociativeExpression additive = AssociativeExpression.create(parenthesized);
        if (distributive == null) {
            return additive;
        }
        if (additive == null) {
            return distributive;
        }
        if (distributive.getExpression() == null) {
            return additive;
        }
        return distributive;
    }

    @Nullable
    private static List<PsiParenthesizedExpression> getPossibleInnerExpressions(@NotNull PsiElement element) {
        if (element == null) {
            EliminateParenthesesIntention.$$$reportNull$$$0(9);
        }
        if (!(element instanceof PsiJavaToken)) {
            return null;
        }
        ArrayList<PsiParenthesizedExpression> possibleExpressions = new ArrayList<PsiParenthesizedExpression>();
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiParenthesizedExpression.class)) != null) {
            PsiParenthesizedExpression parenthesized = (PsiParenthesizedExpression)element;
            if (DistributiveExpression.create(parenthesized) == null && AssociativeExpression.create(parenthesized) == null) continue;
            possibleExpressions.add(parenthesized);
        }
        return possibleExpressions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/expression/eliminate/EliminateParenthesesIntention";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parenthesized";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/expression/eliminate/EliminateParenthesesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processInnerExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEliminableExpression";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleInnerExpressions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

