/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.commutative;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.commutative.FlipCommutativeMethodCallPredicate;
import org.jetbrains.annotations.NotNull;

public class FlipCommutativeMethodCallIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        assert (methodName != null);
        if ("equals".equals(methodName) || "equalsIgnoreCase".equals(methodName)) {
            return IntentionPowerPackBundle.message("flip.commutative.method.call.intention.name", methodName);
        }
        return IntentionPowerPackBundle.message("flip.commutative.method.call.intention.name1", methodName);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        FlipCommutativeMethodCallPredicate flipCommutativeMethodCallPredicate = new FlipCommutativeMethodCallPredicate();
        if (flipCommutativeMethodCallPredicate == null) {
            FlipCommutativeMethodCallIntention.$$$reportNull$$$0(0);
        }
        return flipCommutativeMethodCallPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            FlipCommutativeMethodCallIntention.$$$reportNull$$$0(1);
        }
        PsiMethodCallExpression expression2 = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = expression2.getArgumentList();
        PsiExpression argument = argumentList.getExpressions()[0];
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(methodExpression);
        PsiExpression strippedQualifier = ParenthesesUtils.stripParentheses(qualifier);
        PsiExpression strippedArgument = ParenthesesUtils.stripParentheses(argument);
        if (strippedQualifier == null) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        tracker.grabComments((PsiElement)qualifier);
        tracker.markUnchanged(strippedQualifier);
        tracker.grabComments((PsiElement)argument);
        tracker.markUnchanged(strippedArgument);
        PsiElement newArgument = strippedQualifier.copy();
        methodExpression.setQualifierExpression(strippedArgument);
        argument.replace(newArgument);
        tracker.insertCommentsBefore((PsiElement)expression2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/commutative/FlipCommutativeMethodCallIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/commutative/FlipCommutativeMethodCallIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

