/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.ui.UiUtils;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SharedThreadLocalRandomInspection
extends BaseInspection {
    protected final MethodMatcher myMethodMatcher = new MethodMatcher(false, "ignoreArgumentToMethods").add("java.math.BigInteger", ".*").add("java.util.Collections", "shuffle").finishDefault();

    public JComponent createOptionsPanel() {
        ListTable table = new ListTable(new ListWrappingTableModel(Arrays.asList(this.myMethodMatcher.getClassNames(), this.myMethodMatcher.getMethodNamePatterns()), new String[]{InspectionGadgetsBundle.message("result.of.method.call.ignored.class.column.title", new Object[0]), InspectionGadgetsBundle.message("result.of.method.call.ignored.method.column.title", new Object[0])}));
        return UiUtils.createAddRemoveTreeClassChooserPanel(table, "Choose class", new String[0]);
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("shared.thread.local.random.display.name", new Object[0]);
        if (string == null) {
            SharedThreadLocalRandomInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("shared.thread.local.random.problem.descriptor", new Object[0]);
        if (string == null) {
            SharedThreadLocalRandomInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            SharedThreadLocalRandomInspection.$$$reportNull$$$0(2);
        }
        super.readSettings(element);
        this.myMethodMatcher.readSettings(element);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            SharedThreadLocalRandomInspection.$$$reportNull$$$0(3);
        }
        super.writeSettings(element);
        this.myMethodMatcher.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SharedThreadLocalRandomVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/threading/SharedThreadLocalRandomInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/threading/SharedThreadLocalRandomInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SharedThreadLocalRandomVisitor
    extends BaseInspectionVisitor {
        private SharedThreadLocalRandomVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name2 = methodExpression.getReferenceName();
            if (!"current".equals(name2)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.concurrent.ThreadLocalRandom")) {
                return;
            }
            if (this.isArgumentToMethodCall((PsiExpression)expression2)) {
                this.registerMethodCallError(expression2, new Object[0]);
            } else {
                PsiVariable variable = this.assignedToVariable(expression2);
                if (variable instanceof PsiField) {
                    this.registerMethodCallError(expression2, new Object[0]);
                } else if (variable instanceof PsiLocalVariable) {
                    PsiCodeBlock context = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
                    boolean passed = VariableAccessUtils.variableIsPassedAsMethodArgument(variable, (PsiElement)context, (Processor<? super PsiCall>)((Processor)SharedThreadLocalRandomInspection.this.myMethodMatcher::matches));
                    if (passed || VariableAccessUtils.variableIsUsedInInnerClass(variable, (PsiElement)context)) {
                        this.registerMethodCallError(expression2, new Object[0]);
                    }
                }
            }
        }

        private boolean isArgumentToMethodCall(PsiExpression expression2) {
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            return !SharedThreadLocalRandomInspection.this.myMethodMatcher.matches((PsiCall)methodCallExpression);
        }

        private PsiVariable assignedToVariable(PsiMethodCallExpression expression2) {
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expression2, (Class[])new Class[]{PsiParenthesizedExpression.class});
            if (parent instanceof PsiVariable) {
                return (PsiVariable)parent;
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return null;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (!PsiTreeUtil.isAncestor((PsiElement)rhs, (PsiElement)expression2, (boolean)false)) {
                return null;
            }
            PsiExpression lhs = ParenthesesUtils.stripParentheses(assignmentExpression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return null;
            }
            return (PsiVariable)target;
        }
    }
}

