/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnqualifiedInnerClassAccessInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreReferencesToLocalInnerClasses = true;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unqualified.inner.class.access.option", new Object[0]), (InspectionProfileEntry)this, "ignoreReferencesToLocalInnerClasses");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnqualifiedInnerClassAccessFix();
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unqualified.inner.class.access.display.name", new Object[0]);
        if (string == null) {
            UnqualifiedInnerClassAccessInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unqualified.inner.class.access.problem.descriptor", new Object[0]);
        if (string == null) {
            UnqualifiedInnerClassAccessInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnqualifiedInnerClassAccessVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnqualifiedInnerClassAccessInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnqualifiedInnerClassAccessVisitor
    extends BaseInspectionVisitor {
        private UnqualifiedInnerClassAccessVisitor() {
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            if (reference.isQualified()) {
                return;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            if (!aClass.hasModifierProperty("static") && reference.getParent() instanceof PsiNewExpression) {
                return;
            }
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass == null || containingClass instanceof PsiAnonymousClass) {
                return;
            }
            if (UnqualifiedInnerClassAccessInspection.this.ignoreReferencesToLocalInnerClasses) {
                if (PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)reference, (boolean)true)) {
                    return;
                }
                PsiClass referenceClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiClass.class);
                if (referenceClass != null && referenceClass.isInheritor(containingClass, true)) {
                    return;
                }
            }
            this.registerError((PsiElement)reference, containingClass.getName());
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
        }
    }

    private static class ReferenceCollector
    extends JavaRecursiveElementWalkingVisitor {
        private final String name;
        private final boolean onDemand;
        private final Set<PsiJavaCodeReferenceElement> references = new HashSet<PsiJavaCodeReferenceElement>();

        ReferenceCollector(String name2, boolean onDemand) {
            this.name = name2;
            this.onDemand = onDemand;
        }

        public void visitImportList(PsiImportList list) {
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            if (reference.isQualified()) {
                return;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            if (!this.onDemand) {
                String qualifiedName = aClass.getQualifiedName();
                if (this.name.equals(qualifiedName)) {
                    this.references.add(reference);
                }
                return;
            }
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (this.name.equals(qualifiedName)) {
                this.references.add(reference);
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
        }

        public Collection<PsiJavaCodeReferenceElement> getReferences() {
            return this.references;
        }
    }

    private static class UnqualifiedInnerClassAccessFix
    extends InspectionGadgetsFix {
        private UnqualifiedInnerClassAccessFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unqualified.inner.class.access.quickfix", new Object[0]);
            if (string == null) {
                UnqualifiedInnerClassAccessFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiJavaCodeReferenceElement)) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
            PsiElement target = referenceElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass innerClass = (PsiClass)target;
            PsiClass containingClass = innerClass.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (qualifiedName == null) {
                return;
            }
            PsiFile containingFile = referenceElement.getContainingFile();
            if (!(containingFile instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile javaFile = (PsiJavaFile)containingFile;
            String innerClassName = innerClass.getQualifiedName();
            if (innerClassName == null) {
                return;
            }
            PsiImportList importList = javaFile.getImportList();
            if (importList == null) {
                return;
            }
            PsiImportStatement[] importStatements = importList.getImportStatements();
            int importStatementsLength = importStatements.length;
            boolean onDemand = false;
            PsiImportStatement referenceImportStatement = null;
            for (int i = importStatementsLength - 1; i >= 0; --i) {
                PsiImportStatement importStatement = importStatements[i];
                String importString = importStatement.getQualifiedName();
                if (importStatement.isOnDemand()) {
                    if (!qualifiedName.equals(importString)) continue;
                    referenceImportStatement = importStatement;
                    onDemand = true;
                    break;
                }
                if (!innerClassName.equals(importString)) continue;
                referenceImportStatement = importStatement;
                break;
            }
            ReferenceCollector referenceCollector = new ReferenceCollector(onDemand ? qualifiedName : innerClassName, onDemand);
            javaFile.accept((PsiElementVisitor)referenceCollector);
            Collection<PsiJavaCodeReferenceElement> references = referenceCollector.getReferences();
            SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
            ArrayList<SmartPsiElementPointer> pointers = new ArrayList<SmartPsiElementPointer>();
            for (PsiJavaCodeReferenceElement reference : references) {
                SmartPsiElementPointer pointer = pointerManager.createSmartPsiElementPointer((PsiElement)reference);
                pointers.add(pointer);
            }
            if (referenceImportStatement != null) {
                referenceImportStatement.delete();
            }
            PsiClass outerClass = ClassUtils.getOutermostContainingClass(containingClass);
            ImportUtils.addImportIfNeeded(outerClass, (PsiElement)referenceElement);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = documentManager.getDocument(containingFile);
            if (document == null) {
                return;
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            String text2 = UnqualifiedInnerClassAccessFix.buildNewText((PsiElement)javaFile, references, containingClass, new StringBuilder()).toString();
            document.replaceString(0, document.getTextLength(), (CharSequence)text2);
            documentManager.commitDocument(document);
            if (pointers.size() > 1) {
                ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                for (SmartPsiElementPointer pointer : pointers) {
                    PsiElement psiElement = pointer.getElement();
                    if (psiElement == null) continue;
                    elements.add(psiElement);
                }
                if (this.isOnTheFly()) {
                    HighlightUtils.highlightElements(elements);
                }
            }
        }

        private static StringBuilder buildNewText(PsiElement element, Collection<PsiJavaCodeReferenceElement> references, PsiClass aClass, StringBuilder out) {
            if (element == null) {
                return out;
            }
            if (references.contains(element)) {
                String shortClassName = UnqualifiedInnerClassAccessFix.getShortClassName(aClass, new StringBuilder()).toString();
                if (UnqualifiedInnerClassAccessFix.isReferenceToTargetClass(shortClassName, aClass, element)) {
                    out.append(shortClassName);
                } else {
                    out.append(aClass.getQualifiedName());
                }
                out.append('.');
                return out.append(element.getText());
            }
            PsiElement[] children = element.getChildren();
            if (children.length == 0) {
                return out.append(element.getText());
            }
            for (PsiElement child : children) {
                UnqualifiedInnerClassAccessFix.buildNewText(child, references, aClass, out);
            }
            return out;
        }

        private static StringBuilder getShortClassName(@NotNull PsiClass aClass, @NotNull StringBuilder builder) {
            PsiClass containingClass;
            if (aClass == null) {
                UnqualifiedInnerClassAccessFix.$$$reportNull$$$0(1);
            }
            if (builder == null) {
                UnqualifiedInnerClassAccessFix.$$$reportNull$$$0(2);
            }
            if ((containingClass = aClass.getContainingClass()) != null) {
                UnqualifiedInnerClassAccessFix.getShortClassName(containingClass, builder);
                builder.append('.');
            }
            builder.append(aClass.getName());
            return builder;
        }

        private static boolean isReferenceToTargetClass(String referenceText, PsiClass targetClass, PsiElement context) {
            PsiManager manager = targetClass.getManager();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiResolveHelper resolveHelper = facade.getResolveHelper();
            PsiClass referencedClass = resolveHelper.resolveReferencedClass(referenceText, context);
            if (referencedClass == null) {
                return true;
            }
            return manager.areElementsEquivalent((PsiElement)targetClass, (PsiElement)referencedClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnqualifiedInnerClassAccessInspection$UnqualifiedInnerClassAccessFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnqualifiedInnerClassAccessInspection$UnqualifiedInnerClassAccessFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getShortClassName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

