/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayCanBeReplacedWithEnumValuesInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("array.can.be.replaced.with.enum.values", new Object[0]);
        if (string == null) {
            ArrayCanBeReplacedWithEnumValuesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = this.getDisplayName();
        if (string == null) {
            ArrayCanBeReplacedWithEnumValuesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayCreationExpressionVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length == 1 && infos[0] instanceof String) {
            return new ArrayToEnumValueFix((String)infos[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/ArrayCanBeReplacedWithEnumValuesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ArrayCreationExpressionVisitor
    extends BaseInspectionVisitor {
        private ArrayCreationExpressionVisitor() {
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
            super.visitArrayInitializerExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return;
            }
            PsiType initExprType = ((PsiArrayType)type2).getComponentType();
            PsiClass initClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)initExprType);
            if (initClass == null || !initClass.isEnum()) {
                return;
            }
            List enumValues = ContainerUtil.filterIsInstance(Arrays.asList(initClass.getFields()), PsiEnumConstant.class);
            PsiExpression[] initializers = expression2.getInitializers();
            if (enumValues.size() != initializers.length) {
                return;
            }
            for (int i = 0; i < initializers.length; ++i) {
                if (ExpressionUtils.isReferenceTo(initializers[i], (PsiVariable)enumValues.get(i))) continue;
                return;
            }
            PsiElement parent = expression2.getParent();
            String enumName = initClass.getQualifiedName();
            if (parent instanceof PsiNewExpression) {
                this.registerError(parent, enumName);
            } else {
                this.registerError((PsiElement)expression2, enumName);
            }
        }
    }

    private static class ArrayToEnumValueFix
    extends InspectionGadgetsFix {
        private final String myEnumName;

        private ArrayToEnumValueFix(String enumName) {
            this.myEnumName = enumName;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("array.can.be.replaced.with.enum.values.quickfix", StringUtil.getShortName((String)this.myEnumName));
            if (string == null) {
                ArrayToEnumValueFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("array.can.be.replaced.with.enum.values.family.quickfix", new Object[0]);
            if (string == null) {
                ArrayToEnumValueFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            if (this.myEnumName == null) {
                return;
            }
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiNewExpression || element instanceof PsiArrayInitializerExpression) {
                PsiReplacementUtil.replaceExpression((PsiExpression)element, this.myEnumName + ".values()");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/ArrayCanBeReplacedWithEnumValuesInspection$ArrayToEnumValueFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

