/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class StatementExtractor {
    private static final Node EMPTY = new Node(null){

        @Override
        public Node prepend(Node node) {
            return node;
        }

        @Override
        public String toString() {
            return "";
        }
    };

    @NotNull
    public static PsiStatement[] generateStatements(List<? extends PsiExpression> expressionsToKeep, PsiExpression root) {
        String statementsCode = StatementExtractor.generateStatementsText(expressionsToKeep, root);
        if (statementsCode.isEmpty()) {
            if (PsiStatement.EMPTY_ARRAY == null) {
                StatementExtractor.$$$reportNull$$$0(0);
            }
            return PsiStatement.EMPTY_ARRAY;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)root.getProject());
        PsiCodeBlock codeBlock = factory.createCodeBlockFromText("{" + statementsCode + "}", (PsiElement)root);
        PsiStatement[] psiStatementArray = codeBlock.getStatements();
        if (psiStatementArray == null) {
            StatementExtractor.$$$reportNull$$$0(1);
        }
        return psiStatementArray;
    }

    public static String generateStatementsText(List<? extends PsiExpression> expressionsToKeep, PsiExpression root) {
        Node result = (Node)StreamEx.ofReversed(expressionsToKeep).map(expression2 -> StatementExtractor.createNode(expression2, root)).foldLeft((Object)EMPTY, Node::prepend);
        return result.toString();
    }

    @NotNull
    private static Node createNode(@NotNull PsiExpression expression2, @NotNull PsiExpression root) {
        if (expression2 == null) {
            StatementExtractor.$$$reportNull$$$0(2);
        }
        if (root == null) {
            StatementExtractor.$$$reportNull$$$0(3);
        }
        Node result = new Expr(expression2);
        while (expression2 != root) {
            PsiSwitchExpression switchExpression;
            PsiElement parentElement = expression2.getParent();
            if (parentElement instanceof PsiExpressionList) {
                parentElement = parentElement.getParent();
            }
            if (parentElement instanceof PsiStatement && (switchExpression = (PsiSwitchExpression)PsiTreeUtil.getParentOfType((PsiElement)parentElement, PsiSwitchExpression.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class})) != null && PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)switchExpression, (boolean)false)) {
                boolean isYield = parentElement instanceof PsiBreakStatement && ((PsiBreakStatement)parentElement).findExitedElement() == switchExpression || parentElement instanceof PsiYieldStatement && ((PsiYieldStatement)parentElement).findEnclosingExpression() == switchExpression;
                boolean isRuleExpression = parentElement instanceof PsiExpressionStatement && parentElement.getParent() instanceof PsiSwitchLabeledRuleStatement && ((PsiSwitchLabeledRuleStatement)parentElement.getParent()).getEnclosingSwitchBlock() == switchExpression;
                result = isYield || isRuleExpression ? new Switch(switchExpression, Collections.singletonMap((PsiStatement)parentElement, result)) : new Switch(switchExpression, Collections.emptyMap());
                expression2 = switchExpression;
                continue;
            }
            PsiExpression parent = (PsiExpression)ObjectUtils.tryCast((Object)parentElement, PsiExpression.class);
            if (parent == null) {
                String message2 = PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)expression2, (boolean)false) ? "Expected to have expression parent" : "Supplied root is not the expression ancestor";
                throw new RuntimeExceptionWithAttachments(message2, new Attachment[]{new Attachment("expression.txt", expression2.getText()), new Attachment("root.txt", root.getText())});
            }
            result = StatementExtractor.foldNode(result, expression2, parent);
            expression2 = parent;
        }
        Expr expr = result;
        if (expr == null) {
            StatementExtractor.$$$reportNull$$$0(4);
        }
        return expr;
    }

    @NotNull
    private static Node foldNode(@NotNull Node node, @NotNull PsiExpression expression2, @NotNull PsiExpression parent) {
        if (node == null) {
            StatementExtractor.$$$reportNull$$$0(5);
        }
        if (expression2 == null) {
            StatementExtractor.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            StatementExtractor.$$$reportNull$$$0(7);
        }
        if (parent instanceof PsiPolyadicExpression) {
            boolean and;
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)parent;
            IElementType type2 = polyadic.getOperationTokenType();
            if (type2 == JavaTokenType.ANDAND) {
                and = true;
            } else if (type2 == JavaTokenType.OROR) {
                and = false;
            } else {
                Node node2 = node;
                if (node2 == null) {
                    StatementExtractor.$$$reportNull$$$0(8);
                }
                return node2;
            }
            Object[] operands2 = polyadic.getOperands();
            int index = ArrayUtil.indexOf((Object[])operands2, (Object)expression2);
            if (index == 0) {
                Node node3 = node;
                if (node3 == null) {
                    StatementExtractor.$$$reportNull$$$0(9);
                }
                return node3;
            }
            Cond cond = new Cond(parent, parent, index, and ? node : EMPTY, and ? EMPTY : node);
            if (cond == null) {
                StatementExtractor.$$$reportNull$$$0(10);
            }
            return cond;
        }
        if (parent instanceof PsiConditionalExpression) {
            PsiConditionalExpression ternary = (PsiConditionalExpression)parent;
            if (expression2 == ternary.getThenExpression()) {
                Cond cond = new Cond((PsiExpression)ternary, ternary.getCondition(), -1, node, EMPTY);
                if (cond == null) {
                    StatementExtractor.$$$reportNull$$$0(11);
                }
                return cond;
            }
            if (expression2 == ternary.getElseExpression()) {
                Cond cond = new Cond((PsiExpression)ternary, ternary.getCondition(), -1, EMPTY, node);
                if (cond == null) {
                    StatementExtractor.$$$reportNull$$$0(12);
                }
                return cond;
            }
        }
        Node node4 = node;
        if (node4 == null) {
            StatementExtractor.$$$reportNull$$$0(13);
        }
        return node4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/StatementExtractor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "generateStatements";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/StatementExtractor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNode";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "foldNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "foldNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Cons
    extends Node {
        @NotNull
        private final Node myHead;
        @NotNull
        private final Node myTail;

        private Cons(@NotNull Node head, @NotNull Node tail) {
            if (head == null) {
                Cons.$$$reportNull$$$0(0);
            }
            if (tail == null) {
                Cons.$$$reportNull$$$0(1);
            }
            super(head.myAnchor);
            assert (!(head instanceof Cons));
            this.myHead = head;
            this.myTail = tail;
        }

        @Override
        public Node prepend(Node node) {
            if (node.myAnchor == null) {
                return this;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.myHead.myAnchor, (PsiElement)node.myAnchor, (boolean)false)) {
                Node newHead = this.myHead.prepend(node);
                return new Cons(newHead, this.myTail);
            }
            return new Cons(node, this);
        }

        @Override
        public String toString() {
            return this.myHead.toString() + this.myTail;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "head";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tail";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/psiutils/StatementExtractor$Cons";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Switch
    extends Node {
        private static final Key<Node> NODE_KEY = Key.create((String)"SwitchNode");
        @NotNull
        private final Map<PsiStatement, Node> myReturns;

        private Switch(@NotNull PsiSwitchExpression expression2, @NotNull Map<PsiStatement, Node> sideEffectReturns) {
            if (expression2 == null) {
                Switch.$$$reportNull$$$0(0);
            }
            if (sideEffectReturns == null) {
                Switch.$$$reportNull$$$0(1);
            }
            super((PsiExpression)expression2);
            this.myReturns = sideEffectReturns;
        }

        @Override
        public Node prepend(Node node) {
            if (node.myAnchor == null) {
                return this;
            }
            if (node instanceof Switch && node.myAnchor == this.myAnchor) {
                if (this.myReturns.isEmpty()) {
                    return node;
                }
                if (((Switch)node).myReturns.isEmpty()) {
                    return this;
                }
                HashMap<PsiStatement, Node> newMap = new HashMap<PsiStatement, Node>(this.myReturns);
                ((Switch)node).myReturns.forEach((statement, n) -> newMap.merge((PsiStatement)statement, (Node)n, Node::prepend));
                return new Switch((PsiSwitchExpression)this.myAnchor, newMap);
            }
            return new Cons(node, this);
        }

        @Override
        public String toString() {
            this.myReturns.forEach((statement, node) -> statement.putCopyableUserData(NODE_KEY, node));
            final PsiSwitchExpression copy = (PsiSwitchExpression)this.myAnchor.copy();
            final HashMap<PsiStatement, PsiStatement[]> replacementMap = new HashMap<PsiStatement, PsiStatement[]>();
            final PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myAnchor.getProject());
            PsiCodeBlock body2 = Objects.requireNonNull(copy.getBody());
            body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitExpressionStatement(PsiExpressionStatement statement) {
                    if (statement.getParent() instanceof PsiSwitchLabeledRuleStatement && ((PsiSwitchLabeledRuleStatement)statement.getParent()).getEnclosingSwitchBlock() == copy) {
                        this.process((PsiStatement)statement);
                    }
                }

                public void visitBreakStatement(PsiBreakStatement statement) {
                    if (statement.getValueExpression() != null && statement.findExitedElement() == copy) {
                        this.process((PsiStatement)statement);
                    }
                }

                public void visitYieldStatement(PsiYieldStatement statement) {
                    if (statement.getExpression() != null && statement.findEnclosingExpression() == copy) {
                        this.process((PsiStatement)statement);
                    }
                }

                public void visitExpression(PsiExpression expression2) {
                }

                private void process(PsiStatement statement) {
                    Node data = (Node)statement.getCopyableUserData(NODE_KEY);
                    if (data == null) {
                        replacementMap.put(statement, PsiStatement.EMPTY_ARRAY);
                    } else {
                        replacementMap.put(statement, factory.createCodeBlockFromText("{" + data + "}", (PsiElement)statement).getStatements());
                    }
                }
            });
            replacementMap.forEach((statement, replacements) -> {
                boolean keep;
                boolean bl = keep = (statement instanceof PsiBreakStatement || statement instanceof PsiYieldStatement) && this.shouldKeepBreak((PsiStatement)statement);
                if (!keep && ((PsiStatement[])replacements).length == 1) {
                    statement.replace((PsiElement)replacements[0]);
                } else {
                    if (!keep || ((PsiStatement[])replacements).length > 0) {
                        if (!(statement.getParent() instanceof PsiCodeBlock)) {
                            statement = BlockUtils.expandSingleStatementToBlockStatement(statement);
                        }
                        PsiElement parent = statement.getParent();
                        for (PsiStatement replacement : replacements) {
                            parent.addBefore((PsiElement)replacement, (PsiElement)statement);
                        }
                    }
                    if (!keep) {
                        statement.delete();
                    } else if (statement instanceof PsiYieldStatement) {
                        statement.replace((PsiElement)factory.createStatementFromText("break;", null));
                    } else {
                        Objects.requireNonNull(((PsiBreakStatement)statement).getValueExpression()).delete();
                    }
                }
            });
            return copy.getText();
        }

        public boolean shouldKeepBreak(PsiStatement statement) {
            if (PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement) instanceof PsiStatement) {
                return true;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiCodeBlock) {
                PsiElement gParent = parent.getParent();
                if (gParent instanceof PsiBlockStatement) {
                    return this.shouldKeepBreak((PsiStatement)gParent);
                }
            } else {
                if (parent instanceof PsiLabeledStatement || parent instanceof PsiIfStatement) {
                    return this.shouldKeepBreak((PsiStatement)parent);
                }
                if (parent instanceof PsiSwitchLabeledRuleStatement) {
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sideEffectReturns";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/psiutils/StatementExtractor$Switch";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Expr
    extends Node {
        private Expr(@NotNull PsiExpression expression2) {
            if (expression2 == null) {
                Expr.$$$reportNull$$$0(0);
            }
            super(expression2);
        }

        @Override
        public Node prepend(Node node) {
            return node.myAnchor == null ? this : new Cons(node, this);
        }

        @Override
        public String toString() {
            return this.myAnchor.getText() + ";";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/StatementExtractor$Expr", "<init>"));
        }
    }

    private static class Cond
    extends Node {
        @NotNull
        private final PsiExpression myCondition;
        @NotNull
        private final Node myThenBranch;
        @NotNull
        private final Node myElseBranch;
        private final int myLimit;

        private Cond(@NotNull PsiExpression anchor, @NotNull PsiExpression condition2, int limit, @NotNull Node thenBranch, @NotNull Node elseBranch) {
            if (anchor == null) {
                Cond.$$$reportNull$$$0(0);
            }
            if (condition2 == null) {
                Cond.$$$reportNull$$$0(1);
            }
            if (thenBranch == null) {
                Cond.$$$reportNull$$$0(2);
            }
            if (elseBranch == null) {
                Cond.$$$reportNull$$$0(3);
            }
            super(anchor);
            this.myCondition = condition2;
            this.myLimit = limit;
            assert (limit < 0 || condition2 instanceof PsiPolyadicExpression);
            this.myThenBranch = thenBranch;
            this.myElseBranch = elseBranch;
        }

        private String getCondition(boolean invert) {
            if (this.myLimit < 0) {
                return invert ? BoolUtils.getNegatedExpressionText(this.myCondition) : this.myCondition.getText();
            }
            PsiPolyadicExpression condition2 = (PsiPolyadicExpression)this.myCondition;
            Object[] operands2 = condition2.getOperands();
            String joiner = condition2.getOperationTokenType() == JavaTokenType.ANDAND != invert ? "&&" : "||";
            return StreamEx.of((Object[])operands2, (int)0, (int)this.myLimit).map(invert ? BoolUtils::getNegatedExpressionText : PsiElement::getText).joining((CharSequence)joiner);
        }

        @Override
        public String toString() {
            if (this.myThenBranch == EMPTY) {
                return "if(" + this.getCondition(true) + ") {" + this.myElseBranch + "}";
            }
            return "if(" + this.getCondition(false) + ") {" + this.myThenBranch + "}" + (this.myElseBranch == EMPTY ? "" : "else {" + this.myElseBranch + "}");
        }

        @Override
        public Node prepend(Node node) {
            PsiExpression thatAnchor = node.myAnchor;
            if (thatAnchor == null) {
                return this;
            }
            if (thatAnchor == this.myAnchor) {
                assert (node instanceof Cond);
                Cond cond = (Cond)node;
                assert (this.myCondition == cond.myCondition);
                if (this.myLimit == cond.myLimit) {
                    return new Cond(this.myAnchor, this.myCondition, this.myLimit, this.myThenBranch.prepend(cond.myThenBranch), this.myElseBranch.prepend(cond.myElseBranch));
                }
                assert (this.myLimit > cond.myLimit);
                return this;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.myCondition, (PsiElement)thatAnchor, (boolean)false)) {
                return this;
            }
            return new Cons(node, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anchor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "condition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thenBranch";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "elseBranch";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/psiutils/StatementExtractor$Cond";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class Node {
        final PsiExpression myAnchor;

        protected Node(PsiExpression anchor) {
            this.myAnchor = anchor;
        }

        public abstract Node prepend(Node var1);

        public abstract String toString();
    }
}

