/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SideEffectChecker {
    private static final Set<String> ourSideEffectFreeClasses = new THashSet(Arrays.asList(Object.class.getName(), Short.class.getName(), Character.class.getName(), Byte.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), String.class.getName(), StringBuffer.class.getName(), Boolean.class.getName(), ArrayList.class.getName(), Date.class.getName(), HashMap.class.getName(), HashSet.class.getName(), Hashtable.class.getName(), LinkedHashMap.class.getName(), LinkedHashSet.class.getName(), LinkedList.class.getName(), Stack.class.getName(), TreeMap.class.getName(), TreeSet.class.getName(), Vector.class.getName(), WeakHashMap.class.getName()));

    private SideEffectChecker() {
    }

    public static boolean mayHaveSideEffects(@NotNull PsiExpression exp) {
        if (exp == null) {
            SideEffectChecker.$$$reportNull$$$0(0);
        }
        SideEffectsVisitor visitor = new SideEffectsVisitor(null, (PsiElement)exp);
        exp.accept((PsiElementVisitor)visitor);
        return visitor.mayHaveSideEffects();
    }

    public static boolean mayHaveSideEffects(@NotNull PsiElement element, Predicate<? super PsiElement> shouldIgnoreElement) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(1);
        }
        SideEffectsVisitor visitor = new SideEffectsVisitor(null, element, shouldIgnoreElement);
        element.accept((PsiElementVisitor)visitor);
        return visitor.mayHaveSideEffects();
    }

    public static boolean mayHaveNonLocalSideEffects(@NotNull PsiElement element) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(2);
        }
        return SideEffectChecker.mayHaveSideEffects(element, SideEffectChecker::isLocalSideEffect);
    }

    private static boolean isLocalSideEffect(PsiElement e) {
        PsiElement target;
        if (e instanceof PsiContinueStatement || e instanceof PsiReturnStatement || e instanceof PsiThrowStatement) {
            return true;
        }
        if (e instanceof PsiLocalVariable) {
            return true;
        }
        PsiReferenceExpression ref = null;
        if (e instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)e;
            ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression()), PsiReferenceExpression.class);
        }
        if (e instanceof PsiUnaryExpression) {
            PsiExpression operand2 = ((PsiUnaryExpression)e).getOperand();
            ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2), PsiReferenceExpression.class);
        }
        return ref != null && ((target = ref.resolve()) instanceof PsiLocalVariable || target instanceof PsiParameter);
    }

    public static boolean checkSideEffects(@NotNull PsiExpression element, @Nullable List<? super PsiElement> sideEffects) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(3);
        }
        return SideEffectChecker.checkSideEffects(element, sideEffects, e -> false);
    }

    public static boolean checkSideEffects(@NotNull PsiExpression element, @Nullable List<? super PsiElement> sideEffects, @NotNull Predicate<? super PsiElement> ignoreElement) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(4);
        }
        if (ignoreElement == null) {
            SideEffectChecker.$$$reportNull$$$0(5);
        }
        SideEffectsVisitor visitor = new SideEffectsVisitor(sideEffects, (PsiElement)element, ignoreElement);
        element.accept((PsiElementVisitor)visitor);
        return visitor.mayHaveSideEffects();
    }

    public static List<PsiExpression> extractSideEffectExpressions(@NotNull PsiExpression element) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(6);
        }
        SmartList list = new SmartList();
        element.accept((PsiElementVisitor)new SideEffectsVisitor((List<? super PsiElement>)list, (PsiElement)element));
        return StreamEx.of((Collection)list).select(PsiExpression.class).toList();
    }

    public static boolean mayHaveExceptionalSideEffect(PsiMethod method) {
        String name2 = method.getName();
        if (name2.startsWith("assert") || name2.startsWith("check") || name2.startsWith("require")) {
            return true;
        }
        PsiClass aClass = method.getContainingClass();
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"org.assertj.core.api.Descriptable")) {
            return true;
        }
        return JavaMethodContractUtil.getMethodCallContracts(method, null).stream().filter(mc -> mc.getConditions().stream().noneMatch(ContractValue::isBoundCheckingCondition)).anyMatch(mc -> mc.getReturnValue().isFail());
    }

    private static boolean isSideEffectFreeConstructor(@NotNull PsiNewExpression newExpression) {
        PsiClass throwableClass;
        String packageName;
        String qualifiedName;
        PsiClass baseClass;
        PsiAnonymousClass anonymousClass;
        if (newExpression == null) {
            SideEffectChecker.$$$reportNull$$$0(7);
        }
        if ((anonymousClass = newExpression.getAnonymousClass()) != null && anonymousClass.getInitializers().length == 0 && (baseClass = anonymousClass.getBaseClassType().resolve()) != null && baseClass.isInterface()) {
            return true;
        }
        PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
        PsiClass aClass = classReference2 == null ? null : (PsiClass)classReference2.resolve();
        String string = qualifiedName = aClass == null ? null : aClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        if (ourSideEffectFreeClasses.contains(qualifiedName)) {
            return true;
        }
        PsiFile file = aClass.getContainingFile();
        PsiDirectory directory = file.getContainingDirectory();
        PsiPackage classPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
        String string2 = packageName = classPackage == null ? null : classPackage.getQualifiedName();
        return ("java.lang".equals(packageName) || "java.io".equals(packageName)) && (throwableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.lang.Throwable", aClass.getResolveScope())) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)throwableClass, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/SideEffectChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mayHaveSideEffects";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mayHaveNonLocalSideEffects";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSideEffects";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "extractSideEffectExpressions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isSideEffectFreeConstructor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SideEffectsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @Nullable
        private final List<? super PsiElement> mySideEffects;
        @NotNull
        private final PsiElement myStartElement;
        @NotNull
        private final Predicate<? super PsiElement> myIgnorePredicate;
        boolean found;

        SideEffectsVisitor(@Nullable List<? super PsiElement> sideEffects, @NotNull PsiElement startElement) {
            if (startElement == null) {
                SideEffectsVisitor.$$$reportNull$$$0(0);
            }
            this(sideEffects, startElement, call -> false);
        }

        SideEffectsVisitor(@Nullable List<? super PsiElement> sideEffects, @NotNull PsiElement startElement, @NotNull Predicate<? super PsiElement> predicate) {
            if (startElement == null) {
                SideEffectsVisitor.$$$reportNull$$$0(1);
            }
            if (predicate == null) {
                SideEffectsVisitor.$$$reportNull$$$0(2);
            }
            this.myStartElement = startElement;
            this.myIgnorePredicate = predicate;
            this.mySideEffects = sideEffects;
        }

        private boolean addSideEffect(PsiElement element) {
            if (this.myIgnorePredicate.test((PsiElement)element)) {
                return false;
            }
            this.found = true;
            if (this.mySideEffects != null) {
                this.mySideEffects.add((PsiElement)element);
            } else {
                this.stopWalking();
            }
            return true;
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (expression2 == null) {
                SideEffectsVisitor.$$$reportNull$$$0(3);
            }
            if (this.addSideEffect((PsiElement)expression2)) {
                return;
            }
            super.visitAssignmentExpression(expression2);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiMethod method;
            if (expression2 == null) {
                SideEffectsVisitor.$$$reportNull$$$0(4);
            }
            if (!this.isPure(method = expression2.resolveMethod()) && this.addSideEffect((PsiElement)expression2)) {
                return;
            }
            super.visitMethodCallExpression(expression2);
        }

        protected boolean isPure(PsiMethod method) {
            if (method == null) {
                return false;
            }
            PsiField field = PropertyUtil.getFieldOfGetter(method);
            if (field != null) {
                return !field.hasModifierProperty("volatile");
            }
            return JavaMethodContractUtil.isPure(method) && !SideEffectChecker.mayHaveExceptionalSideEffect(method);
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            if (expression2 == null) {
                SideEffectsVisitor.$$$reportNull$$$0(5);
            }
            if (!expression2.isArrayCreation() && !SideEffectChecker.isSideEffectFreeConstructor(expression2) && this.addSideEffect((PsiElement)expression2)) {
                return;
            }
            super.visitNewExpression(expression2);
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression2) {
            IElementType tokenType;
            if (expression2 == null) {
                SideEffectsVisitor.$$$reportNull$$$0(6);
            }
            if (((tokenType = expression2.getOperationTokenType()).equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) && this.addSideEffect((PsiElement)expression2)) {
                return;
            }
            super.visitUnaryExpression(expression2);
        }

        public void visitVariable(PsiVariable variable) {
            if (this.addSideEffect((PsiElement)variable)) {
                return;
            }
            super.visitVariable(variable);
        }

        public void visitBreakStatement(PsiBreakStatement statement) {
            PsiElement exitedStatement = statement.findExitedElement();
            if ((exitedStatement == null || !PsiTreeUtil.isAncestor((PsiElement)this.myStartElement, (PsiElement)exitedStatement, (boolean)false)) && this.addSideEffect((PsiElement)statement)) {
                return;
            }
            super.visitBreakStatement(statement);
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitContinueStatement(PsiContinueStatement statement) {
            PsiStatement exitedStatement = statement.findContinuedStatement();
            if (exitedStatement != null && PsiTreeUtil.isAncestor((PsiElement)this.myStartElement, (PsiElement)exitedStatement, (boolean)false)) {
                return;
            }
            if (this.addSideEffect((PsiElement)statement)) {
                return;
            }
            super.visitContinueStatement(statement);
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            if (this.addSideEffect((PsiElement)statement)) {
                return;
            }
            super.visitReturnStatement(statement);
        }

        public void visitThrowStatement(PsiThrowStatement statement) {
            if (this.addSideEffect((PsiElement)statement)) {
                return;
            }
            super.visitThrowStatement(statement);
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        public boolean mayHaveSideEffects() {
            return this.found;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

