/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallUtils {
    @NonNls
    private static final Set<String> regexMethodNames = new HashSet<String>(5);

    private MethodCallUtils() {
    }

    @Nullable
    public static String getMethodName(@NotNull PsiMethodCallExpression expression2) {
        if (expression2 == null) {
            MethodCallUtils.$$$reportNull$$$0(0);
        }
        return expression2.getMethodExpression().getReferenceName();
    }

    @Nullable
    public static PsiType getTargetType(@NotNull PsiMethodCallExpression expression2) {
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression2;
        if (expression2 == null) {
            MethodCallUtils.$$$reportNull$$$0(1);
        }
        if ((qualifierExpression2 = (methodExpression = expression2.getMethodExpression()).getQualifierExpression()) == null) {
            return null;
        }
        return qualifierExpression2.getType();
    }

    public static boolean isCompareToCall(@NotNull PsiMethodCallExpression expression2) {
        if (expression2 == null) {
            MethodCallUtils.$$$reportNull$$$0(2);
        }
        if (!"compareTo".equals(MethodCallUtils.getMethodName(expression2))) {
            return false;
        }
        return MethodUtils.isCompareTo(expression2.resolveMethod());
    }

    public static boolean isCompareToIgnoreCaseCall(@NotNull PsiMethodCallExpression expression2) {
        if (expression2 == null) {
            MethodCallUtils.$$$reportNull$$$0(3);
        }
        if (!"compareToIgnoreCase".equals(MethodCallUtils.getMethodName(expression2))) {
            return false;
        }
        return MethodUtils.isCompareToIgnoreCase(expression2.resolveMethod());
    }

    public static boolean isEqualsCall(PsiMethodCallExpression expression2) {
        if (!"equals".equals(MethodCallUtils.getMethodName(expression2))) {
            return false;
        }
        return MethodUtils.isEquals(expression2.resolveMethod());
    }

    public static boolean isEqualsIgnoreCaseCall(PsiMethodCallExpression expression2) {
        if (!"equalsIgnoreCase".equals(MethodCallUtils.getMethodName(expression2))) {
            return false;
        }
        return MethodUtils.isEqualsIgnoreCase(expression2.resolveMethod());
    }

    public static boolean isSimpleCallToMethod(@NotNull PsiMethodCallExpression expression2, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, String ... parameterTypeStrings) {
        if (expression2 == null) {
            MethodCallUtils.$$$reportNull$$$0(4);
        }
        if (parameterTypeStrings == null) {
            return MethodCallUtils.isCallToMethod(expression2, calledOnClassName, returnType, methodName, (PsiType[])null);
        }
        if (!MethodCallUtils.checkMethodName(expression2, methodName)) {
            return false;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)expression2.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiType[] parameterTypes = PsiType.createArray((int)parameterTypeStrings.length);
        GlobalSearchScope scope = expression2.getResolveScope();
        for (int i = 0; i < parameterTypeStrings.length; ++i) {
            String parameterTypeString = parameterTypeStrings[i];
            parameterTypes[i] = factory.createTypeByFQClassName(parameterTypeString, scope);
        }
        return MethodCallUtils.isCallToMethod(expression2, calledOnClassName, returnType, methodName, parameterTypes);
    }

    public static boolean isCallToStaticMethod(@NotNull PsiMethodCallExpression expression2, @NonNls @NotNull String calledOnClassName, @NonNls @NotNull String methodName, int parameterCount) {
        if (expression2 == null) {
            MethodCallUtils.$$$reportNull$$$0(5);
        }
        if (calledOnClassName == null) {
            MethodCallUtils.$$$reportNull$$$0(6);
        }
        if (methodName == null) {
            MethodCallUtils.$$$reportNull$$$0(7);
        }
        PsiExpression[] args = expression2.getArgumentList().getExpressions();
        if (!methodName.equals(MethodCallUtils.getMethodName(expression2)) || args.length < parameterCount) {
            return false;
        }
        PsiMethod method = expression2.resolveMethod();
        if (method == null || !method.hasModifierProperty("static") || method.getParameterList().getParametersCount() != parameterCount || !method.isVarArgs() && args.length != parameterCount) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return aClass != null && calledOnClassName.equals(aClass.getQualifiedName());
    }

    public static boolean isCallToMethod(@NotNull PsiMethodCallExpression expression2, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @Nullable Pattern methodNamePattern, PsiType ... parameterTypes) {
        PsiExpression qualifier;
        PsiMethod method;
        if (expression2 == null) {
            MethodCallUtils.$$$reportNull$$$0(8);
        }
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        if (methodNamePattern != null) {
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                return false;
            }
            Matcher matcher = methodNamePattern.matcher(referenceName);
            if (!matcher.matches()) {
                return false;
            }
        }
        if ((method = expression2.resolveMethod()) == null) {
            return false;
        }
        if (calledOnClassName != null && (qualifier = methodExpression.getQualifierExpression()) != null) {
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, calledOnClassName)) {
                return false;
            }
            return MethodUtils.methodMatches(method, null, returnType, methodNamePattern, parameterTypes);
        }
        return MethodUtils.methodMatches(method, calledOnClassName, returnType, methodNamePattern, parameterTypes);
    }

    public static boolean isCallToMethod(@NotNull PsiMethodCallExpression expression2, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, PsiType ... parameterTypes) {
        if (expression2 == null) {
            MethodCallUtils.$$$reportNull$$$0(9);
        }
        if (!MethodCallUtils.checkMethodName(expression2, methodName)) {
            return false;
        }
        PsiMethod method = expression2.resolveMethod();
        if (method == null) {
            return false;
        }
        return MethodUtils.methodMatches(method, calledOnClassName, returnType, methodName, parameterTypes);
    }

    private static boolean checkMethodName(@NotNull PsiMethodCallExpression expression2, @Nullable @NonNls String methodName) {
        if (expression2 == null) {
            MethodCallUtils.$$$reportNull$$$0(10);
        }
        return methodName == null || methodName.equals(MethodCallUtils.getMethodName(expression2));
    }

    public static boolean isCallToRegexMethod(PsiMethodCallExpression expression2) {
        if (!regexMethodNames.contains(MethodCallUtils.getMethodName(expression2))) {
            return false;
        }
        PsiMethod method = expression2.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String className2 = containingClass.getQualifiedName();
        return "java.lang.String".equals(className2) || "java.util.regex.Pattern".equals(className2);
    }

    public static boolean isCallDuringObjectConstruction(PsiMethodCallExpression expression2) {
        PsiExpression qualifier = expression2.getMethodExpression().getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
            return false;
        }
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMember.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        if (member == null) {
            return false;
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null || containingClass.hasModifierProperty("final")) {
            return false;
        }
        if (member instanceof PsiClassInitializer) {
            PsiClassInitializer classInitializer = (PsiClassInitializer)member;
            if (!classInitializer.hasModifierProperty("static")) {
                return true;
            }
        } else {
            PsiField field;
            if (member instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)member;
                if (method.isConstructor()) {
                    return true;
                }
                if (CloneUtils.isClone(method)) {
                    return true;
                }
                if (MethodUtils.simpleMethodMatches(method, null, "void", "readObject", "java.io.ObjectInputStream")) {
                    return true;
                }
                return MethodUtils.simpleMethodMatches(method, null, "void", "readObjectNoData", new String[0]);
            }
            if (member instanceof PsiField && !(field = (PsiField)member).hasModifierProperty("static")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isMethodCallOnVariable(@NotNull PsiMethodCallExpression expression2, @NotNull PsiVariable variable, @NotNull String methodName) {
        PsiReferenceExpression methodExpression;
        String name2;
        if (expression2 == null) {
            MethodCallUtils.$$$reportNull$$$0(11);
        }
        if (variable == null) {
            MethodCallUtils.$$$reportNull$$$0(12);
        }
        if (methodName == null) {
            MethodCallUtils.$$$reportNull$$$0(13);
        }
        if (!methodName.equals(name2 = (methodExpression = expression2.getMethodExpression()).getReferenceName())) {
            return false;
        }
        PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
        PsiElement element = referenceExpression.resolve();
        return variable.equals(element);
    }

    @Nullable
    public static PsiMethod findMethodWithReplacedArgument(@NotNull PsiCall call, @NotNull PsiExpression target, @NotNull PsiExpression replacement) {
        PsiExpressionList argumentList;
        if (call == null) {
            MethodCallUtils.$$$reportNull$$$0(14);
        }
        if (target == null) {
            MethodCallUtils.$$$reportNull$$$0(15);
        }
        if (replacement == null) {
            MethodCallUtils.$$$reportNull$$$0(16);
        }
        if ((argumentList = call.getArgumentList()) == null) {
            return null;
        }
        PsiExpression[] expressions2 = argumentList.getExpressions();
        int index = -1;
        for (int i = 0; i < expressions2.length; ++i) {
            PsiExpression expression2 = expressions2[i];
            if (expression2 != target) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return null;
        }
        PsiCall copy = (PsiCall)call.copy();
        PsiExpressionList copyArgumentList = copy.getArgumentList();
        assert (copyArgumentList != null);
        PsiExpression[] arguments = copyArgumentList.getExpressions();
        arguments[index].replace((PsiElement)replacement);
        if (call instanceof PsiEnumConstant) {
            PsiClass containingClass = ((PsiEnumConstant)call).getContainingClass();
            assert (containingClass != null);
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)call.getProject());
            PsiClassType type2 = facade.getElementFactory().createType(containingClass);
            JavaResolveResult resolveResult = facade.getResolveHelper().resolveConstructor(type2, copy.getArgumentList(), (PsiElement)call);
            return (PsiMethod)resolveResult.getElement();
        }
        return copy.resolveMethod();
    }

    public static boolean isNecessaryForSurroundingMethodCall(PsiExpression expression2, PsiExpression replacement) {
        PsiElement parent = expression2.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            expression2 = (PsiExpression)parent;
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof PsiCall)) {
            return false;
        }
        PsiCall call = (PsiCall)grandParent;
        return call.resolveMethod() != MethodCallUtils.findMethodWithReplacedArgument(call, expression2, replacement);
    }

    public static boolean isSuperMethodCall(@NotNull PsiMethodCallExpression expression2, @NotNull PsiMethod method) {
        if (expression2 == null) {
            MethodCallUtils.$$$reportNull$$$0(17);
        }
        if (method == null) {
            MethodCallUtils.$$$reportNull$$$0(18);
        }
        if (!MethodCallUtils.hasSuperQualifier(expression2)) {
            return false;
        }
        PsiMethod targetMethod = expression2.resolveMethod();
        return targetMethod != null && MethodSignatureUtil.isSuperMethod((PsiMethod)targetMethod, (PsiMethod)method);
    }

    public static boolean hasSuperQualifier(@NotNull PsiMethodCallExpression expression2) {
        if (expression2 == null) {
            MethodCallUtils.$$$reportNull$$$0(19);
        }
        return ParenthesesUtils.stripParentheses(expression2.getMethodExpression().getQualifierExpression()) instanceof PsiSuperExpression;
    }

    public static boolean isVarArgCall(PsiCall call) {
        JavaResolveResult result = call.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)result.getElement(), PsiMethod.class);
        if (method == null || !method.isVarArgs()) {
            return false;
        }
        PsiSubstitutor substitutor = result.getSubstitutor();
        PsiExpressionList argumentList = call.getArgumentList();
        return argumentList != null && MethodCallInstruction.isVarArgCall(method, substitutor, argumentList.getExpressions(), method.getParameterList().getParameters());
    }

    public static boolean containsSuperMethodCall(@NotNull PsiMethod method) {
        if (method == null) {
            MethodCallUtils.$$$reportNull$$$0(20);
        }
        SuperCallVisitor visitor = new SuperCallVisitor(method);
        method.accept((PsiElementVisitor)visitor);
        return visitor.isSuperCallFound();
    }

    public static boolean callWithNonConstantString(@NotNull PsiMethodCallExpression expression2, boolean considerStaticFinalConstant, String className2, String ... methodNames) {
        PsiField field;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        if (expression2 == null) {
            MethodCallUtils.$$$reportNull$$$0(21);
        }
        String methodName = MethodCallUtils.getMethodName(expression2);
        boolean found = false;
        for (String name2 : methodNames) {
            if (!name2.equals(methodName)) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        PsiMethod method = expression2.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)className2)) {
            return false;
        }
        PsiExpressionList argumentList = expression2.getArgumentList();
        PsiExpression argument = ParenthesesUtils.stripParentheses(ExpressionUtils.getFirstExpressionInList(argumentList));
        if (argument == null) {
            return false;
        }
        PsiType type2 = argument.getType();
        if (type2 == null || !type2.equalsToText("java.lang.String")) {
            return false;
        }
        if (considerStaticFinalConstant && argument instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)argument).resolve()) instanceof PsiField && (field = (PsiField)target).hasModifierProperty("static") && field.hasModifierProperty("final")) {
            return false;
        }
        return !PsiUtil.isConstantExpression((PsiExpression)argument);
    }

    @Nullable
    public static PsiMethodCallExpression getQualifierMethodCall(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            MethodCallUtils.$$$reportNull$$$0(22);
        }
        return (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)methodCall.getMethodExpression().getQualifierExpression()), PsiMethodCallExpression.class);
    }

    public static boolean isUsedAsSuperConstructorCallArgument(@NotNull PsiParameter parameter2, boolean superMustBeLibrary) {
        PsiElement scope;
        if (parameter2 == null) {
            MethodCallUtils.$$$reportNull$$$0(23);
        }
        if (!((scope = parameter2.getDeclarationScope()) instanceof PsiMethod) || !((PsiMethod)scope).isConstructor()) {
            return false;
        }
        PsiMethod method = (PsiMethod)scope;
        THashSet checked = new THashSet();
        while (true) {
            ProgressManager.checkCanceled();
            if (!checked.add(method)) {
                return false;
            }
            PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
            if (call == null) {
                return false;
            }
            int index = MethodCallUtils.getParameterReferenceIndex(call, parameter2);
            if (index < 0) {
                return false;
            }
            JavaResolveResult resolveResult = call.resolveMethodGenerics();
            if (!resolveResult.isValidResult()) {
                return false;
            }
            method = (PsiMethod)resolveResult.getElement();
            if (method == null) {
                return false;
            }
            if (JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)call) && (!superMustBeLibrary || method instanceof PsiCompiledElement)) {
                return true;
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            parameter2 = parameters2[Math.min(index, parameters2.length - 1)];
        }
    }

    @Nullable
    public static PsiParameter getParameterForArgument(@NotNull PsiExpression argument) {
        PsiCall call;
        PsiExpressionList argList;
        if (argument == null) {
            MethodCallUtils.$$$reportNull$$$0(24);
        }
        if ((argList = (PsiExpressionList)ObjectUtils.tryCast((Object)argument.getParent(), PsiExpressionList.class)) == null) {
            return null;
        }
        PsiElement parent = argList.getParent();
        if (parent instanceof PsiAnonymousClass) {
            parent = parent.getParent();
        }
        if ((call = (PsiCall)ObjectUtils.tryCast((Object)parent, PsiCall.class)) == null) {
            return null;
        }
        Object[] args = argList.getExpressions();
        int index = ArrayUtil.indexOf((Object[])args, (Object)argument);
        if (index == -1) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (index >= parameters2.length) {
            return null;
        }
        if (MethodCallUtils.isVarArgCall(call) && index >= parameters2.length - 1) {
            return null;
        }
        return parameters2[index];
    }

    private static int getParameterReferenceIndex(PsiMethodCallExpression call, PsiParameter parameter2) {
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        for (int i = 0; i < arguments.length; ++i) {
            PsiElement target;
            PsiExpression argument = arguments[i];
            if (!((argument = ParenthesesUtils.stripParentheses(argument)) instanceof PsiReferenceExpression) || (target = ((PsiReferenceExpression)argument).resolve()) != parameter2) continue;
            return i;
        }
        return -1;
    }

    static {
        regexMethodNames.add("compile");
        regexMethodNames.add("matches");
        regexMethodNames.add("replaceFirst");
        regexMethodNames.add("replaceAll");
        regexMethodNames.add("split");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calledOnClassName";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/MethodCallUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompareToCall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompareToIgnoreCaseCall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSimpleCallToMethod";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallToStaticMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallToMethod";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethodName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodCallOnVariable";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodWithReplacedArgument";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuperMethodCall";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSuperQualifier";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "containsSuperMethodCall";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "callWithNonConstantString";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifierMethodCall";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsedAsSuperConstructorCallArgument";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterForArgument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SuperCallVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiMethod myMethod;
        private boolean mySuperCallFound;

        SuperCallVisitor(@NotNull PsiMethod method) {
            if (method == null) {
                SuperCallVisitor.$$$reportNull$$$0(0);
            }
            this.myMethod = method;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                SuperCallVisitor.$$$reportNull$$$0(1);
            }
            if (!this.mySuperCallFound) {
                super.visitElement(element);
            }
        }

        public void visitIfStatement(PsiIfStatement statement) {
            PsiExpression condition2 = statement.getCondition();
            Object result = ExpressionUtils.computeConstantExpression(condition2);
            if (result != null && result.equals(Boolean.FALSE)) {
                return;
            }
            super.visitIfStatement(statement);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                SuperCallVisitor.$$$reportNull$$$0(2);
            }
            if (this.mySuperCallFound) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            if (MethodCallUtils.isSuperMethodCall(expression2, this.myMethod)) {
                this.mySuperCallFound = true;
            }
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            PsiElement target;
            if (this.mySuperCallFound) {
                return;
            }
            PsiExpression qualifier = expression2.getQualifierExpression();
            if (qualifier instanceof PsiSuperExpression && (target = expression2.resolve()) instanceof PsiMethod && MethodSignatureUtil.isSuperMethod((PsiMethod)((PsiMethod)target), (PsiMethod)this.myMethod)) {
                this.mySuperCallFound = true;
                return;
            }
            super.visitMethodReferenceExpression(expression2);
        }

        boolean isSuperCallFound() {
            return this.mySuperCallFound;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/MethodCallUtils$SuperCallVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

