/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8MigrationUtils {
    @Nullable
    private static MapCheckCondition tryExtract(PsiExpression fullCondition, @Nullable PsiStatement statement, boolean treatGetNullAsContainsKey) {
        PsiMethodCallExpression call;
        PsiExpression condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)fullCondition);
        boolean negated = false;
        while (condition2 != null && BoolUtils.isNegation(condition2)) {
            negated ^= true;
            condition2 = BoolUtils.getNegated(condition2);
        }
        if (condition2 == null) {
            return null;
        }
        PsiReferenceExpression valueReference = null;
        boolean containsKey = false;
        if (condition2 instanceof PsiBinaryExpression) {
            negated ^= ((PsiBinaryExpression)condition2).getOperationTokenType().equals(JavaTokenType.EQEQ);
            PsiExpression value2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getValueComparedWithNull((PsiBinaryExpression)condition2));
            if (value2 instanceof PsiReferenceExpression && statement != null) {
                valueReference = (PsiReferenceExpression)value2;
                PsiElement previous = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)statement);
                call = Java8MigrationUtils.tryExtractMapGetCall(valueReference, previous);
            } else {
                call = Java8MigrationUtils.extractMapMethodCall(value2, "get");
            }
        } else {
            call = Java8MigrationUtils.extractMapMethodCall(condition2, "containsKey");
            containsKey = true;
        }
        if (call == null) {
            return null;
        }
        PsiExpression mapExpression = call.getMethodExpression().getQualifierExpression();
        if (mapExpression == null) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 1) {
            return null;
        }
        PsiExpression keyExpression = args[0];
        return new MapCheckCondition(valueReference, mapExpression, keyExpression, fullCondition, negated, containsKey, treatGetNullAsContainsKey);
    }

    @Nullable
    @Contract(value="_, null -> null")
    private static PsiMethodCallExpression tryExtractMapGetCall(PsiReferenceExpression target, PsiElement element) {
        PsiExpression lValue;
        PsiElement lastDeclaration;
        PsiDeclarationStatement declaration2;
        PsiElement[] elements;
        if (element instanceof PsiDeclarationStatement && (elements = (declaration2 = (PsiDeclarationStatement)element).getDeclaredElements()).length > 0 && (lastDeclaration = elements[elements.length - 1]) instanceof PsiLocalVariable && target.isReferenceTo(lastDeclaration)) {
            PsiLocalVariable var = (PsiLocalVariable)lastDeclaration;
            return Java8MigrationUtils.extractMapMethodCall(var.getInitializer(), "get");
        }
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(element);
        if (assignment != null && (lValue = assignment.getLExpression()) instanceof PsiReferenceExpression && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)target, lValue)) {
            return Java8MigrationUtils.extractMapMethodCall(assignment.getRExpression(), "get");
        }
        return null;
    }

    @Contract(value="null, _ -> null")
    public static PsiMethodCallExpression extractMapMethodCall(PsiExpression expression2, @NotNull String expectedName) {
        if (expectedName == null) {
            Java8MigrationUtils.$$$reportNull$$$0(0);
        }
        if (!((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
        if (!expectedName.equals(methodCallExpression.getMethodExpression().getReferenceName())) {
            return null;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return null;
        }
        Object[] superMethods = method.findDeepestSuperMethods();
        if (superMethods.length == 0) {
            superMethods = new PsiMethod[]{method};
        }
        return StreamEx.of((Object[])superMethods).map(PsiMember::getContainingClass).nonNull().map(PsiClass::getQualifiedName).has((Object)"java.util.Map") ? methodCallExpression : null;
    }

    @Nullable
    public static PsiExpression extractLambdaCandidate(MapCheckCondition condition2, PsiStatement statement) {
        PsiAssignmentExpression assignment;
        PsiExpression putValue = Java8MigrationUtils.extractPutValue(condition2, statement);
        if (putValue != null) {
            assignment = ExpressionUtils.getAssignment((PsiElement)putValue);
        } else {
            if (!(statement instanceof PsiBlockStatement)) {
                return null;
            }
            PsiStatement[] statements = ((PsiBlockStatement)statement).getCodeBlock().getStatements();
            if (statements.length != 2) {
                return null;
            }
            putValue = Java8MigrationUtils.extractPutValue(condition2, statements[1]);
            if (!condition2.isValueReference((PsiElement)putValue)) {
                return null;
            }
            assignment = ExpressionUtils.getAssignment((PsiElement)statements[0]);
        }
        if (assignment == null) {
            return null;
        }
        PsiExpression lambdaCandidate = assignment.getRExpression();
        if (lambdaCandidate == null || !condition2.isValueReference((PsiElement)assignment.getLExpression())) {
            return null;
        }
        if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)lambdaCandidate)) {
            return null;
        }
        return lambdaCandidate;
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static PsiExpression extractPutValue(MapCheckCondition condition2, PsiStatement statement) {
        if (!(statement instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiMethodCallExpression putCall = Java8MigrationUtils.extractMapMethodCall(((PsiExpressionStatement)statement).getExpression(), "put");
        if (putCall == null) {
            return null;
        }
        PsiExpression[] putArguments = putCall.getArgumentList().getExpressions();
        return putArguments.length == 2 && condition2.isMap((PsiElement)putCall.getMethodExpression().getQualifierExpression()) && condition2.isKey((PsiElement)putArguments[0]) ? putArguments[1] : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedName", "com/siyeh/ig/psiutils/Java8MigrationUtils", "extractMapMethodCall"));
    }

    public static class MapLoopCondition
    implements MapCondition {
        private final PsiParameter myIterParam;
        private final boolean myIsEntrySet;
        private final PsiReferenceExpression myMapExpression;
        private final PsiVariable myMap;

        private MapLoopCondition(@NotNull PsiParameter iterParam, boolean isEntrySet, @NotNull PsiReferenceExpression mapExpression, @NotNull PsiVariable map2) {
            if (iterParam == null) {
                MapLoopCondition.$$$reportNull$$$0(0);
            }
            if (mapExpression == null) {
                MapLoopCondition.$$$reportNull$$$0(1);
            }
            if (map2 == null) {
                MapLoopCondition.$$$reportNull$$$0(2);
            }
            this.myIterParam = iterParam;
            this.myIsEntrySet = isEntrySet;
            this.myMapExpression = mapExpression;
            this.myMap = map2;
        }

        @Nullable
        public PsiMethodCallExpression extractPut(@NotNull PsiForeachStatement statement) {
            PsiExpressionStatement putStatement;
            if (statement == null) {
                MapLoopCondition.$$$reportNull$$$0(3);
            }
            if ((putStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(statement.getBody()), PsiExpressionStatement.class)) == null) {
                return null;
            }
            PsiMethodCallExpression putCall = Java8MigrationUtils.extractMapMethodCall(putStatement.getExpression(), "put");
            if (putCall == null || !this.isMapRef((PsiElement)putCall.getMethodExpression().getQualifierExpression())) {
                return null;
            }
            return putCall;
        }

        public boolean isKeyAccess(@NotNull PsiExpression expression2) {
            if (expression2 == null) {
                MapLoopCondition.$$$reportNull$$$0(4);
            }
            if (!this.myIsEntrySet) {
                PsiReferenceExpression keyRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)expression2, PsiReferenceExpression.class);
                return keyRef != null && keyRef.resolve() == this.myIterParam;
            }
            return this.isParamCall(expression2, "getKey");
        }

        public boolean isValueAccess(@NotNull PsiExpression expression2) {
            if (expression2 == null) {
                MapLoopCondition.$$$reportNull$$$0(5);
            }
            if (this.myIsEntrySet) {
                return this.isParamCall(expression2, "getValue");
            }
            return this.isGetCall(expression2);
        }

        private boolean isGetCall(@NotNull PsiExpression expression2) {
            PsiMethodCallExpression call;
            if (expression2 == null) {
                MapLoopCondition.$$$reportNull$$$0(6);
            }
            if ((call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2, PsiMethodCallExpression.class)) == null) {
                return false;
            }
            String name2 = call.getMethodExpression().getReferenceName();
            if (!"get".equals(name2) || !this.isMapRef((PsiElement)call.getMethodExpression().getQualifierExpression())) {
                return false;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            return args.length == 1 && ExpressionUtils.isReferenceTo(args[0], (PsiVariable)this.myIterParam);
        }

        public boolean isParamCall(@NotNull PsiMethodCallExpression call) {
            PsiReferenceExpression qualifier;
            if (call == null) {
                MapLoopCondition.$$$reportNull$$$0(7);
            }
            return (qualifier = (PsiReferenceExpression)ObjectUtils.tryCast((Object)call.getMethodExpression().getQualifierExpression(), PsiReferenceExpression.class)) != null && qualifier.resolve() == this.myIterParam;
        }

        public PsiParameter getIterParam() {
            return this.myIterParam;
        }

        public PsiVariable getMap() {
            return this.myMap;
        }

        public boolean isEntrySet() {
            return this.myIsEntrySet;
        }

        private boolean isParamCall(@NotNull PsiExpression expression2, @NotNull String expectedName) {
            PsiMethodCallExpression call;
            if (expression2 == null) {
                MapLoopCondition.$$$reportNull$$$0(8);
            }
            if (expectedName == null) {
                MapLoopCondition.$$$reportNull$$$0(9);
            }
            if ((call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2, PsiMethodCallExpression.class)) == null) {
                return false;
            }
            String name2 = call.getMethodExpression().getReferenceName();
            return expectedName.equals(name2) && this.isParamCall(call);
        }

        private boolean isMapRef(@Nullable PsiElement element) {
            return element != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.myMapExpression, (PsiElement)element);
        }

        @Nullable
        public static MapLoopCondition create(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                MapLoopCondition.$$$reportNull$$$0(10);
            }
            PsiExpression iteratedValue2 = statement.getIteratedValue();
            PsiParameter iterParam = statement.getIterationParameter();
            PsiMethodCallExpression iterCall = Java8MigrationUtils.extractMapMethodCall(iteratedValue2, "keySet");
            if (iterCall != null) {
                return MapLoopCondition.create(iterParam, false, iterCall.getMethodExpression().getQualifierExpression());
            }
            iterCall = Java8MigrationUtils.extractMapMethodCall(iteratedValue2, "entrySet");
            if (iterCall != null) {
                return MapLoopCondition.create(iterParam, true, iterCall.getMethodExpression().getQualifierExpression());
            }
            return null;
        }

        private static MapLoopCondition create(@NotNull PsiParameter iterParam, boolean isEntrySet, @Nullable PsiExpression qualifier) {
            PsiReferenceExpression ref;
            if (iterParam == null) {
                MapLoopCondition.$$$reportNull$$$0(11);
            }
            if ((ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)qualifier, PsiReferenceExpression.class)) == null) {
                return null;
            }
            PsiVariable map2 = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
            if (map2 == null) {
                return null;
            }
            return new MapLoopCondition(iterParam, isEntrySet, ref, map2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterParam";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 3: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedName";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/Java8MigrationUtils$MapLoopCondition";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extractPut";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isKeyAccess";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isValueAccess";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isGetCall";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isParamCall";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MapCheckCondition
    implements MapCondition {
        @Nullable
        private final PsiReferenceExpression myValueReference;
        private final PsiExpression myMapExpression;
        private final PsiExpression myKeyExpression;
        private final PsiExpression myFullCondition;
        private final boolean myNegated;
        private final boolean myContainsKey;
        private final boolean myTreatGetNullAsContainsKey;

        private MapCheckCondition(@Nullable PsiReferenceExpression valueReference, PsiExpression mapExpression, PsiExpression keyExpression, PsiExpression fullCondition, boolean negated, boolean containsKey, boolean treatGetNullAsContainsKey) {
            this.myValueReference = valueReference;
            this.myMapExpression = mapExpression;
            this.myKeyExpression = keyExpression;
            this.myFullCondition = fullCondition;
            this.myNegated = negated;
            this.myContainsKey = containsKey;
            this.myTreatGetNullAsContainsKey = treatGetNullAsContainsKey;
        }

        @Nullable
        public PsiReferenceExpression getValueReference() {
            return this.myValueReference;
        }

        @Nullable
        public PsiExpression getMapExpression() {
            return this.myMapExpression;
        }

        public PsiExpression getKeyExpression() {
            return this.myKeyExpression;
        }

        public boolean isContainsKey() {
            return this.myContainsKey || this.myTreatGetNullAsContainsKey;
        }

        public boolean isGetNull() {
            return !this.myContainsKey || this.myTreatGetNullAsContainsKey;
        }

        @Contract(value="null -> false")
        public boolean isMap(PsiElement element) {
            return element != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.myMapExpression, (PsiElement)element);
        }

        @Contract(value="null -> false")
        public boolean isKey(PsiElement element) {
            return element != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.myKeyExpression, (PsiElement)element);
        }

        public PsiMethodCallExpression extractGetCall(PsiElement element) {
            if (!(element instanceof PsiExpression)) {
                return null;
            }
            PsiMethodCallExpression getCall = Java8MigrationUtils.extractMapMethodCall((PsiExpression)element, "get");
            if (getCall == null) {
                return null;
            }
            PsiExpression[] args = getCall.getArgumentList().getExpressions();
            return args.length == 1 && this.isKey((PsiElement)args[0]) && this.isMap((PsiElement)getCall.getMethodExpression().getQualifierExpression()) ? getCall : null;
        }

        @Contract(value="null -> false")
        public boolean isValueReference(PsiElement element) {
            return element != null && this.myValueReference != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)this.myValueReference);
        }

        public <T extends PsiElement> T getExistsBranch(T thenBranch, T elseBranch) {
            return this.myNegated ? elseBranch : thenBranch;
        }

        public <T extends PsiElement> T getNoneBranch(T thenBranch, T elseBranch) {
            return this.myNegated ? thenBranch : elseBranch;
        }

        public PsiVariable extractDeclaration() {
            if (this.myValueReference == null) {
                return null;
            }
            return (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)this.myKeyExpression, PsiVariable.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
        }

        public boolean hasVariable() {
            if (this.myValueReference == null) {
                return false;
            }
            PsiVariable var = this.extractDeclaration();
            return var == null || ReferencesSearch.search((PsiElement)var).findAll().size() != 1;
        }

        public PsiMethodCallExpression getCheckCall() {
            return (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myMapExpression, PsiMethodCallExpression.class);
        }

        public PsiExpression getFullCondition() {
            return this.myFullCondition;
        }

        public boolean isMapValueType(@Nullable PsiType type2) {
            if (type2 == null) {
                return false;
            }
            PsiType mapExpressionType = this.myMapExpression.getType();
            PsiType valueTypeParameter = PsiUtil.substituteTypeParameter((PsiType)mapExpressionType, (String)"java.util.Map", (int)1, (boolean)false);
            return valueTypeParameter != null && valueTypeParameter.isAssignableFrom(type2);
        }

        @Contract(value="null, _ -> null")
        public static MapCheckCondition fromConditional(PsiElement conditional, boolean treatGetNullAsContainsKey) {
            if (conditional instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)conditional;
                return Java8MigrationUtils.tryExtract(ifStatement.getCondition(), (PsiStatement)ifStatement, treatGetNullAsContainsKey);
            }
            if (conditional instanceof PsiConditionalExpression) {
                PsiConditionalExpression ternary = (PsiConditionalExpression)conditional;
                PsiElement parent = ternary.getParent().getParent();
                return Java8MigrationUtils.tryExtract(ternary.getCondition(), parent instanceof PsiStatement ? (PsiStatement)parent : null, treatGetNullAsContainsKey);
            }
            return null;
        }
    }

    public static interface MapCondition {
    }
}

