/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtils {
    private static final Set<String> s_genericExceptionTypes = new HashSet<String>(4);

    private ExceptionUtils() {
    }

    @NotNull
    public static Set<PsiClassType> calculateExceptionsThrown(@Nullable PsiElement element) {
        Set<PsiClassType> set = ExceptionUtils.calculateExceptionsThrown(element, new LinkedHashSet<PsiClassType>(5));
        if (set == null) {
            ExceptionUtils.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public static Set<PsiClassType> calculateExceptionsThrown(@Nullable PsiElement element, @NotNull Set<PsiClassType> out) {
        if (out == null) {
            ExceptionUtils.$$$reportNull$$$0(1);
        }
        if (element == null) {
            Set<PsiClassType> set = out;
            if (set == null) {
                ExceptionUtils.$$$reportNull$$$0(2);
            }
            return set;
        }
        if (element instanceof PsiResourceList) {
            PsiResourceList resourceList = (PsiResourceList)element;
            for (PsiResourceListElement resource : resourceList) {
                out.addAll(ExceptionUtil.getCloserExceptions(resource));
            }
        }
        ExceptionsThrownVisitor visitor = new ExceptionsThrownVisitor(out);
        element.accept((PsiElementVisitor)visitor);
        Set<PsiClassType> set = out;
        if (set == null) {
            ExceptionUtils.$$$reportNull$$$0(3);
        }
        return set;
    }

    public static boolean isGenericExceptionClass(@Nullable PsiType exceptionType) {
        if (!(exceptionType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)exceptionType;
        String className2 = classType.getCanonicalText();
        return s_genericExceptionTypes.contains(className2);
    }

    public static boolean isThrowableRethrown(PsiParameter throwable, PsiCodeBlock catchBlock) {
        PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(catchBlock);
        if (!(lastStatement instanceof PsiThrowStatement)) {
            return false;
        }
        PsiThrowStatement throwStatement = (PsiThrowStatement)lastStatement;
        PsiExpression expression2 = throwStatement.getException();
        if (!(expression2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
        PsiElement element = referenceExpression.resolve();
        return throwable.equals(element);
    }

    static boolean statementThrowsException(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiAssertStatement || statement instanceof PsiReturnStatement || statement instanceof PsiExpressionStatement || statement instanceof PsiExpressionListStatement || statement instanceof PsiForeachStatement || statement instanceof PsiDeclarationStatement || statement instanceof PsiEmptyStatement || statement instanceof PsiSwitchLabelStatement) {
            return false;
        }
        if (statement instanceof PsiThrowStatement) {
            return true;
        }
        if (statement instanceof PsiForStatement) {
            return ExceptionUtils.forStatementThrowsException((PsiForStatement)statement);
        }
        if (statement instanceof PsiWhileStatement) {
            return ExceptionUtils.whileStatementThrowsException((PsiWhileStatement)statement);
        }
        if (statement instanceof PsiDoWhileStatement) {
            return ExceptionUtils.doWhileThrowsException((PsiDoWhileStatement)statement);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement;
            PsiCodeBlock body2 = synchronizedStatement.getBody();
            return ExceptionUtils.blockThrowsException(body2);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            return ExceptionUtils.blockThrowsException(codeBlock);
        }
        if (statement instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
            PsiStatement statementLabeled = labeledStatement.getStatement();
            return ExceptionUtils.statementThrowsException(statementLabeled);
        }
        if (statement instanceof PsiIfStatement) {
            return ExceptionUtils.ifStatementThrowsException((PsiIfStatement)statement);
        }
        if (statement instanceof PsiTryStatement) {
            return ExceptionUtils.tryStatementThrowsException((PsiTryStatement)statement);
        }
        if (statement instanceof PsiSwitchStatement) {
            return false;
        }
        return false;
    }

    static boolean blockThrowsException(@Nullable PsiCodeBlock block) {
        PsiStatement[] statements;
        if (block == null) {
            return false;
        }
        for (PsiStatement statement : statements = block.getStatements()) {
            if (!ExceptionUtils.statementThrowsException(statement)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryStatementThrowsException(PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
        if (catchBlocks.length == 0 && ExceptionUtils.blockThrowsException(tryBlock = tryStatement.getTryBlock())) {
            return true;
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        return ExceptionUtils.blockThrowsException(finallyBlock);
    }

    private static boolean ifStatementThrowsException(PsiIfStatement ifStatement) {
        return ExceptionUtils.statementThrowsException(ifStatement.getThenBranch()) && ExceptionUtils.statementThrowsException(ifStatement.getElseBranch());
    }

    private static boolean doWhileThrowsException(PsiDoWhileStatement doWhileStatement) {
        return ExceptionUtils.statementThrowsException(doWhileStatement.getBody());
    }

    private static boolean whileStatementThrowsException(PsiWhileStatement whileStatement) {
        PsiStatement body2;
        PsiExpression condition2 = whileStatement.getCondition();
        return BoolUtils.isTrue(condition2) && ExceptionUtils.statementThrowsException(body2 = whileStatement.getBody());
    }

    private static boolean forStatementThrowsException(PsiForStatement forStatement) {
        PsiStatement initialization = forStatement.getInitialization();
        if (ExceptionUtils.statementThrowsException(initialization)) {
            return true;
        }
        PsiExpression test = forStatement.getCondition();
        if (BoolUtils.isTrue(test)) {
            PsiStatement body2 = forStatement.getBody();
            if (ExceptionUtils.statementThrowsException(body2)) {
                return true;
            }
            PsiStatement update2 = forStatement.getUpdate();
            if (ExceptionUtils.statementThrowsException(update2)) {
                return true;
            }
        }
        return false;
    }

    public static Set<PsiType> getExceptionTypesHandled(PsiTryStatement statement) {
        HashSet<PsiType> out = new HashSet<PsiType>(5);
        for (PsiParameter parameter2 : statement.getCatchBlockParameters()) {
            PsiType type2 = parameter2.getType();
            if (type2 instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type2;
                out.addAll(disjunctionType.getDisjunctions());
                continue;
            }
            out.add(type2);
        }
        return out;
    }

    public static boolean isExceptionArgument(@NotNull PsiExpression expression2) {
        PsiNewExpression newExpression;
        if (expression2 == null) {
            ExceptionUtils.$$$reportNull$$$0(4);
        }
        if ((newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiNewExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class})) != null) {
            PsiType newExpressionType = newExpression.getType();
            if (InheritanceUtil.isInheritor((PsiType)newExpressionType, (String)"java.lang.Throwable")) {
                return true;
            }
        } else {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class});
            if (JavaPsiConstructorUtil.isConstructorCall((PsiElement)methodCallExpression)) {
                PsiMethod ctor = methodCallExpression.resolveMethod();
                return ctor != null && InheritanceUtil.isInheritor((PsiClass)ctor.getContainingClass(), (String)"java.lang.Throwable");
            }
        }
        return false;
    }

    static {
        s_genericExceptionTypes.add("java.lang.Throwable");
        s_genericExceptionTypes.add("java.lang.Exception");
        s_genericExceptionTypes.add("java.lang.RuntimeException");
        s_genericExceptionTypes.add("java.lang.Error");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/ExceptionUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateExceptionsThrown";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/ExceptionUtils";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateExceptionsThrown";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExceptionArgument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExceptionsThrownVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiClassType> m_exceptionsThrown;

        private ExceptionsThrownVisitor(Set<PsiClassType> thrownTypes) {
            this.m_exceptionsThrown = thrownTypes;
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            super.visitCallExpression(callExpression);
            JavaResolveResult resolveResult = callExpression.resolveMethodGenerics();
            PsiElement target = resolveResult.getElement();
            if (!(target instanceof PsiMethod)) {
                return;
            }
            PsiClassType[] referencedTypes = ((PsiMethod)target).getThrowsList().getReferencedTypes();
            this.m_exceptionsThrown.addAll(ExceptionUtil.collectSubstituted(resolveResult.getSubstitutor(), referencedTypes, callExpression.getResolveScope()));
        }

        public void visitThrowStatement(PsiThrowStatement statement) {
            super.visitThrowStatement(statement);
            PsiExpression exception = statement.getException();
            if (exception == null) {
                return;
            }
            PsiType type2 = exception.getType();
            if (type2 instanceof PsiClassType) {
                this.m_exceptionsThrown.add((PsiClassType)type2);
            }
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            if (statement == null) {
                ExceptionsThrownVisitor.$$$reportNull$$$0(0);
            }
            Set<PsiType> exceptionsHandled = ExceptionUtils.getExceptionTypesHandled(statement);
            for (PsiClassType resourceException : ExceptionUtils.calculateExceptionsThrown((PsiElement)statement.getResourceList())) {
                if (ExceptionsThrownVisitor.isExceptionHandled(exceptionsHandled, (PsiType)resourceException)) continue;
                this.m_exceptionsThrown.add(resourceException);
            }
            for (PsiClassType tryException : ExceptionUtils.calculateExceptionsThrown((PsiElement)statement.getTryBlock())) {
                if (ExceptionsThrownVisitor.isExceptionHandled(exceptionsHandled, (PsiType)tryException)) continue;
                this.m_exceptionsThrown.add(tryException);
            }
            ExceptionUtils.calculateExceptionsThrown((PsiElement)statement.getFinallyBlock(), this.m_exceptionsThrown);
            for (PsiCodeBlock catchBlock : statement.getCatchBlocks()) {
                ExceptionUtils.calculateExceptionsThrown((PsiElement)catchBlock, this.m_exceptionsThrown);
            }
        }

        private static boolean isExceptionHandled(Set<PsiType> exceptionsHandled, @NotNull PsiType thrownType) {
            if (thrownType == null) {
                ExceptionsThrownVisitor.$$$reportNull$$$0(1);
            }
            if (exceptionsHandled.contains(thrownType)) {
                return true;
            }
            for (PsiType exceptionHandled : exceptionsHandled) {
                if (!exceptionHandled.isAssignableFrom(thrownType)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thrownType";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ExceptionUtils$ExceptionsThrownVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTryStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isExceptionHandled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

