/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionUtils {
    private static final CallMatcher COLLECTION_MAP_SIZE = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "size").parameterCount(0), CallMatcher.instanceCall("java.util.Map", "size").parameterCount(0));
    public static final CallMatcher DERIVED_COLLECTION = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Map", "keySet", "values", "entrySet").parameterCount(0), CallMatcher.instanceCall("java.util.NavigableMap", "descendingKeySet", "descendingMap", "navigableKeySet").parameterCount(0), CallMatcher.instanceCall("java.util.NavigableSet", "descendingSet").parameterCount(0));
    @NonNls
    private static final Set<String> s_allCollectionClassesAndInterfaces;
    @NonNls
    private static final Map<String, String> s_interfaceForCollection;

    private CollectionUtils() {
    }

    public static Set<String> getAllCollectionNames() {
        return s_allCollectionClassesAndInterfaces;
    }

    @Contract(value="null -> false")
    public static boolean isConcreteCollectionClass(@Nullable PsiType type2) {
        return CollectionUtils.isConcreteCollectionClass(PsiUtil.resolveClassInClassTypeOnly((PsiType)type2));
    }

    @Contract(value="null -> false")
    public static boolean isConcreteCollectionClass(PsiClass aClass) {
        if (aClass == null || aClass.isEnum() || aClass.isInterface() || aClass.isAnnotationType() || aClass.hasModifierProperty("abstract")) {
            return false;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Collection") && !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Map")) {
            return false;
        }
        String name2 = aClass.getQualifiedName();
        return name2 != null && name2.startsWith("java.util.");
    }

    public static boolean isCollectionClassOrInterface(@Nullable PsiType type2) {
        PsiClass resolved = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        if (resolved == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)resolved, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiClass)resolved, (String)"java.util.Map") || InheritanceUtil.isInheritor((PsiClass)resolved, (String)"com.google.common.collect.Multimap") || InheritanceUtil.isInheritor((PsiClass)resolved, (String)"com.google.common.collect.Table");
    }

    public static boolean isCollectionClassOrInterface(PsiClass aClass) {
        return CollectionUtils.isCollectionClassOrInterface(aClass, new HashSet());
    }

    private static boolean isCollectionClassOrInterface(PsiClass aClass, Set<? super PsiClass> visitedClasses) {
        PsiClass[] supers;
        if (!visitedClasses.add((PsiClass)aClass)) {
            return false;
        }
        String className2 = aClass.getQualifiedName();
        if (s_allCollectionClassesAndInterfaces.contains(className2)) {
            return true;
        }
        for (PsiClass aSuper : supers = aClass.getSupers()) {
            if (!CollectionUtils.isCollectionClassOrInterface(aSuper, visitedClasses)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWeakCollectionClass(@Nullable PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        String typeText = type2.getCanonicalText();
        return "java.util.WeakHashMap".equals(typeText);
    }

    public static boolean isConstantEmptyArray(@NotNull PsiField field) {
        if (field == null) {
            CollectionUtils.$$$reportNull$$$0(0);
        }
        if (!field.hasModifierProperty("static") || !field.hasModifierProperty("final")) {
            return false;
        }
        return CollectionUtils.isEmptyArray((PsiVariable)field);
    }

    public static boolean isEmptyArray(PsiVariable variable) {
        PsiExpression initializer = variable.getInitializer();
        if (initializer instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)initializer;
            PsiExpression[] initializers = arrayInitializerExpression.getInitializers();
            return initializers.length == 0;
        }
        return ConstructionUtils.isEmptyArrayInitializer(initializer);
    }

    public static String getInterfaceForClass(String name2) {
        int parameterStart = name2.indexOf(60);
        String baseName = parameterStart >= 0 ? name2.substring(0, parameterStart).trim() : name2;
        return s_interfaceForCollection.get(baseName);
    }

    @Contract(value="null, _ -> false")
    public static boolean isCollectionOrMapSize(@Nullable PsiExpression expression2, @NotNull PsiExpression collection) {
        PsiMethodCallExpression sizeCall;
        if (collection == null) {
            CollectionUtils.$$$reportNull$$$0(1);
        }
        if (!COLLECTION_MAP_SIZE.test(sizeCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiMethodCallExpression.class))) {
            return false;
        }
        PsiExpression sizeQualifier = sizeCall.getMethodExpression().getQualifierExpression();
        if (sizeQualifier == null) {
            return false;
        }
        sizeQualifier = CollectionUtils.getBaseCollection(sizeQualifier);
        collection = CollectionUtils.getBaseCollection(collection);
        return sizeQualifier != null && collection != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)sizeQualifier, (PsiElement)collection);
    }

    @Nullable
    private static PsiExpression getBaseCollection(@NotNull PsiExpression derivedCollection) {
        PsiMethodCallExpression derivedCall;
        if (derivedCollection == null) {
            CollectionUtils.$$$reportNull$$$0(2);
        }
        while (DERIVED_COLLECTION.test(derivedCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)derivedCollection), PsiMethodCallExpression.class))) {
            derivedCollection = ExpressionUtils.getEffectiveQualifier(derivedCall.getMethodExpression());
        }
        return derivedCollection;
    }

    static {
        s_interfaceForCollection = new HashMap<String, String>();
        HashSet<String> allCollectionClassesAndInterfaces = new HashSet<String>();
        allCollectionClassesAndInterfaces.add("java.util.AbstractCollection");
        allCollectionClassesAndInterfaces.add("java.util.AbstractList");
        allCollectionClassesAndInterfaces.add("java.util.AbstractMap");
        allCollectionClassesAndInterfaces.add("java.util.AbstractQueue");
        allCollectionClassesAndInterfaces.add("java.util.AbstractSequentialList");
        allCollectionClassesAndInterfaces.add("java.util.AbstractSet");
        allCollectionClassesAndInterfaces.add("java.util.ArrayList");
        allCollectionClassesAndInterfaces.add("java.util.ArrayDeque");
        allCollectionClassesAndInterfaces.add("java.util.Collection");
        allCollectionClassesAndInterfaces.add("java.util.Dictionary");
        allCollectionClassesAndInterfaces.add("java.util.EnumMap");
        allCollectionClassesAndInterfaces.add("java.util.HashMap");
        allCollectionClassesAndInterfaces.add("java.util.HashSet");
        allCollectionClassesAndInterfaces.add("java.util.Hashtable");
        allCollectionClassesAndInterfaces.add("java.util.IdentityHashMap");
        allCollectionClassesAndInterfaces.add("java.util.LinkedHashMap");
        allCollectionClassesAndInterfaces.add("java.util.LinkedHashSet");
        allCollectionClassesAndInterfaces.add("java.util.LinkedList");
        allCollectionClassesAndInterfaces.add("java.util.List");
        allCollectionClassesAndInterfaces.add("java.util.Map");
        allCollectionClassesAndInterfaces.add("java.util.PriorityQueue");
        allCollectionClassesAndInterfaces.add("java.util.Queue");
        allCollectionClassesAndInterfaces.add("java.util.Set");
        allCollectionClassesAndInterfaces.add("java.util.SortedMap");
        allCollectionClassesAndInterfaces.add("java.util.SortedSet");
        allCollectionClassesAndInterfaces.add("java.util.Stack");
        allCollectionClassesAndInterfaces.add("java.util.TreeMap");
        allCollectionClassesAndInterfaces.add("java.util.TreeSet");
        allCollectionClassesAndInterfaces.add("java.util.Vector");
        allCollectionClassesAndInterfaces.add("java.util.WeakHashMap");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ArrayBlockingQueue");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.BlockingDeque");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.BlockingQueue");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ConcurrentHashMap");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ConcurrentLinkedDeque");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ConcurrentLinkedQueue");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ConcurrentMap");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ConcurrentNavigableMap");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ConcurrentSkipListMap");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.ConcurrentSkipListSet");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.CopyOnWriteArrayList");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.CopyOnWriteArraySet");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.DelayQueue");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.LinkedBlockingDeque");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.LinkedBlockingQueue");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.LinkedTransferQueue");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.PriorityBlockingQueue");
        allCollectionClassesAndInterfaces.add("java.util.concurrent.SynchronousQueue");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.ArrayList");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Collection");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.HashMap");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.HashSet");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Hashtable");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.LinkedList");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.List");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Map");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Set");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.SortedMap");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.SortedSet");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.TreeMap");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.TreeSet");
        allCollectionClassesAndInterfaces.add("com.sun.java.util.collections.Vector");
        s_allCollectionClassesAndInterfaces = Collections.unmodifiableSet(allCollectionClassesAndInterfaces);
        s_interfaceForCollection.put("ArrayList", "List");
        s_interfaceForCollection.put("EnumMap", "Map");
        s_interfaceForCollection.put("EnumSet", "Set");
        s_interfaceForCollection.put("HashMap", "Map");
        s_interfaceForCollection.put("HashSet", "Set");
        s_interfaceForCollection.put("Hashtable", "Map");
        s_interfaceForCollection.put("IdentityHashMap", "Map");
        s_interfaceForCollection.put("LinkedHashMap", "Map");
        s_interfaceForCollection.put("LinkedHashSet", "Set");
        s_interfaceForCollection.put("LinkedList", "List");
        s_interfaceForCollection.put("PriorityQueue", "Queue");
        s_interfaceForCollection.put("TreeMap", "Map");
        s_interfaceForCollection.put("TreeSet", "SortedSet");
        s_interfaceForCollection.put("Vector", "List");
        s_interfaceForCollection.put("WeakHashMap", "Map");
        s_interfaceForCollection.put("java.util.ArrayList", "java.util.List");
        s_interfaceForCollection.put("java.util.EnumMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.EnumSet", "java.util.Set");
        s_interfaceForCollection.put("java.util.HashMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.HashSet", "java.util.Set");
        s_interfaceForCollection.put("java.util.Hashtable", "java.util.Map");
        s_interfaceForCollection.put("java.util.IdentityHashMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.LinkedHashMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.LinkedHashSet", "java.util.Set");
        s_interfaceForCollection.put("java.util.LinkedList", "java.util.List");
        s_interfaceForCollection.put("java.util.PriorityQueue", "java.util.Queue");
        s_interfaceForCollection.put("java.util.TreeMap", "java.util.Map");
        s_interfaceForCollection.put("java.util.TreeSet", "java.util.Set");
        s_interfaceForCollection.put("java.util.Vector", "java.util.List");
        s_interfaceForCollection.put("java.util.WeakHashMap", "java.util.Map");
        s_interfaceForCollection.put("com.sun.java.util.collections.HashSet", "com.sun.java.util.collections.Set");
        s_interfaceForCollection.put("com.sun.java.util.collections.TreeSet", "com.sun.java.util.collections.Set");
        s_interfaceForCollection.put("com.sun.java.util.collections.Vector", "com.sun.java.util.collections.List");
        s_interfaceForCollection.put("com.sun.java.util.collections.ArrayList", "com.sun.java.util.collections.List");
        s_interfaceForCollection.put("com.sun.java.util.collections.LinkedList", "com.sun.java.util.collections.List");
        s_interfaceForCollection.put("com.sun.java.util.collections.TreeMap", "com.sun.java.util.collections.Map");
        s_interfaceForCollection.put("com.sun.java.util.collections.HashMap", "com.sun.java.util.collections.Map");
        s_interfaceForCollection.put("com.sun.java.util.collections.Hashtable", "com.sun.java.util.collections.Map");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedCollection";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/CollectionUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstantEmptyArray";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isCollectionOrMapSize";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getBaseCollection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

