/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoolUtils {
    private static final CallMatcher STREAM_ANY_MATCH = CallMatcher.instanceCall("java.util.stream.Stream", "anyMatch");
    private static final CallMatcher STREAM_NONE_MATCH = CallMatcher.instanceCall("java.util.stream.Stream", "noneMatch");
    private static final CallMatcher OPTIONAL_IS_PRESENT = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.util.Optional", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalInt", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalLong", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalDouble", "isPresent").parameterCount(0));
    private static final CallMatcher OPTIONAL_IS_EMPTY = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.util.Optional", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalInt", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalLong", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalDouble", "isEmpty").parameterCount(0));
    private static final List<PredicatedReplacement> ourReplacements = new ArrayList<PredicatedReplacement>();

    private BoolUtils() {
    }

    public static boolean isNegation(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            BoolUtils.$$$reportNull$$$0(0);
        }
        if (!(expression2 instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)expression2;
        IElementType tokenType = prefixExp.getOperationTokenType();
        return JavaTokenType.EXCL.equals(tokenType);
    }

    public static boolean isNegated(PsiExpression exp) {
        PsiExpression ancestor = exp;
        PsiElement parent = ancestor.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)parent;
            parent = ancestor.getParent();
        }
        return parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
    }

    @Nullable
    public static PsiExpression getNegated(PsiExpression expression2) {
        if (!(expression2 instanceof PsiPrefixExpression)) {
            return null;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (!JavaTokenType.EXCL.equals(tokenType)) {
            return null;
        }
        PsiExpression operand2 = prefixExpression.getOperand();
        PsiExpression stripped = ParenthesesUtils.stripParentheses(operand2);
        return stripped == null ? operand2 : stripped;
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression condition2) {
        String string = BoolUtils.getNegatedExpressionText(condition2, new CommentTracker());
        if (string == null) {
            BoolUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression condition2, CommentTracker tracker) {
        String string = BoolUtils.getNegatedExpressionText(condition2, 18, tracker);
        if (string == null) {
            BoolUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static String findSmartMethodNegation(PsiExpression expression2) {
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
        PsiMethodCallExpression copy = (PsiMethodCallExpression)call.copy();
        for (PredicatedReplacement predicatedReplacement : ourReplacements) {
            if (!predicatedReplacement.predicate.test(call)) continue;
            ExpressionUtils.bindCallTo(copy, predicatedReplacement.name);
            return copy.getText();
        }
        return null;
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression expression2, int precedence, CommentTracker tracker) {
        Object value2;
        PsiExpression negated;
        PsiParenthesizedExpression parenthesizedExpression;
        PsiExpression operand2;
        String smartNegation;
        if (expression2 == null) {
            if ("" == null) {
                BoolUtils.$$$reportNull$$$0(3);
            }
            return "";
        }
        if (expression2 instanceof PsiMethodCallExpression && (smartNegation = BoolUtils.findSmartMethodNegation(expression2)) != null) {
            String string = smartNegation;
            if (string == null) {
                BoolUtils.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (expression2 instanceof PsiParenthesizedExpression && (operand2 = (parenthesizedExpression = (PsiParenthesizedExpression)expression2).getExpression()) != null) {
            String string = '(' + BoolUtils.getNegatedExpressionText(operand2, tracker) + ')';
            if (string == null) {
                BoolUtils.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression2;
            boolean needParenthesis = ParenthesesUtils.getPrecedence((PsiExpression)conditionalExpression) >= precedence;
            String text2 = tracker.text((PsiElement)conditionalExpression.getCondition()) + '?' + BoolUtils.getNegatedExpressionText(conditionalExpression.getThenExpression(), tracker) + ':' + BoolUtils.getNegatedExpressionText(conditionalExpression.getElseExpression(), tracker);
            String string = needParenthesis ? "(" + text2 + ")" : text2;
            if (string == null) {
                BoolUtils.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (BoolUtils.isNegation(expression2) && (negated = BoolUtils.getNegated(expression2)) != null) {
            String string = ParenthesesUtils.getText(tracker.markUnchanged(negated), precedence);
            if (string == null) {
                BoolUtils.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            if (ComparisonUtils.isComparison((PsiExpression)polyadicExpression)) {
                String negatedComparison = ComparisonUtils.getNegatedComparison(tokenType);
                StringBuilder result = new StringBuilder();
                boolean isEven = (operands2.length & 1) != 1;
                int length = operands2.length;
                for (int i = 0; i < length; ++i) {
                    PsiExpression operand3 = operands2[i];
                    if (TypeUtils.hasFloatingPointType(operand3) && !ComparisonUtils.isEqualityComparison((PsiExpression)polyadicExpression)) {
                        String string = "!(" + polyadicExpression.getText() + ')';
                        if (string == null) {
                            BoolUtils.$$$reportNull$$$0(8);
                        }
                        return string;
                    }
                    if (i > 0) {
                        if (isEven && (i & 1) != 1) {
                            PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(operand3);
                            if (token != null) {
                                result.append(token.getText());
                            }
                        } else {
                            result.append(negatedComparison);
                        }
                    }
                    result.append(tracker.text((PsiElement)operand3));
                }
                String string = result.toString();
                if (string == null) {
                    BoolUtils.$$$reportNull$$$0(9);
                }
                return string;
            }
            if (tokenType.equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR)) {
                int newPrecedence;
                String targetToken;
                if (tokenType.equals(JavaTokenType.ANDAND)) {
                    targetToken = "||";
                    newPrecedence = 14;
                } else {
                    targetToken = "&&";
                    newPrecedence = 13;
                }
                Function replacer = child -> {
                    if (child instanceof PsiExpression) {
                        return BoolUtils.getNegatedExpressionText((PsiExpression)child, newPrecedence, tracker);
                    }
                    return child instanceof PsiJavaToken ? targetToken : tracker.text((PsiElement)child);
                };
                String join = StringUtil.join((Object[])polyadicExpression.getChildren(), (Function)replacer, (String)"");
                String string = newPrecedence > precedence ? '(' + join + ')' : join;
                if (string == null) {
                    BoolUtils.$$$reportNull$$$0(10);
                }
                return string;
            }
        }
        if (expression2 instanceof PsiLiteralExpression && (value2 = ((PsiLiteralExpression)expression2).getValue()) instanceof Boolean) {
            String string = String.valueOf((Boolean)value2 == false);
            if (string == null) {
                BoolUtils.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = '!' + ParenthesesUtils.getText(tracker.markUnchanged(expression2), 3);
        if (string == null) {
            BoolUtils.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public static PsiExpression findNegation(PsiExpression expression2) {
        PsiPrefixExpression prefixAncestor;
        PsiExpression ancestor = expression2;
        PsiElement parent = ancestor.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)parent;
            parent = ancestor.getParent();
        }
        if (parent instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals((prefixAncestor = (PsiPrefixExpression)parent).getOperationTokenType())) {
            return prefixAncestor;
        }
        return null;
    }

    public static boolean isBooleanLiteral(PsiExpression expression2) {
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression2;
        String text2 = literalExpression.getText();
        return "true".equals(text2) || "false".equals(text2);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isTrue(@Nullable PsiExpression expression2) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
            return false;
        }
        return "true".equals(expression2.getText());
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isFalse(@Nullable PsiExpression expression2) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
            return false;
        }
        return "false".equals(expression2.getText());
    }

    @Contract(value="null, _ -> false; _, null -> false", pure=true)
    public static boolean areExpressionsOpposite(@Nullable PsiExpression expression1, @Nullable PsiExpression expression2) {
        expression1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression1);
        expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        if (expression1 == null || expression2 == null) {
            return false;
        }
        EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
        if (BoolUtils.isNegation(expression1)) {
            return equivalence.expressionsAreEquivalent(BoolUtils.getNegated(expression1), expression2);
        }
        if (BoolUtils.isNegation(expression2)) {
            return equivalence.expressionsAreEquivalent(BoolUtils.getNegated(expression2), expression1);
        }
        if (expression1 instanceof PsiBinaryExpression && expression2 instanceof PsiBinaryExpression) {
            PsiBinaryExpression binOp1 = (PsiBinaryExpression)expression1;
            PsiBinaryExpression binOp2 = (PsiBinaryExpression)expression2;
            DfaRelationValue.RelationType rel1 = DfaRelationValue.RelationType.fromElementType(binOp1.getOperationTokenType());
            DfaRelationValue.RelationType rel2 = DfaRelationValue.RelationType.fromElementType(binOp2.getOperationTokenType());
            if (rel1 == null || rel2 == null) {
                return false;
            }
            PsiType type2 = binOp1.getLOperand().getType();
            if (type2 == null || type2.equals(PsiType.FLOAT) || type2.equals(PsiType.DOUBLE)) {
                return false;
            }
            if (rel1 == rel2.getNegated()) {
                return equivalence.expressionsAreEquivalent(binOp1.getLOperand(), binOp2.getLOperand()) && equivalence.expressionsAreEquivalent(binOp1.getROperand(), binOp2.getROperand());
            }
            if (rel1.getFlipped() == rel2.getNegated()) {
                return equivalence.expressionsAreEquivalent(binOp1.getLOperand(), binOp2.getROperand()) && equivalence.expressionsAreEquivalent(binOp1.getROperand(), binOp2.getLOperand());
            }
        }
        return false;
    }

    static {
        ourReplacements.add(new PredicatedReplacement(OPTIONAL_IS_EMPTY, "isPresent"));
        ourReplacements.add(new PredicatedReplacement(OPTIONAL_IS_PRESENT.withLanguageLevelAtLeast(LanguageLevel.JDK_11), "isEmpty"));
        ourReplacements.add(new PredicatedReplacement(STREAM_ANY_MATCH, "noneMatch"));
        ourReplacements.add(new PredicatedReplacement(STREAM_NONE_MATCH, "anyMatch"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/BoolUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/BoolUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNegatedExpressionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNegation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PredicatedReplacement {
        Predicate<PsiMethodCallExpression> predicate;
        String name;

        private PredicatedReplacement(Predicate<PsiMethodCallExpression> predicate, String name2) {
            this.predicate = predicate;
            this.name = name2;
        }
    }
}

