/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.hash.HashSet;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IfStatementMissingBreakInLoopInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inspection.if.statement.missing.break.in.loop.name", new Object[0]);
        if (string == null) {
            IfStatementMissingBreakInLoopInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("inspection.if.statement.missing.break.in.loop.name", new Object[0]);
        if (string == null) {
            IfStatementMissingBreakInLoopInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfStatementMissingBreakInLoopVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IfStatementMissingBreakInLoopFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/IfStatementMissingBreakInLoopInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class IfStatementMissingBreakInLoopFix
    extends InspectionGadgetsFix {
        private IfStatementMissingBreakInLoopFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)descriptor.getPsiElement().getParent(), PsiIfStatement.class);
            if (ifStatement == null || ifStatement.getElseBranch() != null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiStatement breakStatement = factory.createStatementFromText("break;", null);
            PsiCodeBlock block = IfStatementMissingBreakInLoopFix.getBlock(thenBranch);
            if (block == null) {
                return;
            }
            block.addBefore((PsiElement)breakStatement, block.getLastChild());
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)ifStatement);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.if.statement.missing.break.in.loop.quickfix", new Object[0]);
            if (string == null) {
                IfStatementMissingBreakInLoopFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        private static PsiCodeBlock getBlock(@NotNull PsiStatement thenBranch) {
            if (thenBranch == null) {
                IfStatementMissingBreakInLoopFix.$$$reportNull$$$0(1);
            }
            if (thenBranch instanceof PsiBlockStatement) {
                return ((PsiBlockStatement)thenBranch).getCodeBlock();
            }
            PsiStatement statementInBlock = BlockUtils.expandSingleStatementToBlockStatement(thenBranch);
            return (PsiCodeBlock)ObjectUtils.tryCast((Object)statementInBlock.getParent(), PsiCodeBlock.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/IfStatementMissingBreakInLoopInspection$IfStatementMissingBreakInLoopFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenBranch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/IfStatementMissingBreakInLoopInspection$IfStatementMissingBreakInLoopFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getBlock";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IfStatementMissingBreakInLoopVisitor
    extends BaseInspectionVisitor {
        private IfStatementMissingBreakInLoopVisitor() {
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            PsiStatement body2 = statement.getBody();
            if (body2 == null) {
                return;
            }
            PsiParameter parameter2 = statement.getIterationParameter();
            HashSet nonFinalVariables = new HashSet();
            nonFinalVariables.add(parameter2);
            HashSet declaredVariables = new HashSet();
            declaredVariables.add(parameter2);
            this.visitLoopBody(body2, (Set<PsiVariable>)nonFinalVariables, (Set<PsiVariable>)declaredVariables);
        }

        public void visitForStatement(PsiForStatement statement) {
            PsiStatement update2;
            PsiStatement body2 = statement.getBody();
            if (body2 == null) {
                return;
            }
            HashSet nonFinalVariables = new HashSet();
            HashSet declaredVariables = new HashSet();
            PsiDeclarationStatement initialization = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)statement.getInitialization(), PsiDeclarationStatement.class);
            if (initialization != null) {
                IfStatementMissingBreakInLoopVisitor.collectVariables(initialization, (PsiStatement)statement, (Set<PsiVariable>)nonFinalVariables, (Set<? super PsiVariable>)declaredVariables);
            }
            if ((update2 = statement.getUpdate()) != null && IfStatementMissingBreakInLoopVisitor.mayHaveOutsideOfLoopSideEffects((PsiElement)update2, (Set<PsiVariable>)declaredVariables)) {
                return;
            }
            PsiExpression condition2 = statement.getCondition();
            if (condition2 != null && IfStatementMissingBreakInLoopVisitor.mayHaveOutsideOfLoopSideEffects((PsiElement)condition2, (Set<PsiVariable>)declaredVariables)) {
                return;
            }
            this.visitLoopBody(body2, (Set<PsiVariable>)nonFinalVariables, (Set<PsiVariable>)declaredVariables);
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            this.visitLoopStatement((PsiLoopStatement)statement, statement.getCondition());
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            this.visitLoopStatement((PsiLoopStatement)statement, statement.getCondition());
        }

        private void visitLoopStatement(@NotNull PsiLoopStatement loopStatement, @Nullable PsiExpression condition2) {
            PsiStatement body2;
            if (loopStatement == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(0);
            }
            if ((body2 = loopStatement.getBody()) == null) {
                return;
            }
            HashSet nonFinalVariables = new HashSet();
            HashSet declaredVariables = new HashSet();
            if (condition2 != null) {
                if (IfStatementMissingBreakInLoopVisitor.mayHaveOutsideOfLoopSideEffects((PsiElement)condition2, (Set<PsiVariable>)declaredVariables)) {
                    return;
                }
                Set<PsiVariable> conditionVariables = VariableAccessUtils.collectUsedVariables((PsiElement)condition2);
                declaredVariables.addAll(conditionVariables);
                nonFinalVariables.addAll(conditionVariables);
            }
            this.visitLoopBody(body2, (Set<PsiVariable>)nonFinalVariables, (Set<PsiVariable>)declaredVariables);
        }

        private void visitLoopBody(@NotNull PsiStatement loopBody, @NotNull Set<PsiVariable> nonFinalVariables, @NotNull Set<PsiVariable> declaredVariables) {
            PsiStatement[] statements;
            if (loopBody == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(1);
            }
            if (nonFinalVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(2);
            }
            if (declaredVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(3);
            }
            if (!IfStatementMissingBreakInLoopVisitor.hasMissingBreakCandidates(statements = IfStatementMissingBreakInLoopVisitor.getStatements(loopBody))) {
                return;
            }
            PsiIfStatement ifStatementMissingBreak = null;
            for (PsiStatement statement : statements) {
                if (statement instanceof PsiDeclarationStatement) {
                    IfStatementMissingBreakInLoopVisitor.collectVariables((PsiDeclarationStatement)statement, loopBody, nonFinalVariables, declaredVariables);
                } else if (statement instanceof PsiIfStatement) {
                    PsiIfStatement ifStatement = (PsiIfStatement)statement;
                    PsiExpression condition2 = ifStatement.getCondition();
                    if (condition2 == null || IfStatementMissingBreakInLoopVisitor.mayHaveOutsideOfLoopSideEffects((PsiElement)condition2, declaredVariables)) {
                        return;
                    }
                    if (IfStatementMissingBreakInLoopVisitor.isMissingBreak(ifStatement, nonFinalVariables, declaredVariables)) {
                        if (ifStatementMissingBreak != null) {
                            return;
                        }
                        ifStatementMissingBreak = ifStatement;
                        continue;
                    }
                }
                if (!IfStatementMissingBreakInLoopVisitor.mayHaveOutsideOfLoopSideEffects((PsiElement)statement, declaredVariables)) continue;
                return;
            }
            if (ifStatementMissingBreak == null) {
                return;
            }
            this.registerError(ifStatementMissingBreak.getFirstChild(), new Object[0]);
        }

        private static boolean hasMissingBreakCandidates(PsiStatement[] statements) {
            return Arrays.stream(statements).filter(s -> s instanceof PsiIfStatement).map(s -> IfStatementMissingBreakInLoopVisitor.getStatements((PsiIfStatement)s)).filter(ss -> ((PsiStatement[])ss).length != 0).anyMatch(ss -> Arrays.stream(ss).allMatch(s -> IfStatementMissingBreakInLoopVisitor.getAssignment(s) != null));
        }

        @NotNull
        private static PsiStatement[] getStatements(@NotNull PsiIfStatement ifStatement) {
            if (ifStatement == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(4);
            }
            if (ifStatement.getElseBranch() != null) {
                if (PsiStatement.EMPTY_ARRAY == null) {
                    IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(5);
                }
                return PsiStatement.EMPTY_ARRAY;
            }
            PsiStatement branch = ifStatement.getThenBranch();
            if (branch == null) {
                if (PsiStatement.EMPTY_ARRAY == null) {
                    IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(6);
                }
                return PsiStatement.EMPTY_ARRAY;
            }
            PsiStatement[] psiStatementArray = IfStatementMissingBreakInLoopVisitor.getStatements(branch);
            if (psiStatementArray == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(7);
            }
            return psiStatementArray;
        }

        @Nullable
        private static PsiAssignmentExpression getAssignment(@NotNull PsiStatement statement) {
            if (statement == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(8);
            }
            if (!(statement instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpression expression2 = ((PsiExpressionStatement)statement).getExpression();
            if (!(expression2 instanceof PsiAssignmentExpression)) {
                return null;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
            if (!JavaTokenType.EQ.equals(assignment.getOperationTokenType())) {
                return null;
            }
            return assignment;
        }

        private static boolean isMissingBreak(@NotNull PsiIfStatement ifStatement, @NotNull Set<PsiVariable> nonFinalVariables, @NotNull Set<PsiVariable> declaredVariables) {
            PsiStatement[] statements;
            if (ifStatement == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(9);
            }
            if (nonFinalVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(10);
            }
            if (declaredVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(11);
            }
            if ((statements = IfStatementMissingBreakInLoopVisitor.getStatements(ifStatement)).length == 0) {
                return false;
            }
            HashSet usedVariables = new HashSet();
            for (PsiStatement statement : statements) {
                PsiAssignmentExpression assignment = IfStatementMissingBreakInLoopVisitor.getAssignment(statement);
                if (assignment == null) {
                    return false;
                }
                PsiExpression lhs = assignment.getLExpression();
                Set<PsiVariable> lhsVariables = VariableAccessUtils.collectUsedVariables((PsiElement)lhs);
                if (IfStatementMissingBreakInLoopVisitor.haveCommonElements(lhsVariables, nonFinalVariables) || IfStatementMissingBreakInLoopVisitor.mayHaveOutsideOfLoopSideEffects((PsiElement)lhs, declaredVariables)) {
                    return false;
                }
                PsiExpression rhs = assignment.getRExpression();
                if (rhs == null) {
                    return false;
                }
                Set<PsiVariable> rhsVariables = VariableAccessUtils.collectUsedVariables((PsiElement)rhs);
                if (IfStatementMissingBreakInLoopVisitor.haveCommonElements(rhsVariables, nonFinalVariables) || IfStatementMissingBreakInLoopVisitor.mayHaveOutsideOfLoopSideEffects((PsiElement)rhs, declaredVariables)) {
                    return false;
                }
                usedVariables.addAll(rhsVariables);
                if (usedVariables.addAll(lhsVariables)) continue;
                return false;
            }
            return true;
        }

        private static boolean haveCommonElements(Set<PsiVariable> s1, Set<PsiVariable> s2) {
            return !Collections.disjoint(s2, s1);
        }

        private static void collectVariables(@NotNull PsiDeclarationStatement declaration2, @NotNull PsiStatement scope, @NotNull Set<PsiVariable> nonFinalVariables, @NotNull Set<? super PsiVariable> declaredVariables) {
            if (declaration2 == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(12);
            }
            if (scope == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(13);
            }
            if (nonFinalVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(14);
            }
            if (declaredVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(15);
            }
            Set<PsiVariable> usedVariables = VariableAccessUtils.collectUsedVariables((PsiElement)declaration2);
            boolean hasNonFinalVariables = IfStatementMissingBreakInLoopVisitor.haveCommonElements(usedVariables, nonFinalVariables);
            for (PsiElement element : declaration2.getDeclaredElements()) {
                if (!(element instanceof PsiVariable)) continue;
                PsiVariable variable = (PsiVariable)element;
                declaredVariables.add((PsiVariable)variable);
                if (!hasNonFinalVariables && HighlightControlFlowUtil.isEffectivelyFinal(variable, (PsiElement)scope, null)) continue;
                nonFinalVariables.add(variable);
            }
        }

        @NotNull
        @Contract(value="null -> new")
        private static PsiStatement[] getStatements(@NotNull PsiStatement statement) {
            if (statement == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(16);
            }
            if (statement instanceof PsiBlockStatement) {
                PsiStatement[] psiStatementArray = ((PsiBlockStatement)statement).getCodeBlock().getStatements();
                if (psiStatementArray == null) {
                    IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(17);
                }
                return psiStatementArray;
            }
            PsiStatement[] psiStatementArray = new PsiStatement[]{statement};
            if (psiStatementArray == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(18);
            }
            return psiStatementArray;
        }

        private static boolean mayHaveOutsideOfLoopSideEffects(@NotNull PsiElement element, @NotNull Set<PsiVariable> declaredVariables) {
            if (element == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(19);
            }
            if (declaredVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(20);
            }
            return SideEffectChecker.mayHaveSideEffects(element, e -> IfStatementMissingBreakInLoopVisitor.isLoopOnlySideEffect(e, declaredVariables));
        }

        private static boolean isLoopOnlySideEffect(PsiElement e, @NotNull Set<PsiVariable> declaredVariables) {
            if (declaredVariables == null) {
                IfStatementMissingBreakInLoopVisitor.$$$reportNull$$$0(21);
            }
            if (e instanceof PsiContinueStatement || e instanceof PsiBreakStatement || e instanceof PsiVariable) {
                return true;
            }
            PsiExpression operand2 = null;
            if (e instanceof PsiUnaryExpression) {
                operand2 = ((PsiUnaryExpression)e).getOperand();
            } else if (e instanceof PsiAssignmentExpression) {
                operand2 = ((PsiAssignmentExpression)e).getLExpression();
            }
            if (operand2 == null) {
                return false;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2), PsiReferenceExpression.class);
            if (ref == null) {
                return true;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
            return variable == null || declaredVariables.contains(variable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopBody";
                    break;
                }
                case 2: 
                case 10: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nonFinalVariables";
                    break;
                }
                case 3: 
                case 11: 
                case 15: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaredVariables";
                    break;
                }
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/IfStatementMissingBreakInLoopInspection$IfStatementMissingBreakInLoopVisitor";
                    break;
                }
                case 8: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/IfStatementMissingBreakInLoopInspection$IfStatementMissingBreakInLoopVisitor";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLoopStatement";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLoopBody";
                    break;
                }
                case 4: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatements";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 18: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getAssignment";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isMissingBreak";
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "collectVariables";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "mayHaveOutsideOfLoopSideEffects";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "isLoopOnlySideEffect";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 17: 
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

